/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.utils;

import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class BlockPosUtil {
    public static final BlockPos MAX = new BlockPos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    public static final BlockPos MIN = new BlockPos(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);

    public static int getBlockCountInside(BlockPos p1, BlockPos p2) {
        return BlockPosUtil.getXDist(p1, p2) * BlockPosUtil.getYDist(p1, p2) * BlockPosUtil.getZDist(p1, p2);
    }

    public static int getXDist(BlockPos p1, BlockPos p2) {
        return Math.abs(p1.m_123341_() - p2.m_123341_());
    }

    public static int getYDist(BlockPos p1, BlockPos p2) {
        return Math.abs(p1.m_123342_() - p2.m_123342_());
    }

    public static int getZDist(BlockPos p1, BlockPos p2) {
        return Math.abs(p1.m_123343_() - p2.m_123343_());
    }

    public static BlockPos getMin(BlockPos p1, BlockPos p2) {
        return new BlockPos(Math.min(p1.m_123341_(), p2.m_123341_()), Math.min(p1.m_123342_(), p2.m_123342_()), Math.min(p1.m_123343_(), p2.m_123343_()));
    }

    public static BlockPos getMax(BlockPos p1, BlockPos p2) {
        return new BlockPos(Math.max(p1.m_123341_(), p2.m_123341_()), Math.max(p1.m_123342_(), p2.m_123342_()), Math.max(p1.m_123343_(), p2.m_123343_()));
    }

    public static void setMin(BlockPos.MutableBlockPos p1, BlockPos p2) {
        p1.m_122178_(Math.min(p1.m_123341_(), p2.m_123341_()), Math.min(p1.m_123342_(), p2.m_123342_()), Math.min(p1.m_123343_(), p2.m_123343_()));
    }

    public static void setMax(BlockPos.MutableBlockPos p1, BlockPos p2) {
        p1.m_122178_(Math.max(p1.m_123341_(), p2.m_123341_()), Math.max(p1.m_123342_(), p2.m_123342_()), Math.max(p1.m_123343_(), p2.m_123343_()));
    }

    public static BlockPos getCenter(BlockPos p1, BlockPos p2) {
        BlockPos min = BlockPosUtil.getMin(p1, p2);
        return new BlockPos(BlockPosUtil.getXDist(p1, p2) / 2 + min.m_123341_(), BlockPosUtil.getYDist(p1, p2) / 2 + min.m_123342_(), BlockPosUtil.getYDist(p1, p2) / 2 + min.m_123342_());
    }

    public static Vector3f getCenterF(BlockPos p1, BlockPos p2) {
        BlockPos min = BlockPosUtil.getMin(p1, p2);
        return BlockPosUtil.getCenterF(min.m_123341_(), min.m_123342_(), min.m_123343_(), BlockPosUtil.getXDist(p1, p2), BlockPosUtil.getYDist(p1, p2), BlockPosUtil.getZDist(p1, p2));
    }

    public static Vector3f getCenterF(int oX, int oY, int oZ, int dX, int dY, int dZ) {
        return new Vector3f((float)dX / 2.0f + (float)oX, (float)dY / 2.0f + (float)oY, (float)dZ / 2.0f + (float)oZ);
    }

    public static Vec3 getCenterD(BlockPos p1, BlockPos p2) {
        BlockPos min = BlockPosUtil.getMin(p1, p2);
        return BlockPosUtil.getCenterD(min.m_123341_(), min.m_123342_(), min.m_123343_(), BlockPosUtil.getXDist(p1, p2), BlockPosUtil.getYDist(p1, p2), BlockPosUtil.getZDist(p1, p2));
    }

    public static Vec3 getCenterD(int oX, int oY, int oZ, int dX, int dY, int dZ) {
        return new Vec3((double)dX / 2.0 + (double)oX, (double)dY / 2.0 + (double)oY, (double)dZ / 2.0 + (double)oZ);
    }

    public static Iterable<BlockPos> getAllInside(BlockPos p1, BlockPos p2, boolean includeBorder) {
        int x0 = Math.min(p1.m_123341_(), p2.m_123341_());
        int y0 = Math.min(p1.m_123342_(), p2.m_123342_());
        int z0 = Math.min(p1.m_123343_(), p2.m_123343_());
        int x1 = Math.max(p1.m_123341_(), p2.m_123341_());
        int y1 = Math.max(p1.m_123342_(), p2.m_123342_());
        int z1 = Math.max(p1.m_123343_(), p2.m_123343_());
        if (includeBorder) {
            --x0;
            --y0;
            --z0;
        } else {
            --x1;
            --y1;
            --z1;
        }
        return BlockPos.m_121976_((int)x0, (int)y0, (int)z0, (int)x1, (int)y1, (int)z1);
    }

    public static boolean isOnBorder(BlockPos boxMin, BlockPos boxMax, BlockPos p) {
        return p.m_123341_() == boxMin.m_123341_() || p.m_123341_() == boxMax.m_123341_() || p.m_123342_() == boxMin.m_123342_() || p.m_123342_() == boxMax.m_123342_() || p.m_123343_() == boxMin.m_123343_() || p.m_123343_() == boxMax.m_123343_();
    }
}

