/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.theme;

import brachy.modularui.api.IThemeApi;
import brachy.modularui.theme.WidgetTheme;
import brachy.modularui.theme.WidgetThemeKey;
import brachy.modularui.theme.WidgetThemeParser;
import com.google.gson.JsonObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;

public class WidgetThemeKeyBuilder<T extends WidgetTheme> {
    private final String id;
    private T defaultTheme;
    private T defaultHoverTheme;
    private WidgetThemeParser<T> parser;

    public WidgetThemeKeyBuilder(String id) {
        this.id = id;
    }

    public WidgetThemeKeyBuilder<T> defaultTheme(T defaultTheme) {
        this.defaultTheme = defaultTheme;
        return this;
    }

    public WidgetThemeKeyBuilder<T> defaultHoverTheme(T defaultHoverTheme) {
        this.defaultHoverTheme = defaultHoverTheme;
        return this;
    }

    public WidgetThemeKeyBuilder<T> parser(WidgetThemeParser<T> parser) {
        this.parser = parser;
        return this;
    }

    public WidgetThemeKey<T> register() {
        Objects.requireNonNull(this.id, "Id for widget theme must not be null");
        Objects.requireNonNull(this.defaultTheme, "Default theme for widget theme must not be null, but is null for id '" + this.id + "'.");
        if (this.parser == null) {
            this.parser = this.createParserWithReflection();
        }
        if (this.defaultHoverTheme == null) {
            WidgetTheme hover = ((WidgetTheme)this.defaultTheme).withNoHoverBackground();
            if (hover.getClass() != this.defaultTheme.getClass()) {
                throw new IllegalArgumentException("Tried to create a default hover theme, but method withNoHoverBackground()is not overridden to create its type");
            }
            this.defaultHoverTheme = hover;
        }
        return IThemeApi.get().registerWidgetTheme(this.id, this.defaultTheme, this.defaultHoverTheme, this.parser);
    }

    private WidgetThemeParser<T> createParserWithReflection() {
        Class<?> type = this.defaultTheme.getClass();
        try {
            Constructor<?> ctor = type.getConstructor(type, JsonObject.class, JsonObject.class);
            return (parent, json, fallback) -> {
                try {
                    return (WidgetTheme)ctor.newInstance(parent, json, fallback);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException("Failed to instantiate widget theme of type " + type.getSimpleName(), e);
                }
            };
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(String.format("No constructor with signature '%s(%s parent, JsonObject json, JsonObject fallback)' found", type.getSimpleName(), type.getSimpleName()));
        }
    }
}

