/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.theme;

import brachy.modularui.api.drawable.IDrawable;
import brachy.modularui.theme.ThemeAPI;
import brachy.modularui.theme.WidgetThemeEntry;
import brachy.modularui.utils.Color;
import brachy.modularui.utils.serialization.json.JsonHelper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;

public class WidgetTheme {
    private final int defaultWidth;
    private final int defaultHeight;
    @Nullable
    private final IDrawable background;
    private final int color;
    private final int textColor;
    private final boolean textShadow;
    private final int iconColor;

    public static WidgetThemeEntry<WidgetTheme> getDefault() {
        return ThemeAPI.DEFAULT_THEME.getFallback();
    }

    public static WidgetTheme whiteTextShadow(int defaultWidth, int defaultHeight, @Nullable IDrawable background) {
        return new WidgetTheme(defaultWidth, defaultHeight, background, Color.WHITE.main, Color.WHITE.main, true, Color.WHITE.main);
    }

    public static WidgetTheme darkTextNoShadow(int defaultWidth, int defaultHeight, @Nullable IDrawable background) {
        return new WidgetTheme(defaultWidth, defaultHeight, background, Color.WHITE.main, -12566464, false, Color.WHITE.main);
    }

    public WidgetTheme(int defaultWidth, int defaultHeight, @Nullable IDrawable background, int color, int textColor, boolean textShadow, int iconColor) {
        this.defaultWidth = defaultWidth;
        this.defaultHeight = defaultHeight;
        this.background = background;
        this.color = color;
        this.textColor = textColor == 0 ? color : textColor;
        this.textShadow = textShadow;
        this.iconColor = iconColor == 0 ? color : iconColor;
    }

    public WidgetTheme(WidgetTheme parent, JsonObject json, JsonObject fallback) {
        this.defaultWidth = JsonHelper.getInt(json, parent.getDefaultWidth(), "w", "width");
        this.defaultHeight = JsonHelper.getInt(json, parent.getDefaultHeight(), "h", "height");
        this.background = JsonHelper.deserialize(json, IDrawable.class, parent.getBackground(), "background", "bg");
        this.color = JsonHelper.getColorWithFallback(json, WidgetTheme.inherits(json, "color") ? null : fallback, parent.getColor(), "color");
        int textColor = JsonHelper.getColorWithFallback(json, WidgetTheme.inherits(json, "textColor") ? null : fallback, parent.getTextColor(), "textColor");
        this.textColor = textColor == 0 ? this.color : textColor;
        this.textShadow = JsonHelper.getBoolWithFallback(json, WidgetTheme.inherits(json, "textShadow") ? null : fallback, parent.isTextShadow(), "textShadow");
        int iconColor = JsonHelper.getColorWithFallback(json, WidgetTheme.inherits(json, "iconColor") ? null : fallback, parent.getTextColor(), "textColor");
        this.iconColor = iconColor == 0 ? this.color : iconColor;
    }

    protected static boolean inherits(JsonObject json, String property) {
        if (!json.has("inherit")) {
            return false;
        }
        JsonElement element = json.get("inherit");
        if (element.isJsonPrimitive()) {
            return element.getAsString().equals(property);
        }
        if (element.isJsonArray()) {
            for (JsonElement e : element.getAsJsonArray()) {
                if (!e.isJsonPrimitive() || !e.getAsString().equals(property)) continue;
                return true;
            }
        }
        return false;
    }

    public WidgetTheme withNoHoverBackground() {
        return new WidgetTheme(this.defaultWidth, this.defaultHeight, IDrawable.NONE, this.color, this.textColor, this.textShadow, this.iconColor);
    }

    @Generated
    public int getDefaultWidth() {
        return this.defaultWidth;
    }

    @Generated
    public int getDefaultHeight() {
        return this.defaultHeight;
    }

    @Nullable
    @Generated
    public IDrawable getBackground() {
        return this.background;
    }

    @Generated
    public int getColor() {
        return this.color;
    }

    @Generated
    public int getTextColor() {
        return this.textColor;
    }

    @Generated
    public boolean isTextShadow() {
        return this.textShadow;
    }

    @Generated
    public int getIconColor() {
        return this.iconColor;
    }
}

