/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.theme;

import brachy.modularui.api.IThemeApi;
import brachy.modularui.api.drawable.IDrawable;
import brachy.modularui.drawable.DrawableSerialization;
import brachy.modularui.theme.WidgetTheme;
import brachy.modularui.theme.WidgetThemeBuilder;
import brachy.modularui.theme.WidgetThemeKey;
import brachy.modularui.utils.serialization.json.JsonBuilder;
import lombok.Generated;

public class ThemeBuilder<B extends ThemeBuilder<B>>
extends JsonBuilder {
    private final String id;
    private String parent;

    public ThemeBuilder(String id) {
        this.id = id;
    }

    protected B getThis() {
        return (B)this;
    }

    public B parent(String v) {
        this.add("parent", v);
        this.parent = v;
        return this.getThis();
    }

    public B defaultBackground(IDrawable v) {
        this.add("background", DrawableSerialization.serialize(v));
        return this.getThis();
    }

    public B defaultBackground(String textureId) {
        this.add("background", new JsonBuilder().add("type", "texture").add("id", textureId));
        return this.getThis();
    }

    public B defaultHoverBackground(IDrawable v) {
        this.mergeAdd(":hover", new JsonBuilder().add("background", DrawableSerialization.serialize(v)));
        return this.getThis();
    }

    public B defaultHoverBackground(String textureId) {
        this.mergeAdd(":hover", new JsonBuilder().add("background", new JsonBuilder().add("type", "texture").add("id", textureId)));
        return this.getThis();
    }

    public B defaultColor(int v) {
        this.add("color", v);
        return this.getThis();
    }

    public B defaultHoverColor(int v) {
        this.mergeAdd(":hover", new JsonBuilder().add("color", v));
        return this.getThis();
    }

    public B defaultTextColor(int v) {
        this.add("textColor", v);
        return this.getThis();
    }

    public B defaultTextHoverColor(int v) {
        this.mergeAdd(":hover", new JsonBuilder().add("textColor", v));
        return this.getThis();
    }

    public B defaultTextShadow(boolean v) {
        this.add("textShadow", v);
        return this.getThis();
    }

    public B defaultTextHoverShadow(boolean v) {
        this.mergeAdd(":hover", new JsonBuilder().add("textShadow", v));
        return this.getThis();
    }

    public B defaultIconColor(int v) {
        this.add("iconColor", v);
        return this.getThis();
    }

    public B defaultIconHoverColor(int v) {
        this.mergeAdd(":hover", new JsonBuilder().add("iconColor", v));
        return this.getThis();
    }

    public B defaultWidth(int v) {
        this.add("iconColor", v);
        return this.getThis();
    }

    public B defaultHeight(int v) {
        this.mergeAdd(":hover", new JsonBuilder().add("iconColor", v));
        return this.getThis();
    }

    public B background(WidgetThemeKey<?> widgetTheme, IDrawable v) {
        this.mergeAdd(widgetTheme.getFullName(), new JsonBuilder().add("background", DrawableSerialization.serialize(v)));
        return this.getThis();
    }

    public B background(WidgetThemeKey<?> widgetTheme, String textureId) {
        return this.background(widgetTheme, new JsonBuilder().add("type", "texture").add("id", textureId));
    }

    public B background(WidgetThemeKey<?> widgetTheme, JsonBuilder builder) {
        this.mergeAdd(widgetTheme.getFullName(), new JsonBuilder().add("background", builder));
        return this.getThis();
    }

    public B hoverBackground(WidgetThemeKey<?> widgetTheme, IDrawable v) {
        this.mergeAdd(widgetTheme.getFullName() + ":hover", new JsonBuilder().add("background", DrawableSerialization.serialize(v)));
        return this.getThis();
    }

    public B hoverBackground(WidgetThemeKey<?> widgetTheme, String textureId) {
        return this.hoverBackground(widgetTheme, new JsonBuilder().add("type", "texture").add("id", textureId));
    }

    public B hoverBackground(WidgetThemeKey<?> widgetTheme, JsonBuilder builder) {
        this.mergeAdd(widgetTheme.getFullName() + ":hover", new JsonBuilder().add("background", builder));
        return this.getThis();
    }

    public B color(WidgetThemeKey<?> widgetTheme, int v) {
        this.mergeAdd(widgetTheme.getFullName(), new JsonBuilder().add("color", v));
        return this.getThis();
    }

    public B hoverColor(WidgetThemeKey<?> widgetTheme, int v) {
        this.mergeAdd(widgetTheme.getFullName() + ":hover", new JsonBuilder().add("color", v));
        return this.getThis();
    }

    public B textColor(WidgetThemeKey<?> widgetTheme, int v) {
        this.mergeAdd(widgetTheme.getFullName(), new JsonBuilder().add("textColor", v));
        return this.getThis();
    }

    public B textHoverColor(WidgetThemeKey<?> widgetTheme, int v) {
        this.mergeAdd(widgetTheme.getFullName() + ":hover", new JsonBuilder().add("textColor", v));
        return this.getThis();
    }

    public B textShadow(WidgetThemeKey<?> widgetTheme, boolean v) {
        this.mergeAdd(widgetTheme.getFullName(), new JsonBuilder().add("textShadow", v));
        return this.getThis();
    }

    public B textHoverShadow(WidgetThemeKey<?> widgetTheme, boolean v) {
        this.mergeAdd(widgetTheme.getFullName() + ":hover", new JsonBuilder().add("textShadow", v));
        return this.getThis();
    }

    public B iconColor(WidgetThemeKey<?> widgetTheme, int v) {
        this.mergeAdd(widgetTheme.getFullName(), new JsonBuilder().add("iconColor", v));
        return this.getThis();
    }

    public B iconHoverColor(WidgetThemeKey<?> widgetTheme, int v) {
        this.mergeAdd(widgetTheme.getFullName() + ":hover", new JsonBuilder().add("iconColor", v));
        return this.getThis();
    }

    public B itemSlotHoverColor(int v) {
        this.mergeAdd(IThemeApi.ITEM_SLOT.getFullName(), new JsonBuilder().add("slotHoverColor", v));
        return this.getThis();
    }

    public B fluidSlotHoverColor(int v) {
        this.mergeAdd(IThemeApi.FLUID_SLOT.getName(), new JsonBuilder().add("slotHoverColor", v));
        return this.getThis();
    }

    public B textFieldMarkedColor(int v) {
        this.mergeAdd(IThemeApi.TEXT_FIELD.getName(), new JsonBuilder().add("markedColor", v));
        return this.getThis();
    }

    public B textFieldHintColor(int v) {
        this.mergeAdd(IThemeApi.TEXT_FIELD.getName(), new JsonBuilder().add("hintColor", v));
        return this.getThis();
    }

    public <T extends WidgetTheme> B widgetTheme(WidgetThemeKey<T> widgetThemeKey, WidgetThemeBuilder<T, ?> widgetThemeBuilder) {
        this.add(widgetThemeKey.getFullName(), widgetThemeBuilder);
        return this.getThis();
    }

    public <T extends WidgetTheme> B widgetThemeHover(WidgetThemeKey<T> widgetThemeKey, WidgetThemeBuilder<T, ?> widgetThemeBuilder) {
        this.add(widgetThemeKey.getFullName() + ":hover", widgetThemeBuilder);
        return this.getThis();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getParent() {
        return this.parent;
    }
}

