/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.theme;

import brachy.modularui.ModularUIConfig;
import brachy.modularui.api.ITheme;
import brachy.modularui.api.IThemeApi;
import brachy.modularui.theme.DefaultTheme;
import brachy.modularui.theme.WidgetTheme;
import brachy.modularui.theme.WidgetThemeKey;
import brachy.modularui.theme.WidgetThemeParser;
import brachy.modularui.utils.serialization.json.JsonBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeAPI
implements IThemeApi {
    public static final ThemeAPI INSTANCE = new ThemeAPI();
    public static final String DEFAULT_ID = "DEFAULT";
    public static final ITheme DEFAULT_THEME = DefaultTheme.INSTANCE;
    public static final Pattern widgetThemeNamePattern = Pattern.compile("[a-zA-z0-9$_-]+");
    private final Object2ObjectMap<String, ITheme> themes = new Object2ObjectOpenHashMap();
    protected final Object2ObjectMap<String, List<JsonBuilder>> defaultThemes = new Object2ObjectOpenHashMap();
    private final List<WidgetThemeKey<?>> keys = new ArrayList();
    protected final Object2ObjectOpenHashMap<String, String> jsonScreenThemes = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<String, String> screenThemes = new Object2ObjectOpenHashMap();

    private ThemeAPI() {
    }

    @Override
    public ITheme getDefaultTheme() {
        return DEFAULT_THEME;
    }

    @Override
    @NotNull
    public ITheme getTheme(String id) {
        return (ITheme)this.themes.getOrDefault((Object)id, (Object)this.getDefaultTheme());
    }

    @Override
    public boolean hasTheme(String id) {
        return this.themes.containsKey((Object)id);
    }

    @Override
    public void registerTheme(String id, JsonBuilder json) {
        List<JsonBuilder> themes = this.getJavaDefaultThemes(id);
        if (!themes.contains(json)) {
            themes.add(json);
        }
    }

    @Override
    public List<JsonBuilder> getJavaDefaultThemes(String id) {
        return (List)this.defaultThemes.computeIfAbsent((Object)id, key -> new ArrayList());
    }

    @Override
    public ITheme getThemeForScreen(String owner, String name, @Nullable String panel, @Nullable String defaultTheme, @Nullable String fallbackTheme) {
        String theme = this.getThemeIdForScreen(owner, name, panel);
        if (theme != null) {
            return this.getTheme(theme);
        }
        if (defaultTheme != null) {
            return this.getTheme(defaultTheme);
        }
        if (fallbackTheme != null) {
            return this.getTheme(fallbackTheme);
        }
        return this.getTheme(ModularUIConfig.useDarkThemeByDefault() ? "vanilla_dark" : "vanilla");
    }

    private String getThemeIdForScreen(String mod, String name, String panelName) {
        String fullName = mod + ":" + name;
        String fullPanelName = null;
        if (panelName != null) {
            fullPanelName = fullName + ":" + panelName;
        }
        String theme = null;
        if (fullPanelName != null && (theme = (String)this.jsonScreenThemes.get((Object)fullPanelName)) != null) {
            return theme;
        }
        theme = (String)this.jsonScreenThemes.get((Object)fullName);
        if (theme != null) {
            return theme;
        }
        theme = (String)this.jsonScreenThemes.get((Object)mod);
        if (theme != null) {
            return theme;
        }
        if (fullPanelName != null && (theme = (String)this.screenThemes.get((Object)fullPanelName)) != null) {
            return theme;
        }
        theme = (String)this.screenThemes.get((Object)fullName);
        return theme != null ? theme : (String)this.screenThemes.get((Object)mod);
    }

    @Override
    public void registerThemeForScreen(String screen, String theme) {
        Objects.requireNonNull(screen);
        Objects.requireNonNull(theme);
        this.screenThemes.put((Object)screen, (Object)theme);
    }

    @Override
    public <T extends WidgetTheme> WidgetThemeKey<T> registerWidgetTheme(String id, T defaultTheme, T defaultHoverTheme, WidgetThemeParser<T> parser) {
        Objects.requireNonNull(id, "Id for widget theme must not be null");
        Objects.requireNonNull(defaultTheme, "Default widget theme must not be null, but is null for id '" + id + "'.");
        Objects.requireNonNull(parser, "Parser for widget theme must not be null, but is null for id '" + id + "'.");
        if (WidgetThemeKey.getFromFullName(id) != null) {
            throw new IllegalStateException("there already is a widget theme for id '" + id + "' registered.");
        }
        if (!widgetThemeNamePattern.matcher(id).matches()) {
            throw new IllegalArgumentException("Widget theme id '" + id + "' is invalid. Id must only contain letters, numbers, underscores and minus.");
        }
        Class<?> type = defaultTheme.getClass();
        return new WidgetThemeKey(type, id, defaultTheme, defaultHoverTheme, parser);
    }

    @Override
    public List<WidgetThemeKey<?>> getWidgetThemeKeys() {
        return Collections.unmodifiableList(this.keys);
    }

    void registerTheme(ITheme theme) {
        if (this.themes.containsKey((Object)theme.getId())) {
            throw new IllegalArgumentException("Theme with id " + theme.getId() + " already exists!");
        }
        this.themes.put((Object)theme.getId(), (Object)theme);
    }

    void registerWidgetThemeKey(WidgetThemeKey<?> key) {
        this.keys.add(key);
    }

    void onReload() {
        this.themes.clear();
        this.jsonScreenThemes.clear();
        this.registerTheme(DEFAULT_THEME);
    }
}

