/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.theme;

import brachy.modularui.api.drawable.IDrawable;
import brachy.modularui.theme.WidgetTheme;
import brachy.modularui.theme.WidgetThemeBuilder;
import brachy.modularui.utils.Color;
import brachy.modularui.utils.serialization.json.JsonHelper;
import com.google.gson.JsonObject;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;

public class SlotTheme
extends WidgetTheme {
    private final int slotHoverColor;

    public SlotTheme(IDrawable background) {
        this(background, Color.withAlpha(Color.WHITE.main, 96));
    }

    public SlotTheme(IDrawable background, int slotHoverColor) {
        this(18, 18, background, Color.WHITE.main, -12566464, false, Color.WHITE.main, slotHoverColor);
    }

    public SlotTheme(int defaultWidth, int defaultHeight, @Nullable IDrawable background, int color, int textColor, boolean textShadow, int iconColor, int slotHoverColor) {
        super(defaultWidth, defaultHeight, background, color, textColor, textShadow, iconColor);
        this.slotHoverColor = slotHoverColor;
    }

    public SlotTheme(SlotTheme parent, JsonObject json, JsonObject fallback) {
        super(parent, json, fallback);
        this.slotHoverColor = JsonHelper.getColorWithFallback(json, fallback, parent.getSlotHoverColor(), "slotHoverColor");
    }

    @Override
    public WidgetTheme withNoHoverBackground() {
        return new SlotTheme(this.getDefaultWidth(), this.getDefaultHeight(), IDrawable.NONE, this.getColor(), this.getTextColor(), this.isTextShadow(), this.getIconColor(), this.slotHoverColor);
    }

    @Generated
    public int getSlotHoverColor() {
        return this.slotHoverColor;
    }

    public static class Builder<T extends SlotTheme, B extends Builder<T, B>>
    extends WidgetThemeBuilder<T, B> {
        public B hoverColor(int hoverColor) {
            this.add("slotHoverColor", hoverColor);
            return (B)((Builder)this.getThis());
        }
    }
}

