/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.theme;

import brachy.modularui.theme.AbstractTheme;
import brachy.modularui.theme.ThemeAPI;
import brachy.modularui.theme.WidgetTheme;
import brachy.modularui.theme.WidgetThemeEntry;
import brachy.modularui.theme.WidgetThemeKey;
import brachy.modularui.theme.WidgetThemeMap;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.UnmodifiableView;

public class DefaultTheme
extends AbstractTheme {
    public static final DefaultTheme INSTANCE = new DefaultTheme();
    private final WidgetThemeMap widgetThemes = new WidgetThemeMap();
    private boolean initialized = false;

    private DefaultTheme() {
        super("DEFAULT", null);
    }

    private void initialize() {
        if (!this.initialized) {
            this.initialized = true;
            for (WidgetThemeKey<?> key : ThemeAPI.INSTANCE.getWidgetThemeKeys()) {
                this.widgetThemes.put(key, DefaultTheme.entryOfKey(key));
            }
        }
    }

    @Override
    public @UnmodifiableView Collection<WidgetThemeEntry<?>> getWidgetThemes() {
        this.initialize();
        return Collections.unmodifiableCollection(this.widgetThemes.values());
    }

    @Override
    public <T extends WidgetTheme> WidgetThemeEntry<T> getWidgetTheme(WidgetThemeKey<T> key) {
        this.initialize();
        WidgetThemeEntry<T> widgetTheme = this.widgetThemes.getTheme(key);
        while (widgetTheme == null && key.isSubWidgetTheme()) {
            widgetTheme = this.widgetThemes.getTheme(key.getParent());
        }
        return widgetTheme;
    }

    private static <T extends WidgetTheme> WidgetThemeEntry<T> entryOfKey(WidgetThemeKey<T> key) {
        return new WidgetThemeEntry<T>(key, key.getDefaultValue(), key.getDefaultHoverValue());
    }
}

