/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.test;

import brachy.modularui.GTRenderTypes;
import brachy.modularui.ModularUI;
import brachy.modularui.animation.Animator;
import brachy.modularui.animation.SequentialAnimator;
import brachy.modularui.animation.Wait;
import brachy.modularui.api.IPanelHandler;
import brachy.modularui.api.IThemeApi;
import brachy.modularui.api.drawable.IDrawable;
import brachy.modularui.api.drawable.IKey;
import brachy.modularui.api.layout.IViewportStack;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.drawable.GuiDraw;
import brachy.modularui.drawable.GuiTextures;
import brachy.modularui.drawable.ItemDrawable;
import brachy.modularui.drawable.Rectangle;
import brachy.modularui.drawable.UITexture;
import brachy.modularui.drawable.graph.GraphDrawable;
import brachy.modularui.drawable.text.RichText;
import brachy.modularui.factory.ClientGUI;
import brachy.modularui.schema.ArraySchema;
import brachy.modularui.screen.CustomModularScreen;
import brachy.modularui.screen.ModularPanel;
import brachy.modularui.screen.ModularScreen;
import brachy.modularui.screen.viewport.ModularGuiContext;
import brachy.modularui.utils.Alignment;
import brachy.modularui.utils.Color;
import brachy.modularui.utils.ColorShade;
import brachy.modularui.utils.DAM;
import brachy.modularui.utils.Interpolation;
import brachy.modularui.utils.Interpolations;
import brachy.modularui.value.BoolValue;
import brachy.modularui.value.IntValue;
import brachy.modularui.value.ObjectValue;
import brachy.modularui.value.StringValue;
import brachy.modularui.widget.Widget;
import brachy.modularui.widgets.ButtonWidget;
import brachy.modularui.widgets.ColorPickerDialog;
import brachy.modularui.widgets.ListWidget;
import brachy.modularui.widgets.RichTextWidget;
import brachy.modularui.widgets.SchemaWidget;
import brachy.modularui.widgets.TextWidget;
import brachy.modularui.widgets.ToggleButton;
import brachy.modularui.widgets.TransformWidget;
import brachy.modularui.widgets.layout.Column;
import brachy.modularui.widgets.layout.Flow;
import brachy.modularui.widgets.layout.Grid;
import brachy.modularui.widgets.layout.Row;
import brachy.modularui.widgets.menu.ContextMenuButton;
import brachy.modularui.widgets.menu.DropdownWidget;
import brachy.modularui.widgets.textfield.TextFieldWidget;
import com.google.common.base.CaseFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.Util;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class TestGuis
extends CustomModularScreen {
    public static final IntList LIGHT_COLORS = (IntList)ColorShade.getAll().stream().filter(cs -> !cs.name.contains("accent")).filter(cs -> cs.brighterShadeCount() > 1).mapToInt(cs -> cs.brighter(1)).filter(c -> Color.getHSLSaturation(c) > 0.4f).collect(IntArrayList::new, IntList::add, IntList::addAll);
    public static boolean withCode = false;

    public TestGuis() {
        super("modularui");
    }

    @Override
    @NotNull
    public ModularPanel buildUI(ModularGuiContext context) {
        ArrayList<Method> uiMethods = new ArrayList<Method>();
        for (Method method : TestGuis.class.getDeclaredMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers()) || !ModularPanel.class.isAssignableFrom(method.getReturnType()) || method.getParameterCount() != 0) continue;
            uiMethods.add(method);
        }
        uiMethods.sort(Comparator.comparing(Method::getName));
        return (ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)new ModularPanel("client_tests").height(200)).width(170)).padding(7)).child((IWidget)((Flow)Flow.column().child((IWidget)IKey.str("Client Test UIs").asWidget().margin(1))).child((IWidget)((ListWidget)((ListWidget)new ListWidget().widthRel(1.0f)).expanded()).children(uiMethods.size(), i -> {
            Method m = (Method)uiMethods.get(i);
            String name = m.getName();
            if (name.startsWith("build")) {
                name = name.substring(5);
            }
            if (name.endsWith("UI")) {
                name = name.substring(0, name.length() - 2);
            }
            String codeTextureName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name);
            name = name.replaceAll("([a-z])([A-Z])", "$1 $2");
            return TestGuis.button(name).onMousePressed((x, y, button) -> {
                try {
                    ModularPanel panel = (ModularPanel)m.invoke(null, new Object[0]);
                    if (withCode) {
                        panel.child((IWidget)((Widget)UITexture.builder().location("gui/code/" + codeTextureName).build().asWidget().leftRel(1.0f)).heightRel(1.0f));
                    }
                    ClientGUI.open(new ModularScreen("modularui", panel).openParentOnClose(true));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    ModularUI.LOGGER.throwing((Throwable)e);
                }
                return true;
            });
        }).child(TestGuis.button("Test self").onMousePressed((x, y, button) -> {
            ClientGUI.open(this);
            return true;
        }))));
    }

    private static ButtonWidget<?> button(String text) {
        return (ButtonWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().height(16)).widthRel(1.0f)).margin(0, 1)).overlay(IKey.str(text));
    }

    @NotNull
    public static ModularPanel buildToggleGridListUI() {
        boolean[][] states = new boolean[4][16];
        return (ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)new ModularPanel("grid_list"){

            @Override
            public void onInit() {
                super.onInit();
                this.getScreen().useTheme("mui:test_theme");
            }
        }.height(100)).coverChildrenWidth()).padding(7)).child(((ListWidget)((ListWidget)new ListWidget().coverChildrenWidth()).heightRel(1.0f)).children(4, i -> ((Grid)((Grid)new Grid().left(0)).coverChildren()).mapTo(4, 16, j -> (ToggleButton)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().overlay(GuiTextures.BOOKMARK)).value(new BoolValue.Dynamic(() -> states[i][j], val -> {
            states[i][j] = val;
        })).size(10)).margin(1)).name("G:" + i + ",W:" + j))));
    }

    @NotNull
    public static ModularPanel buildPendulumAnimationUI() {
        IWidget widget = (IWidget)((Widget)GuiTextures.MUI_LOGO.asWidget().size(20)).pos(65, 65);
        Animator animator = ((Animator)((Animator)new Animator().bounds(0.0f, 1.0f).curve(Interpolation.SINE_INOUT).reverseOnFinish(true)).repeatsOnFinish(-1)).duration(1200);
        animator.reset(true);
        animator.animate(true);
        return (ModularPanel)((ModularPanel)ModularPanel.defaultPanel("main").size(150)).child(new TransformWidget(widget).transform(stack -> {
            double angle = Math.PI;
            float x = (float)(55.0 * Math.cos((double)animator.getValue() * angle));
            float y = (float)(55.0 * Math.sin((double)animator.getValue() * angle));
            stack.translate(x, y);
        }));
    }

    @NotNull
    public static ModularPanel buildPostTheLogAnimationUI() {
        Animator post = new Animator().curve(Interpolation.SINE_IN).duration(300).bounds(-35.0f, 0.0f);
        Animator the = new Animator().curve(Interpolation.SINE_IN).duration(300).bounds(-20.0f, 0.0f);
        Animator extraordinary = new Animator().curve(Interpolation.SINE_IN).duration(300).bounds(53.0f, 0.0f);
        Animator log = new Animator().curve(Interpolation.SINE_IN).duration(300).bounds(20.0f, 0.0f);
        Animator logGrow = new Animator().curve(Interpolation.LINEAR).duration(2500).bounds(0.0f, 1.0f);
        SequentialAnimator animator = new Wait(300).followedBy(post).followedBy(the).followedBy(extraordinary).followedBy(log).followedBy(logGrow);
        animator.animate();
        Random rnd = new Random();
        return (ModularPanel)((ModularPanel)new ModularPanel("main").coverChildren()).child((IWidget)((Flow)((Flow)((Flow)new Column().margin(12)).coverChildren()).child((IWidget)((Flow)((Flow)((Flow)new Row().coverChildren()).child(IKey.str("Post ").asWidget().transform((widget, stack) -> stack.translate(post.getValue(), 0.0f)))).child(IKey.str("the ").asWidget().transform((widget, stack) -> stack.translate(0.0f, the.getValue())))).child(IKey.str("fucking ").style(IKey.OBFUSCATED).asWidget().transform((widget, stack) -> stack.translate(extraordinary.getValue(), 0.0f))))).child(((TextWidget)IKey.str("LOOOOGG!!!!").asWidget().paddingTop(4)).transform((widget, stack) -> {
            float logVal = log.getValue();
            float logGrowVal = logGrow.getValue();
            stack.translate((float)rnd.nextInt(5) * logGrowVal, logVal + (float)rnd.nextInt(5) * logGrowVal);
            int x0 = widget.getArea().width / 2;
            int y0 = widget.getArea().height;
            float scale = Interpolations.lerp(1.0f, 3.0f, logGrowVal);
            stack.translate(x0, y0);
            stack.scale(scale, scale);
            stack.translate(-x0, -y0);
            widget.color(Color.lerp(-16514044, Color.RED.main, Math.min(1.0f, 1.2f * logGrowVal)));
        })));
    }

    @NotNull
    public static ModularPanel buildRichTextUI() {
        IntValue integer = new IntValue(0);
        return (ModularPanel)((ModularPanel)new ModularPanel("main").size(176, 166)).child(((RichTextWidget)((RichTextWidget)new RichTextWidget().sizeRel(1.0f)).margin(7)).autoUpdate(true).textBuilder(text -> ((RichText)((RichText)((RichText)((RichText)((RichText)((RichText)((RichText)text.add("Hello ").add((IDrawable)new ItemDrawable(new ItemStack((ItemLike)Blocks.f_50034_)).asIcon().asHoverable().tooltip(richTooltip -> richTooltip.addFromItem(new ItemStack((ItemLike)Blocks.f_50034_)).add(String.valueOf(IKey.GRAY) + "Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua."))).add(", nice to ").add(new ItemDrawable(new ItemStack((ItemLike)Items.f_42485_)).asIcon().asInteractable().onMousePressed((x, y, button) -> {
            ModularUI.LOGGER.info("Pressed Pork");
            return true;
        })).add(" you. ").add(String.valueOf(IKey.GREEN) + "This is a long ").add((IDrawable)IKey.str("string").style(IKey.DARK_PURPLE).asTextIcon().asHoverable().addTooltipLine("Text Tooltip")).add(" of characters" + String.valueOf(IKey.RESET)).add(" and not numbers as some might think...").newLine()).newLine()).add(IKey.comp(IKey.comp(IKey.str("Underline all: "), IKey.comp(IKey.str("Green Text, "), IKey.str("this is red").style(IKey.RED), IKey.str(" and this should be green again")).style(IKey.GREEN), IKey.str(". Still underlined, ")).style(IKey.UNDERLINE), IKey.str("but not anymore."))).newLine()).add(IKey.str("Green, %s, %s and green again", IKey.str("red").style(IKey.RED), IKey.str("underline").style(null, IKey.UNDERLINE)).style(IKey.GREEN)).newLine()).add(String.valueOf(IKey.RESET) + String.valueOf(IKey.UNDERLINE) + "Underlined" + String.valueOf(IKey.RESET)).newLine()).add("A long line which should wrap around").newLine()).addLine(IKey.comp(IKey.str("Dynamic ").style(IKey.GOLD), IKey.dynamicKey(() -> {
            int i = integer.getIntValue() + 1;
            integer.setIntValue(i);
            return IKey.str("key [%s]", IKey.str("arg").style(IKey.UNDERLINE, IKey.BLACK)).style(i % 30 > 5 ? IKey.RED : IKey.DARK_BLUE);
        }).style(IKey.BOLD), IKey.str(" Test")))).textShadow(false)));
    }

    @NotNull
    public static ModularPanel buildWorldSchemaUI() {
        ArraySchema schema = ArraySchema.builder().layer("D   D", "     ", "     ", "     ").layer(" DDD ", " E E ", "     ", "     ").layer(" DDD ", "  E  ", "  G  ", "  B  ").layer(" DDD ", " E E ", "     ", "     ").layer("D   D", "     ", "     ", "     ").where('D', "minecraft:gold_block").where('E', "minecraft:emerald_block").where('G', "minecraft:diamond_block").where('B', "minecraft:beacon").build();
        ModularPanel panel = (ModularPanel)ModularPanel.defaultPanel("main").size(170);
        ((ModularPanel)panel.child((IWidget)new SchemaWidget(schema).full())).child((IWidget)((SchemaWidget.LayerButton)((SchemaWidget.LayerButton)new SchemaWidget.LayerButton(schema, 0, 3).bottom(1)).left(1)).size(16));
        return panel;
    }

    public static ModularPanel buildCollapseDisabledChildrenUI() {
        Random rnd = new Random();
        return (ModularPanel)((ModularPanel)ModularPanel.defaultPanel("list", 100, 150).padding(7)).child(((ListWidget)((ListWidget)new ListWidget().sizeRel(1.0f)).collapseDisabledChild()).children(12, i -> ((Widget)((Widget)((Widget)new Widget().widthRel(1.0f)).height(16)).widgetTheme(IThemeApi.BUTTON)).overlay(IKey.str(String.valueOf(i + 1))).onUpdateListener(w -> {
            if (rnd.nextDouble() < 0.05) {
                w.setEnabled(!w.isEnabled());
            }
        })));
    }

    @NotNull
    public static ModularPanel buildSearchTest() {
        List<String> items = Arrays.asList("Chicken", "Jockey", "Flint", "Steel", "Steve", "Diamond", "Ingot", "Iron", "Armor", "Greg");
        StringValue searchValue = new StringValue("");
        return (ModularPanel)ModularPanel.defaultPanel("search", 100, 150).child((IWidget)((Flow)((Flow)Flow.column().padding(5)).child((IWidget)((TextFieldWidget)new TextFieldWidget().value(searchValue).height(16)).widthRel(1.0f))).child(((ListWidget)((ListWidget)new ListWidget().collapseDisabledChild().expanded()).widthRel(1.0f)).children(items.size(), i -> ((TextWidget)((TextWidget)((TextWidget)((TextWidget)new TextWidget(IKey.str((String)items.get(i))).alignment(Alignment.Center)).color(Color.WHITE.main).widthRel(1.0f)).height(16)).background(GuiTextures.MC_BUTTON)).setEnabledIf(w -> ((String)items.get(i)).toLowerCase().contains(searchValue.getStringValue())))));
    }

    @NotNull
    public static ModularPanel buildColorTheoryUI() {
        ArrayList<Pair> colors = new ArrayList<Pair>();
        for (ColorShade shade : ColorShade.getAll()) {
            IntIterator intIterator = shade.iterator();
            while (intIterator.hasNext()) {
                int c = (Integer)intIterator.next();
                colors.add(Pair.of((Object)c, (Object)Float.valueOf(Color.getLuminance(c))));
            }
        }
        colors.sort((a, b) -> Float.compare(((Float)a.getRight()).floatValue(), ((Float)b.getRight()).floatValue()));
        IDrawable luminanceSortedColors = (context1, x, y, width, height, widgetTheme) -> {
            float w = (float)width / (float)colors.size();
            float x0 = x;
            for (Pair c : colors) {
                GuiDraw.drawRect(context1.getGraphics(), x0, y, w, height, (Integer)c.getLeft());
                x0 += w;
            }
        };
        Rectangle color1 = new Rectangle().color(Color.BLACK.main);
        Rectangle color2 = new Rectangle().color(Color.WHITE.main);
        IDrawable gradient = (context1, x, y, width, height, widgetTheme) -> GuiDraw.drawHorizontalGradientRect(context1.getGraphics(), x, y, width, height, color1.getColor(), color2.getColor());
        IDrawable correctedGradient = (context1, x, y, width, height, widgetTheme) -> {
            int points = 500;
            Matrix4f pose = context1.graphicsPose().m_85850_().m_252922_();
            VertexConsumer buffer = context1.getGraphics().m_280091_().m_6299_(GTRenderTypes.guiTriangleStrip());
            float x0 = x;
            float w = (float)width / (float)points;
            for (int i = 0; i < points; ++i) {
                int color = Color.lerp(color1.getColor(), color2.getColor(), (float)i / (float)points);
                int r = Color.getRed(color);
                int g = Color.getGreen(color);
                int b = Color.getBlue(color);
                int a = 255;
                buffer.m_252986_(pose, x0, (float)y, 0.0f).m_6122_(r, g, b, a).m_5752_();
                buffer.m_252986_(pose, x0, (float)(y + height), 0.0f).m_6122_(r, g, b, a).m_5752_();
                x0 += w;
            }
        };
        ModularPanel panel = (ModularPanel)((ModularPanel)((ModularPanel)new ModularPanel("colors").width(300)).coverChildrenHeight()).padding(7);
        IPanelHandler colorPicker1 = IPanelHandler.simple(panel, (mainPanel, player) -> (ModularPanel)((ModularPanel)((ModularPanel)new ColorPickerDialog("color_picker1", color1::color, color1.getColor(), true).setDraggable(true).relative(panel)).top(0)).rightRel(1.0f), true);
        IPanelHandler colorPicker2 = IPanelHandler.simple(panel, (mainPanel, player) -> (ModularPanel)((ModularPanel)((ModularPanel)new ColorPickerDialog("color_picker2", color2::color, color2.getColor(), true).setDraggable(true).relative(panel)).top(0)).leftRel(1.0f), true);
        return (ModularPanel)panel.child((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)Flow.column().coverChildrenHeight()).child((IWidget)IKey.str("Colors sorted by luminance").asWidget().margin(1))).child((IWidget)((Widget)luminanceSortedColors.asWidget().widthRel(1.0f)).height(10))).child((IWidget)((TextWidget)IKey.str("Blending color").asWidget().margin(1)).marginTop(2))).child((IWidget)((Flow)((Flow)((Flow)Flow.row().coverChildrenHeight()).mainAxisAlignment(Alignment.MainAxis.SPACE_BETWEEN).child(((ButtonWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().name("color picker button 1")).background(color1)).disableHoverBackground()).onMousePressed((x, y, mouseButton) -> {
            colorPicker1.openPanel();
            return true;
        }))).child(IKey.str("<--  Select colors  -->").asWidget())).child(((ButtonWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().name("color picker button 2")).background(color2)).disableHoverBackground()).onMousePressed((x, y, mouseButton) -> {
            colorPicker2.openPanel();
            return true;
        })))).child((IWidget)IKey.str("OpenGL color gradient").asWidget().margin(1))).child((IWidget)((Widget)gradient.asWidget().widthRel(1.0f)).height(10))).child((IWidget)IKey.str("Gamma corrected gradient").asWidget().margin(1))).child((IWidget)((Widget)correctedGradient.asWidget().widthRel(1.0f)).height(10)));
    }

    @NotNull
    public static ModularPanel buildViewportTransformUI() {
        return (ModularPanel)new TestPanel("viewport_transform").child(((Widget)((Widget)((Widget)new Widget().align(Alignment.Center)).size(50, 50)).background(GuiTextures.MC_BUTTON)).hoverBackground(GuiTextures.MC_BUTTON_HOVERED));
    }

    public static ModularPanel buildContextMenu() {
        List options1 = IntStream.range(0, 5).mapToObj(i -> "Option " + (i + 1)).collect(Collectors.toList());
        List options2 = IntStream.range(0, 5).mapToObj(i -> "Sub Option " + (i + 1)).collect(Collectors.toList());
        ObjectValue<ItemStack> itemValue = new ObjectValue<ItemStack>(ItemStack.class, new ItemStack((ItemLike)Items.f_42346_));
        return (ModularPanel)((ModularPanel)((ModularPanel)new ModularPanel("context_menu_test").size(150)).child(((ContextMenuButton)((ContextMenuButton)((ContextMenuButton)((ContextMenuButton)((ContextMenuButton)new ContextMenuButton("menu").top(7)).width(100)).horizontalCenter()).height(16)).overlay(IKey.str("Menu"))).menuList(l -> ((ListWidget)l.maxSize(80)).children(options1, s -> IKey.str(s).asWidget()).child(((ContextMenuButton)((ContextMenuButton)((ContextMenuButton)((ContextMenuButton)new ContextMenuButton("sub_menu").widthRel(1.0f)).height(12)).overlay(IKey.str("Sub Menu"))).openRightDown()).menuList(l1 -> ((ListWidget)l1.maxSize(80)).children(options2, s -> IKey.str(s).asWidget())))))).child(((DropdownWidget)((DropdownWidget)((DropdownWidget)((DropdownWidget)((DropdownWidget)((DropdownWidget)((DropdownWidget)((DropdownWidget)((DropdownWidget)((DropdownWidget)((DropdownWidget)new DropdownWidget("test_dropdown", ItemStack.class).top(45)).width(100)).horizontalCenter()).value(itemValue)).option((ItemStack)new ItemStack((ItemLike)Items.f_42346_))).option((ItemStack)new ItemStack((ItemLike)Items.f_42417_))).option((ItemStack)new ItemStack((ItemLike)Items.f_42410_))).option((ItemStack)new ItemStack((ItemLike)Items.f_42520_))).option((ItemStack)new ItemStack((ItemLike)Items.f_42384_))).option((ItemStack)new ItemStack((ItemLike)Items.f_42398_))).option((ItemStack)new ItemStack((ItemLike)Items.f_42686_))).optionToWidget((item, forSelected) -> (IWidget)((Flow)((Flow)((Flow)Flow.row().coverChildrenHeight()).padding(4, 1)).mainAxisAlignment(Alignment.MainAxis.SPACE_BETWEEN).child(new ItemDrawable((ItemStack)item).asWidget())).child(((TextWidget)IKey.str(item.m_41611_().getString()).asWidget().widgetTheme(IThemeApi.BUTTON)).invisible())));
    }

    @NotNull
    public static ModularPanel buildGraphUI() {
        double[] x = DAM.linspace(-25.0, 25.0, 200);
        double[] y1 = DAM.div(DAM.sin(x, null), x, null);
        return (ModularPanel)((ModularPanel)((ModularPanel)new ModularPanel("graph").size(200, 160)).padding(5)).overlay(new GraphDrawable().graphAspectRatio(1.7777778f).plot(x, y1));
    }

    @NotNull
    public static ModularPanel buildAspectRatioUI() {
        return (ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)new ModularPanel("aspect_ratio").coverChildren()).padding(10)).child((IWidget)((Flow)((Flow)((Flow)new Row().childPadding(10).coverChildren()).child(((Widget)new Rectangle().color(Color.BLUE_ACCENT.main).asIcon().aspectRatio(1.3333334f).asWidget().size(80)).overlay(IKey.str("4:3 Free")))).child(((Widget)new Rectangle().color(Color.RED_ACCENT.main).asIcon().aspectRatio(1.3333334f).width(70).asWidget().size(80)).overlay(IKey.str("4:3 | width = 70")))).child(((Widget)new Rectangle().color(Color.LIGHT_GREEN.main).asIcon().aspectRatio(1.3333334f).height(45).alignment(Alignment.BottomRight).asWidget().size(80)).overlay(IKey.str("4:3 | height = 45\nBottom Right"))))).overlay(new IDrawable[0]);
    }

    @NotNull
    public static ModularPanel buildWrappedFlowUI() {
        IntArrayList colors = new IntArrayList(LIGHT_COLORS);
        Random rnd = new Random();
        int minRectSize = 10;
        int maxRectSize = 40;
        return (ModularPanel)((ModularPanel)((ModularPanel)new ModularPanel("wrapped_flow").size(150)).padding(4)).child(((Flow)((Flow)((Flow)((Flow)((Flow)Flow.row().name("wrap")).wrap().widthRel(1.0f)).coverChildrenHeight()).padding(2)).crossAxisAlignment(Alignment.CrossAxis.START).mainAxisAlignment(Alignment.MainAxis.CENTER).childPadding(2).crossAxisChildPadding(2).background(TestGuis.rndRect((IntList)colors, rnd))).children(5, arg_0 -> TestGuis.lambda$buildWrappedFlowUI$39((IntList)colors, rnd, maxRectSize, minRectSize, arg_0)));
    }

    private static Rectangle rndRect(IntList colors, Random random) {
        int i = random.nextInt(colors.size());
        int c = colors.removeInt(i);
        if (colors.isEmpty()) {
            colors.addAll(LIGHT_COLORS);
        }
        return new Rectangle().color(c);
    }

    private static /* synthetic */ IWidget lambda$buildWrappedFlowUI$39(IntList colors, Random rnd, int maxRectSize, int minRectSize, int i) {
        Object widget = ((Widget)((Widget)TestGuis.rndRect(colors, rnd).asWidget().width(rnd.nextInt(maxRectSize - minRectSize) + minRectSize)).height(rnd.nextInt(maxRectSize - minRectSize) + minRectSize)).name("rect_" + (i + 1));
        if (i % 2 == 1) {
            widget.resizer().expanded();
        }
        return widget;
    }

    private static class TestPanel
    extends ModularPanel {
        public TestPanel(String name) {
            super(name);
            ((ModularPanel)this.align(Alignment.Center)).size(100, 100);
        }

        @Override
        public void transform(IViewportStack stack) {
            super.transform(stack);
            stack.translate(50.0f, 50.0f);
            float angle = (float)((double)((float)(Util.m_137550_() % 4000L) / 4000.0f * 2.0f) * Math.PI);
            stack.rotateZ(angle);
            long t = Util.m_137550_() % 4000L;
            float scale = t <= 2000L ? Interpolation.BACK_INOUT.interpolate(0.5f, 1.0f, (float)t / 2000.0f) : Interpolation.BACK_INOUT.interpolate(0.5f, 1.0f, (float)(2000L - t + 2000L) / 2000.0f);
            stack.scale(scale, scale);
            stack.translate(-50.0f, -50.0f);
        }
    }
}

