/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.screen.viewport;

import brachy.modularui.api.GuiAxis;
import brachy.modularui.api.MCHelper;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.screen.ClientScreenHandler;
import brachy.modularui.screen.viewport.GuiViewportStack;
import brachy.modularui.screen.viewport.ModularGuiContext;
import brachy.modularui.utils.Stencil;
import brachy.modularui.widget.sizer.Area;
import com.mojang.blaze3d.vertex.PoseStack;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class GuiContext
extends GuiViewportStack {
    private final Area screenArea = new Area();
    private GuiGraphics graphics = null;
    @Nullable
    private Font overrideFont = null;
    private final Stencil stencil = new Stencil(this);
    private int mouseX;
    private int mouseY;
    private int mouseButton;
    private double mouseScrollDelta;
    private int keyCode;
    private int scanCode;
    private int modifiers;
    private int codePoint;
    private float partialTicks;
    private long tick = 0L;
    private int currentDrawingZ = 0;

    public static GuiContext getDefault() {
        return ClientScreenHandler.getBestContext();
    }

    public boolean isAbove(IWidget widget) {
        return this.isMouseAbove(widget.getArea());
    }

    public boolean isMouseAbove(IWidget widget) {
        return this.isMouseAbove(widget.getArea());
    }

    public boolean isMouseAbove(Area area) {
        return area.isInside(this.mouseX, this.mouseY);
    }

    @ApiStatus.Internal
    public void updateState(int mouseX, int mouseY, float partialTicks) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.partialTicks = partialTicks;
    }

    @ApiStatus.Internal
    public void updateMouseButton(int button) {
        this.mouseButton = button;
    }

    @ApiStatus.Internal
    public void updateMouseWheel(double scrollDelta) {
        this.mouseScrollDelta = scrollDelta;
    }

    @ApiStatus.Internal
    public void updateLatestKey(int keyCode, int scanCode, int modifiers) {
        this.keyCode = keyCode;
        this.scanCode = scanCode;
        this.modifiers = modifiers;
    }

    @ApiStatus.Internal
    public void updateLatestTypedChar(int codePoint, int modifiers) {
        this.codePoint = codePoint;
        this.modifiers = modifiers;
    }

    @ApiStatus.Internal
    public void updateScreenArea(int w, int h) {
        this.screenArea.set(0, 0, w, h);
        this.screenArea.rx = 0;
        this.screenArea.ry = 0;
    }

    public void updateZ(int z) {
        this.currentDrawingZ = z;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Minecraft getMC() {
        return Minecraft.m_91087_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Font getFont() {
        if (this.overrideFont != null) {
            return this.overrideFont;
        }
        return MCHelper.getFont();
    }

    @OnlyIn(value=Dist.CLIENT)
    @ApiStatus.Internal
    public void setOverrideFont(@Nullable Font overrideFont) {
        this.overrideFont = overrideFont;
    }

    public void tick() {
        ++this.tick;
    }

    public Matrix4f getLastGraphicsPose() {
        if (this.graphics == null) {
            return new Matrix4f();
        }
        return this.graphics.m_280168_().m_85850_().m_252922_();
    }

    public PoseStack graphicsPose() {
        if (this.graphics == null) {
            return new PoseStack();
        }
        return this.graphics.m_280168_();
    }

    public int getMouseX() {
        return this.unTransformX(this.mouseX, this.mouseY);
    }

    public int getMouseY() {
        return this.unTransformY(this.mouseX, this.mouseY);
    }

    public int getAbsMouseX() {
        return this.mouseX;
    }

    public int getAbsMouseY() {
        return this.mouseY;
    }

    public int getMouse(GuiAxis axis) {
        return axis.isHorizontal() ? this.getMouseX() : this.getMouseY();
    }

    public int getAbsMouse(GuiAxis axis) {
        return axis.isHorizontal() ? this.getAbsMouseX() : this.getAbsMouseY();
    }

    public boolean isMuiContext() {
        return false;
    }

    public ModularGuiContext getMuiContext() {
        throw new UnsupportedOperationException("This is not a MuiContext");
    }

    @Generated
    public Area getScreenArea() {
        return this.screenArea;
    }

    @Generated
    public GuiGraphics getGraphics() {
        return this.graphics;
    }

    @ApiStatus.Internal
    @Generated
    public void setGraphics(GuiGraphics graphics) {
        this.graphics = graphics;
    }

    @Generated
    public Stencil getStencil() {
        return this.stencil;
    }

    @Generated
    public int getMouseButton() {
        return this.mouseButton;
    }

    @Generated
    public double getMouseScrollDelta() {
        return this.mouseScrollDelta;
    }

    @Generated
    public int getKeyCode() {
        return this.keyCode;
    }

    @Generated
    public int getScanCode() {
        return this.scanCode;
    }

    @Generated
    public int getModifiers() {
        return this.modifiers;
    }

    @Generated
    public int getCodePoint() {
        return this.codePoint;
    }

    @Generated
    public float getPartialTicks() {
        return this.partialTicks;
    }

    @Generated
    public long getTick() {
        return this.tick;
    }

    @Generated
    public int getCurrentDrawingZ() {
        return this.currentDrawingZ;
    }
}

