/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.screen;

import brachy.modularui.ModularUI;
import brachy.modularui.api.IMuiScreen;
import brachy.modularui.api.RecipeViewerSettings;
import brachy.modularui.api.UIFactory;
import brachy.modularui.factory.GuiData;
import brachy.modularui.factory.PosGuiData;
import brachy.modularui.screen.ModularContainerMenu;
import brachy.modularui.screen.ModularScreen;
import brachy.modularui.screen.RecipeViewerSettingsImpl;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.ApiStatus;

public class UISettings {
    public static final double DEFAULT_INTERACT_RANGE = 8.0;
    private IntFunction<ModularContainerMenu> containerCreator;
    @OnlyIn(value=Dist.CLIENT)
    private GuiCreator guiSupplier;
    private Predicate<Player> canInteractWith;
    private String theme;
    private final RecipeViewerSettings recipeViewerSettings;

    public UISettings() {
        this(new RecipeViewerSettingsImpl());
    }

    public UISettings(RecipeViewerSettings recipeViewerSettings) {
        this.recipeViewerSettings = recipeViewerSettings;
    }

    public void customContainer(IntFunction<ModularContainerMenu> containerCreator) {
        this.containerCreator = containerCreator;
    }

    public void customGui(Supplier<GuiCreator> guiSupplier) {
        if (ModularUI.isClientThread()) {
            this.guiSupplier = guiSupplier.get();
        }
    }

    public void canInteractWith(Predicate<Player> canInteractWith) {
        this.canInteractWith = canInteractWith;
    }

    @ApiStatus.Internal
    public <D extends GuiData> void defaultCanInteractWith(UIFactory<D> factory, D guiData) {
        this.canInteractWith(player -> factory.canInteractWith((Player)player, guiData));
    }

    public void canInteractWithinRange(Vec3 pos, double range) {
        this.canInteractWith(player -> player.m_20238_(pos) <= range * range);
    }

    public void canInteractWithinRange(BlockPos pos, double range) {
        this.canInteractWithinRange(pos.m_252807_(), range);
    }

    public void canInteractWithinRange(PosGuiData guiData, double range) {
        this.canInteractWithinRange(guiData.getBlockPos(), range);
    }

    public void canInteractWithinDefaultRange(Vec3 pos) {
        this.canInteractWithinRange(pos, 8.0);
    }

    public void canInteractWithinDefaultRange(BlockPos pos) {
        this.canInteractWithinRange(pos, 8.0);
    }

    public void canInteractWithinDefaultRange(PosGuiData guiData) {
        this.canInteractWithinRange(guiData, 8.0);
    }

    public void useTheme(String theme) {
        this.theme = theme;
    }

    @ApiStatus.Internal
    public ModularContainerMenu createContainer(int containerId) {
        return this.containerCreator.apply(containerId);
    }

    @SideOnly(value=Side.CLIENT)
    @ApiStatus.Internal
    public IMuiScreen createGui(ModularContainerMenu container, ModularScreen screen) {
        return this.guiSupplier.create(container, screen);
    }

    public boolean hasCustomContainer() {
        return this.containerCreator != null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasCustomGui() {
        return this.guiSupplier != null;
    }

    public boolean canPlayerInteractWithUI(Player player) {
        return this.canInteractWith == null || this.canInteractWith.test(player);
    }

    @Generated
    public String getTheme() {
        return this.theme;
    }

    @Generated
    public RecipeViewerSettings getRecipeViewerSettings() {
        return this.recipeViewerSettings;
    }

    public static interface GuiCreator {
        public IMuiScreen create(ModularContainerMenu var1, ModularScreen var2);
    }
}

