/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.screen;

import brachy.modularui.ModularUIConfig;
import brachy.modularui.api.GuiAxis;
import brachy.modularui.api.MCHelper;
import brachy.modularui.api.drawable.IRichTextBuilder;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.drawable.GuiDraw;
import brachy.modularui.drawable.text.RichText;
import brachy.modularui.drawable.text.TextRenderer;
import brachy.modularui.screen.event.RichTooltipEvent;
import brachy.modularui.screen.viewport.GuiContext;
import brachy.modularui.utils.Color;
import brachy.modularui.utils.Rectangle;
import brachy.modularui.widget.sizer.Area;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RichTooltip
implements IRichTextBuilder<RichTooltip> {
    private static final Area HOLDER = new Area();
    private final RichText text = new RichText();
    private Consumer<Area> parent;
    private Pos pos = null;
    private Consumer<RichTooltip> tooltipBuilder;
    private int showUpTimer = 0;
    private boolean autoUpdate = false;
    private int titleMargin = 0;
    private boolean appliedMargin = true;
    private int x = 0;
    private int y = 0;
    private int maxWidth = Integer.MAX_VALUE;
    private boolean dirty;

    public RichTooltip() {
        this.parent(Area.ZERO);
    }

    @Override
    public RichTooltip reset() {
        this.clearText();
        this.pos = null;
        this.tooltipBuilder = null;
        this.showUpTimer = 0;
        this.autoUpdate = false;
        this.titleMargin = 0;
        this.appliedMargin = true;
        this.x = 0;
        this.y = 0;
        this.maxWidth = Integer.MAX_VALUE;
        return this;
    }

    public RichTooltip parent(Area parent) {
        return this.parent((Area area) -> area.set(parent));
    }

    public RichTooltip parent(Supplier<Area> parent) {
        return this.parent((Area area) -> area.set((Rectangle)parent.get()));
    }

    public RichTooltip parent(IWidget parent) {
        return this.parent((Area area) -> {
            area.setPos(0, 0);
            area.setSize(parent.getArea());
        });
    }

    public void buildTooltip() {
        this.dirty = false;
        if (this.tooltipBuilder != null) {
            this.text.clearText();
            this.tooltipBuilder.accept(this);
            this.appliedMargin = false;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(GuiContext context) {
        this.draw(context, ItemStack.f_41583_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(GuiContext context, @Nullable ItemStack stack) {
        if (this.autoUpdate) {
            this.markDirty();
        }
        if (this.isEmpty()) {
            return;
        }
        if (this.maxWidth <= 0) {
            this.maxWidth = Integer.MAX_VALUE;
        }
        if (stack == null) {
            stack = ItemStack.f_41583_;
        }
        if (!this.appliedMargin) {
            if (this.titleMargin > 0) {
                this.text.insertTitleMargin(this.titleMargin);
            }
            this.appliedMargin = true;
        }
        Area screen = context.getScreenArea();
        this.maxWidth = Math.min(this.maxWidth, screen.width);
        int mouseX = context.getAbsMouseX();
        int mouseY = context.getAbsMouseY();
        TextRenderer renderer = TextRenderer.SHARED;
        List textLines = this.text.getAsText().stream().map(Either::left).collect(Collectors.toList());
        RenderTooltipEvent.GatherComponents gatherEvent = new RenderTooltipEvent.GatherComponents(stack, screen.width, screen.height, textLines, this.maxWidth);
        if (MinecraftForge.EVENT_BUS.post((Event)gatherEvent)) {
            return;
        }
        this.maxWidth = gatherEvent.getMaxWidth();
        textLines = gatherEvent.getTooltipElements();
        List<ClientTooltipComponent> components = textLines.stream().map(either -> (ClientTooltipComponent)either.map(text -> {
            FormattedCharSequence formattedCharSequence;
            if (text instanceof Component) {
                Component component = (Component)text;
                formattedCharSequence = component.m_7532_();
            } else {
                formattedCharSequence = Language.m_128107_().m_5536_(text);
            }
            return ClientTooltipComponent.m_169948_((FormattedCharSequence)formattedCharSequence);
        }, ClientTooltipComponent::m_169950_)).toList();
        RichText copy = this.text.copy();
        RichTooltipEvent.Pre event = new RichTooltipEvent.Pre(stack, context.getGraphics(), mouseX, mouseY, screen.width, screen.height, context.getFont(), components, DefaultTooltipPositioner.f_262752_, copy);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        mouseX = event.getX();
        mouseY = event.getY();
        int screenWidth = event.getScreenWidth();
        int screenHeight = event.getScreenHeight();
        context.setOverrideFont(event.getFont());
        copy.setupRenderer(renderer, 0, 0, this.maxWidth, -1.0f, Color.WHITE.main, false);
        copy.compileAndDraw(renderer, context, true);
        Rectangle area = this.determineTooltipArea(copy, context, renderer, screenWidth, screenHeight, mouseX, mouseY);
        Lighting.m_84930_();
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
        context.getGraphics().m_280168_().m_85836_();
        context.getGraphics().m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
        GuiDraw.drawTooltipBackground(context, stack, components, area.x, area.y, area.width, area.height, this);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        renderer.setPos(area.x, area.y);
        this.text.compileAndDraw(renderer, context, false);
        context.getGraphics().m_280168_().m_85849_();
        context.setOverrideFont(null);
    }

    public Rectangle determineTooltipArea(RichText text, GuiContext context, TextRenderer renderer, int screenWidth, int screenHeight, int mouseX, int mouseY) {
        Pos pos;
        int width = (int)renderer.getLastWidth();
        int height = (int)renderer.getLastHeight();
        if (width > screenWidth - 14) {
            width = screenWidth - 14;
        }
        if ((pos = this.pos) == null) {
            pos = ModularUIConfig.tooltipPos();
        }
        if (pos == Pos.FIXED) {
            return new Rectangle(this.x, this.y, width, height);
        }
        Area area = HOLDER;
        this.parent.accept(area);
        if (area.x == 0 && area.y == 0 && area.width == 0 && area.height == 0) {
            pos = Pos.NEXT_TO_MOUSE;
        }
        if (pos == Pos.NEXT_TO_MOUSE) {
            int padding = 8;
            int mouseOffset = 12;
            int x = mouseX + 12;
            int y = mouseY - 12;
            if (x < 8) {
                x = 8;
            } else if (x + width + 8 > screenWidth) {
                if (screenWidth - mouseX < mouseX) {
                    if ((x -= 24 + width) < 8) {
                        x = 8;
                    }
                    width = mouseX - 12 - 8;
                } else {
                    width = screenWidth - 8 - x;
                }
                renderer.setPos(x, y);
                renderer.setAlignment(text.getAlignment(), width, -1.0f);
                text.compileAndDraw(renderer, context, true);
                width = (int)renderer.getLastWidth();
                height = (int)renderer.getLastHeight();
            }
            y = Mth.m_14045_((int)y, (int)8, (int)(screenHeight - 8 - height));
            return new Rectangle(x, y, width, height);
        }
        if (this.parent == null) {
            throw new IllegalStateException("Tooltip pos is " + pos.name() + ", but no widget parent is set!");
        }
        int minWidth = text.getMinWidth();
        int shiftAmount = 10;
        int padding = 7;
        area.transformAndRectanglerize(context);
        int x = 0;
        int y = 0;
        if (pos.axis.isVertical()) {
            x = area.x + (width < area.width ? shiftAmount : -shiftAmount);
            x = Mth.m_14045_((int)x, (int)padding, (int)(screenWidth - padding - width));
            if (pos == Pos.VERTICAL) {
                int bottomSpace = screenHeight - area.ey();
                Pos pos2 = pos = bottomSpace < height + padding && bottomSpace < area.y ? Pos.ABOVE : Pos.BELOW;
            }
            if (pos == Pos.BELOW) {
                y = area.ey() + padding;
            } else if (pos == Pos.ABOVE) {
                y = area.y - height - padding;
            }
        } else if (pos.axis.isHorizontal()) {
            boolean usedMoreSpaceSide = false;
            Pos oPos = pos;
            if (oPos == Pos.HORIZONTAL) {
                if (area.x > screenWidth - area.ex()) {
                    pos = Pos.LEFT;
                } else {
                    pos = Pos.RIGHT;
                    x = screenWidth - area.ex() + padding;
                }
            }
            if (height < area.height) {
                y = area.y + shiftAmount;
            } else {
                y = area.y - shiftAmount;
                if (y < padding) {
                    y = padding;
                }
            }
            if (x + width > screenWidth - padding) {
                int maxWidth = pos == Pos.LEFT ? Math.max(minWidth, area.x - padding * 2) : Math.max(minWidth, screenWidth - area.ex() - padding * 2);
                usedMoreSpaceSide = true;
                renderer.setAlignment(this.text.getAlignment(), maxWidth);
                this.text.compileAndDraw(renderer, context, true);
                width = (int)renderer.getLastWidth();
                height = (int)renderer.getLastHeight();
            }
            if (oPos == Pos.HORIZONTAL && !usedMoreSpaceSide) {
                int rightSpace = screenWidth - area.ex();
                Pos pos3 = pos = rightSpace < width + padding && rightSpace < area.x ? Pos.LEFT : Pos.RIGHT;
            }
            if (pos == Pos.RIGHT) {
                x = area.ex() + padding;
            } else if (pos == Pos.LEFT && (x = area.x - width - padding) < padding) {
                x = padding;
                width = area.x - x - padding;
            }
        }
        return new Rectangle(x, y, width, height);
    }

    public boolean isEmpty() {
        if (this.dirty) {
            this.buildTooltip();
        }
        return this.text.isEmpty();
    }

    public void markDirty() {
        this.dirty = true;
    }

    public RichTooltip pos(int x, int y) {
        this.pos = Pos.FIXED;
        this.x = x;
        this.y = y;
        return this;
    }

    @Override
    public RichTooltip getThis() {
        return this;
    }

    @Override
    public IRichTextBuilder<?> getRichText() {
        return this.text;
    }

    public RichTooltip tooltipBuilder(Consumer<RichTooltip> tooltipBuilder) {
        Consumer<RichTooltip> existingBuilder = this.tooltipBuilder;
        this.tooltipBuilder = existingBuilder != null && tooltipBuilder != null ? tooltip -> {
            existingBuilder.accept(this);
            tooltipBuilder.accept(this);
        } : tooltipBuilder;
        this.markDirty();
        return this;
    }

    public RichTooltip addFromItem(ItemStack item) {
        List<Component> lines = MCHelper.getItemToolTip(item);
        this.add((FormattedText)lines.get(0));
        if (lines.size() > 1) {
            this.spaceLine();
            int n = lines.size();
            for (int i = 1; i < n; ++i) {
                ((RichTooltip)this.add((FormattedText)lines.get(i))).newLine();
            }
        }
        return this;
    }

    public RichTooltip titleMargin() {
        return this.titleMargin(0);
    }

    public RichTooltip titleMargin(int margin) {
        this.titleMargin = margin;
        this.appliedMargin = false;
        return this;
    }

    public static void findIngredientArea(Area area, int x, int y) {
        AbstractContainerScreen containerScreen;
        Slot slot;
        Screen screen = MCHelper.getCurrentScreen();
        if (screen instanceof AbstractContainerScreen && (slot = (containerScreen = (AbstractContainerScreen)screen).getSlotUnderMouse()) != null) {
            int sx = slot.f_40220_ + containerScreen.getGuiLeft();
            int sy = slot.f_40221_ + containerScreen.getGuiTop();
            if (sx >= 0 && sy >= 0) {
                area.set(sx - 1, sy - 1, 18, 18);
                return;
            }
        }
        area.set(Area.ZERO);
    }

    @NotNull
    @Generated
    public RichTooltip parent(Consumer<Area> parent) {
        this.parent = parent;
        return this;
    }

    @NotNull
    @Generated
    public RichTooltip pos(Pos pos) {
        this.pos = pos;
        return this;
    }

    @Generated
    public int showUpTimer() {
        return this.showUpTimer;
    }

    @NotNull
    @Generated
    public RichTooltip showUpTimer(int showUpTimer) {
        this.showUpTimer = showUpTimer;
        return this;
    }

    @Generated
    public boolean autoUpdate() {
        return this.autoUpdate;
    }

    @NotNull
    @Generated
    public RichTooltip autoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
        return this;
    }

    public static enum Pos {
        ABOVE(GuiAxis.Y),
        BELOW(GuiAxis.Y),
        LEFT(GuiAxis.X),
        RIGHT(GuiAxis.X),
        VERTICAL(GuiAxis.Y),
        HORIZONTAL(GuiAxis.X),
        NEXT_TO_MOUSE(null),
        FIXED(null);

        public final GuiAxis axis;

        private Pos(GuiAxis axis) {
            this.axis = axis;
        }
    }
}

