/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.screen;

import brachy.modularui.ModularUI;
import brachy.modularui.api.IMuiScreen;
import brachy.modularui.api.ITheme;
import brachy.modularui.api.IThemeApi;
import brachy.modularui.api.MCHelper;
import brachy.modularui.api.widget.IGuiAction;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.drawable.GuiDraw;
import brachy.modularui.overlay.OverlayScreenWrapper;
import brachy.modularui.screen.ModularContainerMenu;
import brachy.modularui.screen.ModularPanel;
import brachy.modularui.screen.PanelManager;
import brachy.modularui.screen.viewport.ModularGuiContext;
import brachy.modularui.utils.Color;
import brachy.modularui.value.sync.ModularSyncManager;
import brachy.modularui.widget.WidgetTree;
import brachy.modularui.widget.sizer.Area;
import brachy.modularui.widget.sizer.ResizeNode;
import brachy.modularui.widget.sizer.ScreenResizeNode;
import brachy.modularui.widget.wrapper.WidgetWrapper;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ModularScreen
implements GuiEventListener,
Renderable,
LayoutElement,
NarratableEntry {
    private final String owner;
    private final String name;
    private final PanelManager panelManager;
    private final ModularGuiContext context = new ModularGuiContext(this);
    private final Map<Class<?>, List<IGuiAction>> guiActionListeners = new Object2ObjectOpenHashMap();
    private final Object2ObjectArrayMap<IWidget, Runnable> frameUpdates = new Object2ObjectArrayMap();
    private final ScreenResizeNode resizeNode = new ScreenResizeNode(this);
    private boolean pauseScreen = false;
    private boolean openParentOnClose = false;
    @Nullable
    private String themeOverride;
    private ITheme currentTheme;
    private IMuiScreen screenWrapper;
    private boolean overlay = false;
    private static final Component USAGE_NARRATION = Component.m_237115_((String)"narrator.screen.usage");
    private NarratableEntry lastNarratable = null;

    public static boolean isScreen(@Nullable Screen guiScreen, String owner, String name) {
        if (guiScreen instanceof IMuiScreen) {
            IMuiScreen screenWrapper = (IMuiScreen)guiScreen;
            ModularScreen screen = screenWrapper.screen();
            return screen.getOwner().equals(owner) && screen.getName().equals(name);
        }
        return false;
    }

    public static boolean isActive(String owner, String name) {
        return ModularScreen.isScreen(Minecraft.m_91087_().f_91080_, owner, name);
    }

    @Nullable
    public static ModularScreen getCurrent() {
        Screen screen = MCHelper.getCurrentScreen();
        if (screen instanceof IMuiScreen) {
            IMuiScreen screenWrapper = (IMuiScreen)screen;
            return screenWrapper.screen();
        }
        return null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.2.0")
    public ModularScreen(@NotNull ModularPanel mainPanel) {
        this("modularui", mainPanel);
        if (ModularUI.isDev()) {
            ModularUI.LOGGER.warn("The single arg ModularScreen constructor should not be used. Use the any of the other ones and pass in your mod id.");
        }
    }

    public ModularScreen(@NotNull String owner, @NotNull ModularPanel mainPanel) {
        this(owner, (ModularGuiContext context) -> mainPanel);
    }

    public ModularScreen(@NotNull String owner, @NotNull Function<ModularGuiContext, ModularPanel> mainPanelCreator) {
        this(owner, Objects.requireNonNull(mainPanelCreator, "The main panel function must not be null!"), false);
    }

    private ModularScreen(@NotNull String owner, @Nullable Function<ModularGuiContext, ModularPanel> mainPanelCreator, boolean ignored) {
        Objects.requireNonNull(owner, "The owner must not be null!");
        this.owner = owner;
        ModularPanel mainPanel = mainPanelCreator != null ? mainPanelCreator.apply(this.context) : this.buildUI(this.context);
        Objects.requireNonNull(mainPanel, "The main panel must not be null!");
        this.name = mainPanel.getName();
        this.panelManager = new PanelManager(this, mainPanel);
    }

    ModularScreen(@NotNull String owner) {
        this(owner, null, false);
    }

    ModularPanel buildUI(ModularGuiContext context) {
        throw new UnsupportedOperationException();
    }

    @MustBeInvokedByOverriders
    public void construct(IMuiScreen wrapper) {
        ModularContainerMenu modular;
        AbstractContainerScreen containerScreen;
        AbstractContainerMenu abstractContainerMenu;
        if (this.screenWrapper != null) {
            throw new IllegalStateException("ModularScreen is already constructed!");
        }
        if (wrapper == null) {
            throw new NullPointerException("ScreenWrapper must not be null!");
        }
        this.screenWrapper = wrapper;
        Screen screen = this.screenWrapper.wrappedScreen();
        if (screen instanceof AbstractContainerScreen && (abstractContainerMenu = (containerScreen = (AbstractContainerScreen)screen).m_6262_()) instanceof ModularContainerMenu && !(modular = (ModularContainerMenu)abstractContainerMenu).isScreenInitialized()) {
            modular.initializeClient(this);
        }
        this.screenWrapper.updateGuiArea(this.panelManager.getMainPanel().getArea());
        this.overlay = false;
    }

    @ApiStatus.Internal
    @MustBeInvokedByOverriders
    public void constructOverlay(Screen screen) {
        if (this.screenWrapper != null) {
            throw new IllegalStateException("ModularScreen is already constructed!");
        }
        if (screen == null) {
            throw new NullPointerException("ScreenWrapper must not be null!");
        }
        this.screenWrapper = new OverlayScreenWrapper(screen, this);
        this.overlay = true;
    }

    @MustBeInvokedByOverriders
    public void onResize(int width, int height) {
        this.context.updateScreenArea(width, height);
        if (this.panelManager.tryInit()) {
            this.onOpen();
        }
        this.context.pushViewport(null, this.context.getScreenArea());
        WidgetTree.verifyTree(this.resizeNode, (Set<ResizeNode>)new ReferenceOpenHashSet());
        WidgetTree.resizeInternal(this.resizeNode, true);
        this.context.popViewport(null);
        if (!this.isOverlay()) {
            this.screenWrapper.updateGuiArea(this.panelManager.getMainPanel().getArea());
        }
    }

    @ApiStatus.OverrideOnly
    public void onOpen() {
    }

    @ApiStatus.OverrideOnly
    public void onClose() {
    }

    public void close() {
        this.close(false);
    }

    @ApiStatus.Internal
    public void close(boolean force) {
        if (this.m_142518_()) {
            if (force) {
                Minecraft.m_91087_().popGuiLayer();
                return;
            }
            this.getMainPanel().closeIfOpen();
        }
    }

    public boolean isPanelOpen(String name) {
        return this.panelManager.isPanelOpen(name);
    }

    public boolean isPanelOpen(ModularPanel panel) {
        return this.panelManager.hasOpenPanel(panel);
    }

    @MustBeInvokedByOverriders
    public void onUpdate() {
        for (ModularPanel panel : this.panelManager.getOpenPanels()) {
            WidgetTree.onUpdate(panel);
        }
    }

    @MustBeInvokedByOverriders
    public void onFrameUpdate() {
        this.panelManager.checkDirty();
        ObjectIterator iterator = this.frameUpdates.object2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)iterator.next();
            if (!((IWidget)entry.getKey()).isValid()) {
                iterator.remove();
                continue;
            }
            ((Runnable)entry.getValue()).run();
        }
        this.context.onFrameUpdate();
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        Lighting.m_84930_();
        this.context.reset();
        this.context.pushViewport(null, this.context.getScreenArea());
        for (ModularPanel panel : this.panelManager.getReverseOpenPanels()) {
            this.context.updateZ(0);
            if (panel.disablePanelsBelow()) {
                GuiDraw.drawRect(graphics, 0.0f, 0.0f, this.context.getScreenArea().w(), this.context.getScreenArea().h(), Color.argb(16, 16, 16, (int)(125.0f * panel.getAlpha())));
            }
            WidgetTree.drawTree(panel, this.context);
            RenderSystem.clearDepth((double)1.0);
            RenderSystem.clear((int)256, (boolean)Minecraft.f_91002_);
        }
        this.context.updateZ(0);
        this.context.popViewport(null);
        this.context.postRenderCallbacks.forEach(element -> element.accept(this.context));
    }

    public void drawForeground(GuiGraphics guiGraphics, float partialTicks) {
        Lighting.m_84930_();
        RenderSystem.disableDepthTest();
        this.context.reset();
        this.context.pushViewport(null, this.context.getScreenArea());
        for (ModularPanel panel : this.panelManager.getReverseOpenPanels()) {
            this.context.updateZ(100);
            if (!panel.isEnabled()) continue;
            WidgetTree.drawTreeForeground(panel, this.context);
        }
        this.context.drawDraggable(guiGraphics);
        this.context.popViewport(null);
    }

    public boolean handleDraggableInput(double mouseX, double mouseY, int button, boolean pressed) {
        if (this.context.hasDraggable()) {
            if (pressed) {
                this.context.onMousePressed(mouseX, mouseY, button);
            } else {
                this.context.onMouseReleased(mouseX, mouseY, button);
            }
            return true;
        }
        return false;
    }

    public boolean onMousePressed(double mouseX, double mouseY, int button) {
        for (IGuiAction.MousePressed action : this.getGuiActionListeners(IGuiAction.MousePressed.class)) {
            action.press(mouseX, mouseY, button);
        }
        if (this.context.onMousePressed(mouseX, mouseY, button)) {
            return true;
        }
        for (ModularPanel panel : this.panelManager.getOpenPanels()) {
            if (panel.onMousePressed(mouseX, mouseY, button)) {
                return true;
            }
            if (!panel.disablePanelsBelow()) continue;
            break;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        for (IGuiAction.MouseReleased action : this.getGuiActionListeners(IGuiAction.MouseReleased.class)) {
            action.release(mouseX, mouseY, button);
        }
        if (this.context.onMouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        for (ModularPanel panel : this.panelManager.getOpenPanels()) {
            if (panel.onMouseReleased(mouseX, mouseY, button)) {
                return true;
            }
            if (!panel.disablePanelsBelow()) continue;
            break;
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        for (IGuiAction.KeyPressed action : this.getGuiActionListeners(IGuiAction.KeyPressed.class)) {
            action.press(keyCode, scanCode, modifiers);
        }
        for (ModularPanel panel : this.panelManager.getOpenPanels()) {
            if (panel.onKeyPressed(keyCode, scanCode, modifiers)) {
                return true;
            }
            if (!panel.disablePanelsBelow()) continue;
            break;
        }
        return false;
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        for (IGuiAction.KeyReleased action : this.getGuiActionListeners(IGuiAction.KeyReleased.class)) {
            action.release(keyCode, scanCode, modifiers);
        }
        for (ModularPanel panel : this.panelManager.getOpenPanels()) {
            if (panel.onKeyReleased(keyCode, scanCode, modifiers)) {
                return true;
            }
            if (!panel.disablePanelsBelow()) continue;
            break;
        }
        return false;
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        for (IGuiAction.CharTyped action : this.getGuiActionListeners(IGuiAction.CharTyped.class)) {
            action.type(codePoint, modifiers);
        }
        for (ModularPanel panel : this.panelManager.getOpenPanels()) {
            if (panel.onCharTyped(codePoint, modifiers)) {
                return true;
            }
            if (!panel.disablePanelsBelow()) continue;
            break;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        for (IGuiAction.MouseScroll action : this.getGuiActionListeners(IGuiAction.MouseScroll.class)) {
            action.scroll(mouseX, mouseY, delta);
        }
        for (ModularPanel panel : this.panelManager.getOpenPanels()) {
            if (panel.onMouseScrolled(mouseX, mouseY, delta)) {
                return true;
            }
            if (!panel.disablePanelsBelow()) continue;
            break;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        for (IGuiAction.MouseDrag action : this.getGuiActionListeners(IGuiAction.MouseDrag.class)) {
            action.drag(mouseX, mouseY, button, dragX, dragY);
        }
        for (ModularPanel panel : this.panelManager.getOpenPanels()) {
            if (panel.onMouseDrag(mouseX, mouseY, button, dragX, dragY)) {
                return true;
            }
            if (!panel.disablePanelsBelow()) continue;
            break;
        }
        return false;
    }

    @ApiStatus.Internal
    public void m_93692_(boolean focus) {
        this.screenWrapper.wrappedScreen().m_93692_(focus);
    }

    public boolean m_93696_() {
        return this.screenWrapper.wrappedScreen().m_93696_();
    }

    public boolean m_142518_() {
        return ModularScreen.getCurrent() == this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "#" + this.getOwner() + ":" + this.getName();
    }

    public ResourceLocation getResourceLocation() {
        return new ResourceLocation(this.owner, this.name);
    }

    public ModularSyncManager getSyncManager() {
        return this.getContainer().getSyncManager();
    }

    public ModularPanel getMainPanel() {
        return this.panelManager.getMainPanel();
    }

    public Area getScreenArea() {
        return this.context.getScreenArea();
    }

    public boolean isClientOnly() {
        return this.isOverlay() || !this.screenWrapper.isGuiContainer() || this.getContainer().isClientOnly();
    }

    public ModularContainerMenu getContainer() {
        if (this.isOverlay()) {
            throw new IllegalStateException("Can't get ModularContainer for overlay");
        }
        Screen screen = this.screenWrapper.wrappedScreen();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen container = (AbstractContainerScreen)screen;
            return (ModularContainerMenu)container.m_6262_();
        }
        throw new IllegalStateException("Screen does not extend AbstractContainerScreen!");
    }

    private <T extends IGuiAction> List<T> getGuiActionListeners(Class<T> clazz) {
        return this.guiActionListeners.getOrDefault(clazz, Collections.emptyList());
    }

    public void registerGuiActionListener(IGuiAction action) {
        List list = this.guiActionListeners.computeIfAbsent(ModularScreen.getGuiActionClass(action), key -> new ArrayList());
        if (!list.contains(action)) {
            list.add(action);
        }
    }

    public void removeGuiActionListener(IGuiAction action) {
        this.guiActionListeners.getOrDefault(ModularScreen.getGuiActionClass(action), Collections.emptyList()).remove(action);
    }

    public void registerFrameUpdateListener(IWidget widget, Runnable runnable) {
        this.registerFrameUpdateListener(widget, runnable, true);
    }

    public void registerFrameUpdateListener(IWidget widget, Runnable runnable, boolean merge) {
        Objects.requireNonNull(runnable);
        if (merge) {
            this.frameUpdates.merge((Object)widget, (Object)runnable, (old, now) -> () -> {
                old.run();
                now.run();
            });
        } else {
            this.frameUpdates.put((Object)widget, (Object)runnable);
        }
    }

    public void removeFrameUpdateListener(IWidget widget) {
        this.frameUpdates.remove((Object)widget);
    }

    private static Class<?> getGuiActionClass(IGuiAction action) {
        Class<?>[] classes;
        for (Class<?> clazz : classes = action.getClass().getInterfaces()) {
            if (!IGuiAction.class.isAssignableFrom(clazz)) continue;
            return clazz;
        }
        throw new IllegalArgumentException();
    }

    public ITheme getCurrentTheme() {
        if (this.currentTheme == null) {
            this.useTheme(this.themeOverride);
        }
        return this.currentTheme;
    }

    public ModularScreen useTheme(String theme) {
        this.themeOverride = theme;
        this.currentTheme = IThemeApi.get().getThemeForScreen(this, this.themeOverride);
        return this;
    }

    public ModularScreen pausesGame(boolean pausesGame) {
        this.pauseScreen = pausesGame;
        return this;
    }

    public ModularScreen openParentOnClose(boolean openParentOnClose) {
        this.openParentOnClose = openParentOnClose;
        return this;
    }

    public void m_252865_(int x) {
        this.panelManager.getMainPanel().getArea().setX(x);
    }

    public void m_253211_(int y) {
        this.panelManager.getMainPanel().getArea().setY(y);
    }

    public int m_252754_() {
        return this.panelManager.getMainPanel().getArea().getX();
    }

    public int m_252907_() {
        return this.panelManager.getMainPanel().getArea().getY();
    }

    public int m_5711_() {
        return this.panelManager.getMainPanel().getArea().getWidth();
    }

    public int m_93694_() {
        return this.panelManager.getMainPanel().getArea().getHeight();
    }

    @NotNull
    public ScreenRectangle m_264198_() {
        Area area = this.panelManager.getMainPanel().getArea();
        return new ScreenRectangle(area.x(), area.y(), area.w(), area.h());
    }

    public void m_264134_(@NotNull Consumer<AbstractWidget> consumer) {
        for (WidgetWrapper wrapper : this.panelManager.getReverseOpenPanelsWrappers()) {
            consumer.accept(wrapper);
        }
    }

    public void m_142291_(@NotNull NarrationElementOutput output) {
        output.m_169146_(NarratedElementType.USAGE, USAGE_NARRATION);
        Stream<WidgetWrapper> entries = StreamSupport.stream(this.panelManager.getReverseOpenPanelsWrappers().spliterator(), false);
        WidgetWrapper.updateNarrations(entries, output, this.lastNarratable, entry -> {
            this.lastNarratable = entry;
        });
    }

    @NotNull
    public NarratableEntry.NarrationPriority m_142684_() {
        if (this.m_93696_()) {
            return NarratableEntry.NarrationPriority.FOCUSED;
        }
        if (this.context.isHovered()) {
            return NarratableEntry.NarrationPriority.HOVERED;
        }
        return NarratableEntry.NarrationPriority.NONE;
    }

    @Generated
    public String getOwner() {
        return this.owner;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public PanelManager getPanelManager() {
        return this.panelManager;
    }

    @Generated
    public ModularGuiContext getContext() {
        return this.context;
    }

    @Generated
    public ScreenResizeNode getResizeNode() {
        return this.resizeNode;
    }

    @Generated
    public boolean isPauseScreen() {
        return this.pauseScreen;
    }

    @Generated
    public boolean isOpenParentOnClose() {
        return this.openParentOnClose;
    }

    @Nullable
    @Generated
    public String getThemeOverride() {
        return this.themeOverride;
    }

    @Generated
    public IMuiScreen getScreenWrapper() {
        return this.screenWrapper;
    }

    @Generated
    public boolean isOverlay() {
        return this.overlay;
    }
}

