/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.screen;

import brachy.modularui.ModularUIConfig;
import brachy.modularui.animation.Animator;
import brachy.modularui.api.IPanelHandler;
import brachy.modularui.api.ITheme;
import brachy.modularui.api.IThemeApi;
import brachy.modularui.api.MCHelper;
import brachy.modularui.api.layout.IViewport;
import brachy.modularui.api.layout.IViewportStack;
import brachy.modularui.api.value.ISyncOrValue;
import brachy.modularui.api.widget.IDragResizeable;
import brachy.modularui.api.widget.IFocusedWidget;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.api.widget.Interactable;
import brachy.modularui.api.widget.ResizeDragArea;
import brachy.modularui.screen.ModularScreen;
import brachy.modularui.screen.viewport.GuiViewportStack;
import brachy.modularui.screen.viewport.LocatedWidget;
import brachy.modularui.screen.viewport.ModularGuiContext;
import brachy.modularui.theme.WidgetThemeEntry;
import brachy.modularui.utils.HoveredWidgetList;
import brachy.modularui.utils.Interpolation;
import brachy.modularui.utils.Interpolations;
import brachy.modularui.utils.ObjectList;
import brachy.modularui.value.sync.PanelSyncHandler;
import brachy.modularui.widget.ParentWidget;
import brachy.modularui.widget.WidgetTree;
import brachy.modularui.widget.sizer.Area;
import brachy.modularui.widgets.SlotGroupWidget;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.Util;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModularPanel
extends ParentWidget<ModularPanel>
implements IViewport,
IDragResizeable {
    private static final int tapTime = 200;
    @NotNull
    private final String name;
    private ModularScreen screen;
    private IPanelHandler panelHandler;
    private State state = State.IDLE;
    private boolean cantDisposeNow = false;
    @NotNull
    private final ObjectList<LocatedWidget> hovering = ObjectList.create();
    private final Input keyboard = new Input();
    private final Input mouse = new Input();
    private IDragResizeable currentResizing = null;
    private LocatedWidget currentResizingWidget = null;
    private ResizeDragArea draggingDragArea = null;
    private final Area startArea = new Area();
    private int dragX;
    private int dragY;
    private final List<IPanelHandler> clientSubPanels = new ArrayList<IPanelHandler>();
    private boolean invisible = false;
    private Animator animator;
    private boolean resizeable = false;
    private String themeOverride;
    private ITheme theme;
    private Runnable onCloseAction;

    public static ModularPanel defaultPanel(@NotNull String name) {
        return ModularPanel.defaultPanel(name, 176, 166);
    }

    public static ModularPanel defaultPanel(@NotNull String name, int width, int height) {
        return (ModularPanel)new ModularPanel(name).size(width, height);
    }

    public ModularPanel(@NotNull String name) {
        this.name = Objects.requireNonNull(name, "A panels name must not be null and should be unique!");
        this.center();
    }

    @Override
    @NotNull
    public ModularPanel getPanel() {
        return this;
    }

    @Override
    public Area getParentArea() {
        return this.getScreen().getScreenArea();
    }

    @Override
    public void onInit() {
        this.getScreen().registerFrameUpdateListener(this, this::findHoveredWidgets, false);
    }

    @Override
    public boolean isValidSyncOrValue(@NotNull ISyncOrValue syncOrValue) {
        return syncOrValue.isTypeOrEmpty(IPanelHandler.class);
    }

    @Override
    protected void setSyncOrValue(@NotNull ISyncOrValue syncOrValue) {
        super.setSyncOrValue(syncOrValue);
        this.setPanelHandler(syncOrValue.castNullable(IPanelHandler.class));
    }

    @ApiStatus.Internal
    public void setPanelSyncHandler(PanelSyncHandler syncHandler) {
        this.setSyncOrValue(ISyncOrValue.orEmpty(syncHandler));
    }

    public boolean isOpen() {
        return this.state == State.OPEN;
    }

    public void closeIfOpen() {
        if (!this.isOpen()) {
            return;
        }
        this.closeSubPanels();
        if (this.isMainPanel()) {
            MCHelper.popScreen(this.getScreen().isOpenParentOnClose(), this.getContext().getParent());
            return;
        }
        if (!this.shouldAnimate()) {
            this.screen.getPanelManager().closePanel(this);
            return;
        }
        if (!this.isOpening() && !this.isClosing()) {
            if (this.isMainPanel()) {
                for (ModularPanel panel : this.getScreen().getPanelManager().getOpenPanels()) {
                    if (panel.isMainPanel()) continue;
                    panel.closeIfOpen();
                }
            }
            this.getAnimator().onFinish(() -> this.screen.getPanelManager().closePanel(this));
            this.getAnimator().reset(true);
            this.getAnimator().animate(true);
        }
    }

    protected void closeSubPanels() {
        if (this.panelHandler != null) {
            this.panelHandler.closeSubPanels();
        }
    }

    @Deprecated
    public void animateClose() {
        this.closeIfOpen();
    }

    @Override
    public boolean hasParent() {
        return false;
    }

    @Override
    public WidgetThemeEntry<?> getWidgetThemeInternal(ITheme theme) {
        return theme.getPanelTheme();
    }

    @Override
    public void transform(IViewportStack stack) {
        super.transform(stack);
        float scale = this.getScale();
        if (scale != 1.0f) {
            float x = (float)this.getArea().w() / 2.0f;
            float y = (float)this.getArea().h() / 2.0f;
            stack.translate(x, y);
            stack.scale(scale, scale);
            stack.translate(-x, -y);
        }
    }

    private void findHoveredWidgets() {
        this.hovering.clear();
        if (!this.isEnabled()) {
            return;
        }
        HoveredWidgetList widgetList = new HoveredWidgetList(this.hovering);
        this.getContext().reset();
        GuiViewportStack stack = new GuiViewportStack();
        stack.pushViewport(null, this.getScreen().getScreenArea());
        stack.pushViewport(this, this.getArea());
        this.transform(stack);
        this.getSelfAt(stack, widgetList, this.getContext().getAbsMouseX(), this.getContext().getAbsMouseY());
        this.transformChildren(stack);
        this.getWidgetsAt(stack, widgetList, this.getContext().getAbsMouseX(), this.getContext().getAbsMouseY());
        stack.popViewport(this);
        stack.popViewport(null);
        stack.reset();
    }

    @Override
    public boolean canHover() {
        return !this.invisible && super.canHover();
    }

    @MustBeInvokedByOverriders
    public void onOpen(ModularScreen screen) {
        this.screen = screen;
        this.getArea().z(1);
        this.resizer().initialize(this.screen.getResizeNode(), this.screen.getResizeNode());
        this.initialise(this, false);
        WidgetTree.onUpdate(this);
        if (this.shouldAnimate()) {
            this.getAnimator().onFinish(() -> {});
            this.getAnimator().reset();
            this.getAnimator().animate();
        }
        this.state = State.OPEN;
    }

    void reopen() {
        this.state = State.OPEN;
    }

    @MustBeInvokedByOverriders
    public void onClose() {
        if (this.onCloseAction != null) {
            this.onCloseAction.run();
        }
        this.state = State.CLOSED;
        if (this.panelHandler != null) {
            this.panelHandler.closePanelInternal();
        }
    }

    @Override
    public boolean isExcludeAreaInRecipeViewer() {
        return super.isExcludeAreaInRecipeViewer() || !this.getScreen().isOverlay() && !this.invisible && !this.resizer().isFullSize();
    }

    @Override
    @MustBeInvokedByOverriders
    public void dispose() {
        if (this.state == State.DISPOSED) {
            return;
        }
        if (this.state != State.CLOSED && this.state != State.WAIT_DISPOSING) {
            throw new IllegalStateException("Panel must be closed before disposing!");
        }
        if (this.cantDisposeNow) {
            this.state = State.WAIT_DISPOSING;
            return;
        }
        super.dispose();
        this.screen = null;
        this.state = State.DISPOSED;
    }

    public final <T> T doSafe(Supplier<T> runnable) {
        if (this.state == State.DISPOSED) {
            return null;
        }
        return (T)this.getScreen().getPanelManager().doSafe(() -> {
            this.cantDisposeNow = true;
            Object t = runnable.get();
            this.cantDisposeNow = false;
            if (this.state == State.WAIT_DISPOSING) {
                this.state = State.CLOSED;
                this.dispose();
            }
            return t;
        });
    }

    public final boolean doSafeBool(BooleanSupplier runnable) {
        return Objects.requireNonNull(this.doSafe(runnable::getAsBoolean));
    }

    public final int doSafeInt(IntSupplier runnable) {
        return Objects.requireNonNull(this.doSafe(runnable::getAsInt));
    }

    public boolean onMousePressed(double mouseX, double mouseY, int button) {
        return this.doSafeBool(() -> {
            boolean result;
            LocatedWidget pressed;
            block12: {
                block11: {
                    pressed = LocatedWidget.EMPTY;
                    result = false;
                    if (!this.hovering.isEmpty()) break block11;
                    if (!this.closeOnOutOfBoundsClick()) break block12;
                    this.closeIfOpen();
                    result = true;
                    break block12;
                }
                ObjectListIterator objectListIterator = this.hovering.iterator();
                while (objectListIterator.hasNext()) {
                    Object patt12211$temp;
                    LocatedWidget widget = (LocatedWidget)objectListIterator.next();
                    if (widget.getElement() == null || !((IWidget)widget.getElement()).isValid()) continue;
                    widget.applyMatrix(this.getContext());
                    IWidget w = (IWidget)widget.getElement();
                    if (w instanceof IDragResizeable) {
                        IDragResizeable resizeable = (IDragResizeable)((Object)w);
                        Object patt11477$temp = widget.getAdditionalHoverInfo();
                        if (patt11477$temp instanceof ResizeDragArea) {
                            ResizeDragArea dragArea = (ResizeDragArea)((Object)((Object)patt11477$temp));
                            this.currentResizing = resizeable;
                            this.currentResizingWidget = widget;
                            this.dragX = this.getContext().getMouseX();
                            this.dragY = this.getContext().getMouseY();
                            this.startArea.set(w.getArea());
                            this.startArea.rx = w.getArea().rx;
                            this.startArea.ry = w.getArea().ry;
                            this.draggingDragArea = dragArea;
                            widget.unapplyMatrix(this.getContext());
                            break;
                        }
                    }
                    if ((patt12211$temp = widget.getElement()) instanceof Interactable) {
                        Interactable interactable = (Interactable)patt12211$temp;
                        Interactable.Result interactResult = interactable.onMousePressed(mouseX, mouseY, button);
                        if (interactResult.accepts) {
                            this.mouse.addAcceptedInteractable(interactable);
                            pressed = widget;
                        } else if (interactResult.stops) {
                            pressed = LocatedWidget.EMPTY;
                        }
                        if (interactResult.stops) {
                            result = true;
                            widget.unapplyMatrix(this.getContext());
                            break;
                        }
                    }
                    if (this.getContext().onHoveredClick(button, widget)) {
                        pressed = LocatedWidget.EMPTY;
                        result = true;
                        widget.unapplyMatrix(this.getContext());
                        break;
                    }
                    widget.unapplyMatrix(this.getContext());
                    if (((IWidget)widget.getElement()).canClickThrough()) continue;
                    result = true;
                    pressed = widget;
                    break;
                }
            }
            if (result && pressed.getElement() instanceof IFocusedWidget) {
                this.getContext().focus(pressed);
            } else {
                this.getContext().removeFocus();
            }
            this.mouse.pressed(pressed, button);
            return result;
        });
    }

    public boolean onMouseReleased(double mouseX, double mouseY, int button) {
        return this.isEnabled() && this.doSafeBool(() -> {
            Interactable interactable;
            LocatedWidget widget2;
            if (!this.mouse.doRelease) {
                this.mouse.reset();
                return false;
            }
            if (this.currentResizing != null) {
                this.mouse.reset();
                this.currentResizing = null;
                this.currentResizingWidget = null;
                return true;
            }
            if (this.interactFocused(widget -> ((Interactable)((Object)widget)).onMouseReleased(mouseX, mouseY, button), false).booleanValue()) {
                return true;
            }
            boolean lastPressedIsHovered = false;
            boolean tryTap = this.mouse.tryTap(button);
            ObjectListIterator objectListIterator = this.hovering.iterator();
            while (objectListIterator.hasNext()) {
                widget2 = (LocatedWidget)objectListIterator.next();
                if (widget2.getElement() == null || !((IWidget)widget2.getElement()).isValid() || !this.mouse.isWidget(widget2)) continue;
                Object patt15046$temp = widget2.getElement();
                if (patt15046$temp instanceof Interactable && this.onMouseReleased(mouseX, mouseY, button, tryTap, widget2, interactable = (Interactable)patt15046$temp)) {
                    return true;
                }
                lastPressedIsHovered = true;
                break;
            }
            objectListIterator = this.hovering.iterator();
            while (objectListIterator.hasNext()) {
                Object patt15617$temp;
                widget2 = (LocatedWidget)objectListIterator.next();
                if (widget2.getElement() == null || !((IWidget)widget2.getElement()).isValid() || this.mouse.isWidget(widget2) || !((patt15617$temp = widget2.getElement()) instanceof Interactable) || !this.onMouseReleased(mouseX, mouseY, button, tryTap, widget2, interactable = (Interactable)patt15617$temp)) continue;
                return true;
            }
            if (lastPressedIsHovered) {
                this.mouse.reset();
                return true;
            }
            this.mouse.reset();
            return false;
        });
    }

    private boolean onMouseReleased(double mouseX, double mouseY, int button, boolean tryTap, LocatedWidget widget, Interactable interactable) {
        boolean stop = false;
        widget.applyMatrix(this.getContext());
        if (tryTap && this.mouse.acceptedInteractions.remove(interactable)) {
            Interactable.Result tabResult = interactable.onMouseTapped(mouseX, mouseY, button);
            if (tabResult.stops) {
                stop = true;
            }
        }
        if (interactable.onMouseReleased(mouseX, mouseY, button)) {
            stop = true;
        }
        widget.unapplyMatrix(this.getContext());
        if (stop) {
            this.mouse.reset();
            return true;
        }
        return false;
    }

    public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        return this.doSafeBool(() -> {
            switch (this.interactFocused(widget -> ((Interactable)((Object)widget)).onKeyPressed(keyCode, scanCode, modifiers), Interactable.Result.IGNORE)) {
                case STOP: {
                    this.keyboard.pressed(LocatedWidget.EMPTY, keyCode);
                    return true;
                }
                case SUCCESS: {
                    this.keyboard.pressed(this.getContext().getFocusedWidget(), keyCode);
                    return true;
                }
            }
            LocatedWidget pressed = null;
            boolean result = false;
            ObjectListIterator objectListIterator = this.hovering.iterator();
            while (objectListIterator.hasNext()) {
                LocatedWidget widget2 = (LocatedWidget)objectListIterator.next();
                if (widget2.getElement() == null || !((IWidget)widget2.getElement()).isValid()) continue;
                Object patt17862$temp = widget2.getElement();
                if (patt17862$temp instanceof Interactable) {
                    Interactable interactable = (Interactable)patt17862$temp;
                    widget2.applyMatrix(this.getContext());
                    Interactable.Result interactResult = interactable.onKeyPressed(keyCode, scanCode, modifiers);
                    if (interactResult.accepts) {
                        this.keyboard.addAcceptedInteractable(interactable);
                        pressed = widget2;
                    } else if (interactResult.stops) {
                        pressed = null;
                    }
                    if (interactResult.stops) {
                        result = true;
                        widget2.unapplyMatrix(this.getContext());
                        break;
                    }
                    widget2.unapplyMatrix(this.getContext());
                }
                if (((IWidget)widget2.getElement()).canClickThrough()) continue;
                break;
            }
            this.keyboard.pressed(pressed, keyCode);
            return result;
        });
    }

    public boolean onKeyReleased(int keyCode, int scanCode, int modifiers) {
        return this.doSafeBool(() -> {
            Interactable interactable;
            LocatedWidget widget2;
            if (!this.keyboard.doRelease) {
                this.keyboard.reset();
                return false;
            }
            if (this.interactFocused(widget -> ((Interactable)((Object)widget)).onKeyReleased(keyCode, scanCode, modifiers), false).booleanValue()) {
                return true;
            }
            boolean lastPressedIsHovered = false;
            boolean tryTap = this.keyboard.tryTap(keyCode);
            ObjectListIterator objectListIterator = this.hovering.iterator();
            while (objectListIterator.hasNext()) {
                widget2 = (LocatedWidget)objectListIterator.next();
                if (widget2.getElement() == null || !((IWidget)widget2.getElement()).isValid() || !this.keyboard.isWidget(widget2)) continue;
                Object patt19645$temp = widget2.getElement();
                if (patt19645$temp instanceof Interactable && this.onKeyReleased(keyCode, scanCode, modifiers, tryTap, widget2, interactable = (Interactable)patt19645$temp)) {
                    return true;
                }
                lastPressedIsHovered = true;
                break;
            }
            objectListIterator = this.hovering.iterator();
            while (objectListIterator.hasNext()) {
                Object patt20223$temp;
                widget2 = (LocatedWidget)objectListIterator.next();
                if (widget2.getElement() == null || !((IWidget)widget2.getElement()).isValid() || this.keyboard.isWidget(widget2) || !((patt20223$temp = widget2.getElement()) instanceof Interactable) || !this.onKeyReleased(keyCode, scanCode, modifiers, tryTap, widget2, interactable = (Interactable)patt20223$temp)) continue;
                return true;
            }
            if (lastPressedIsHovered) {
                this.keyboard.reset();
                return true;
            }
            this.keyboard.reset();
            return false;
        });
    }

    private boolean onKeyReleased(int keyCode, int scanCode, int modifiers, boolean tryTap, LocatedWidget widget, Interactable interactable) {
        boolean stop = false;
        widget.applyMatrix(this.getContext());
        if (tryTap && this.keyboard.acceptedInteractions.remove(interactable)) {
            Interactable.Result tabResult = interactable.onKeyTapped(keyCode, scanCode, modifiers);
            if (tabResult.stops) {
                stop = true;
            }
        }
        if (interactable.onKeyReleased(keyCode, scanCode, modifiers)) {
            stop = true;
        }
        widget.unapplyMatrix(this.getContext());
        if (stop) {
            this.keyboard.reset();
            return true;
        }
        return false;
    }

    public boolean onCharTyped(char codePoint, int modifiers) {
        return this.doSafeBool(() -> {
            switch (this.interactFocused(widget -> ((Interactable)((Object)widget)).onCharTyped(codePoint, modifiers), Interactable.Result.IGNORE)) {
                case STOP: {
                    this.keyboard.pressed(LocatedWidget.EMPTY, codePoint);
                    return true;
                }
                case SUCCESS: {
                    this.keyboard.pressed(this.getContext().getFocusedWidget(), codePoint);
                    return true;
                }
            }
            LocatedWidget pressed = null;
            boolean result = false;
            ObjectListIterator objectListIterator = this.hovering.iterator();
            while (objectListIterator.hasNext()) {
                LocatedWidget widget2 = (LocatedWidget)objectListIterator.next();
                if (widget2.getElement() == null || !((IWidget)widget2.getElement()).isValid()) continue;
                Object patt22451$temp = widget2.getElement();
                if (patt22451$temp instanceof Interactable) {
                    Interactable interactable = (Interactable)patt22451$temp;
                    widget2.applyMatrix(this.getContext());
                    Interactable.Result interactResult = interactable.onCharTyped(codePoint, modifiers);
                    if (interactResult.accepts) {
                        this.keyboard.addAcceptedInteractable(interactable);
                        pressed = widget2;
                    } else if (interactResult.stops) {
                        pressed = null;
                    }
                    if (interactResult.stops) {
                        result = true;
                        widget2.unapplyMatrix(this.getContext());
                        break;
                    }
                    widget2.unapplyMatrix(this.getContext());
                }
                if (((IWidget)widget2.getElement()).canClickThrough()) continue;
                break;
            }
            this.keyboard.pressed(pressed, codePoint);
            return result;
        });
    }

    public boolean onMouseScrolled(double mouseX, double mouseY, double delta) {
        return this.doSafeBool(() -> {
            if (this.interactFocused(widget -> ((Interactable)((Object)widget)).onMouseScrolled(mouseX, mouseY, delta), false).booleanValue()) {
                return true;
            }
            if (this.hovering.isEmpty()) {
                return false;
            }
            ObjectListIterator objectListIterator = this.hovering.iterator();
            while (objectListIterator.hasNext()) {
                Object patt23894$temp;
                LocatedWidget widget2 = (LocatedWidget)objectListIterator.next();
                if (widget2.getElement() == null || !((IWidget)widget2.getElement()).isValid() || !((patt23894$temp = widget2.getElement()) instanceof Interactable)) continue;
                Interactable interactable = (Interactable)patt23894$temp;
                widget2.applyMatrix(this.getContext());
                boolean result = interactable.onMouseScrolled(mouseX, mouseY, delta);
                widget2.unapplyMatrix(this.getContext());
                if (!result) continue;
                return true;
            }
            return false;
        });
    }

    public boolean onMouseDrag(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.doSafeBool(() -> {
            Object patt25248$temp;
            if (this.currentResizing != null) {
                this.currentResizingWidget.applyMatrix(this.getContext());
                int mx = this.getContext().getMouseX();
                int my = this.getContext().getMouseY();
                this.currentResizingWidget.unapplyMatrix(this.getContext());
                int dx = mx - this.dragX;
                int dy = my - this.dragY;
                if (dx != 0 || dy != 0) {
                    IDragResizeable.applyDrag(this.currentResizing, (IWidget)((Object)this.currentResizing), this.draggingDragArea, this.startArea, dx, dy);
                }
                return true;
            }
            if (this.mouse.held && button == this.mouse.lastButton && this.mouse.lastPressed != null && (patt25248$temp = this.mouse.lastPressed.getElement()) instanceof Interactable) {
                Interactable interactable = (Interactable)patt25248$temp;
                if (((IWidget)this.mouse.lastPressed.getElement()).isValid()) {
                    this.mouse.lastPressed.applyMatrix(this.getContext());
                    interactable.onMouseDrag(mouseX, mouseY, button, dragX, dragY);
                    this.mouse.lastPressed.unapplyMatrix(this.getContext());
                    return true;
                }
            }
            return false;
        });
    }

    private <T, W extends IWidget & IFocusedWidget> T interactFocused(Function<W, T> function, T defaultValue) {
        LocatedWidget focused = this.getContext().getFocusedWidget();
        T result = defaultValue;
        Object t = focused.getElement();
        if (t instanceof Interactable) {
            Interactable interactable = (Interactable)t;
            if (((IWidget)focused.getElement()).isValid()) {
                focused.applyMatrix(this.getContext());
                result = function.apply((IWidget)((Object)interactable));
                focused.unapplyMatrix(this.getContext());
            }
        }
        return result;
    }

    public boolean isDraggable() {
        return this.getScreen().getMainPanel() != this;
    }

    public boolean disablePanelsBelow() {
        return false;
    }

    public boolean closeOnOutOfBoundsClick() {
        return false;
    }

    @Override
    public boolean isCurrentlyResizable() {
        return this.resizeable;
    }

    @Override
    public boolean keepPosOnDragResize() {
        return !this.isDraggable();
    }

    @Override
    public ModularScreen getScreen() {
        if (!this.isValid()) {
            throw new IllegalStateException();
        }
        return this.screen;
    }

    @Nullable
    public IWidget getTopHovering() {
        LocatedWidget lw = this.getTopHoveringLocated(false);
        return lw == null ? null : (IWidget)lw.getElement();
    }

    @Nullable
    public LocatedWidget getTopHoveringLocated(boolean debug) {
        int i = 0;
        while (i < this.hovering.size()) {
            LocatedWidget widget = (LocatedWidget)this.hovering.get(i);
            if (!((IWidget)widget.getElement()).isValid()) {
                this.hovering.remove(i);
                continue;
            }
            if (debug || ((IWidget)widget.getElement()).canHover()) {
                return widget;
            }
            ++i;
        }
        return null;
    }

    @NotNull
    public List<LocatedWidget> getAllHoveringList(boolean debug) {
        if (this.hovering.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<LocatedWidget>((Collection<LocatedWidget>)((Object)this.hovering));
    }

    public boolean isBelowMouse(IWidget widget) {
        if (!widget.isValid() || widget.getPanel() != this) {
            return false;
        }
        ObjectListIterator objectListIterator = this.hovering.iterator();
        while (objectListIterator.hasNext()) {
            LocatedWidget lw = (LocatedWidget)objectListIterator.next();
            if (lw.getElement() != widget) continue;
            return true;
        }
        return false;
    }

    public boolean isAnyHovered() {
        Object t;
        if (this.hovering.isEmpty()) {
            return false;
        }
        if (this.hovering.size() == 1 && (t = ((LocatedWidget)this.hovering.get(0)).getElement()) instanceof ModularPanel) {
            ModularPanel panel = (ModularPanel)t;
            return panel.canHover();
        }
        return true;
    }

    final void setPanelGuiContext(@NotNull ModularGuiContext context) {
        this.setContext(context);
    }

    public boolean isOpening() {
        return this.animator != null && this.animator.isAnimatingForward();
    }

    public boolean isClosing() {
        return this.animator != null && this.animator.isAnimatingReverse();
    }

    public float getScale() {
        if (ModularUIConfig.animationTime() == 0) {
            return 1.0f;
        }
        return Interpolations.lerp(0.9f, 1.0f, this.getAnimator().getValue());
    }

    public float getAlpha() {
        if (ModularUIConfig.animationTime() == 0) {
            return 1.0f;
        }
        return this.getAnimator().getValue();
    }

    public final boolean isMainPanel() {
        return this.getScreen().getMainPanel() == this;
    }

    @NotNull
    protected Animator getAnimator() {
        if (this.animator == null) {
            this.animator = new Animator().bounds(0.0f, 1.0f).duration(ModularUIConfig.animationTime()).curve(Interpolation.SINE_OUT);
            this.animator.reset(true);
        }
        return this.animator;
    }

    public boolean shouldAnimate() {
        if (this.invisible) {
            return false;
        }
        if (!this.isMainPanel() || !this.getScreen().isOpenParentOnClose()) {
            return true;
        }
        return this.getContext().getParent() == null;
    }

    void registerSubPanel(IPanelHandler handler) {
        if (!this.clientSubPanels.contains(handler)) {
            this.clientSubPanels.add(handler);
        }
    }

    void closeClientSubPanels() {
        for (IPanelHandler handler : this.clientSubPanels) {
            if (!handler.isSubPanel()) continue;
            handler.closePanel();
        }
    }

    public ITheme getTheme() {
        if (this.theme == null) {
            this.theme = IThemeApi.get().getThemeForScreen(this, this.themeOverride);
        }
        return this.theme;
    }

    public ModularPanel bindPlayerInventory() {
        return (ModularPanel)this.child(SlotGroupWidget.playerInventory(true));
    }

    public ModularPanel bindPlayerInventory(int bottom) {
        return (ModularPanel)this.child(SlotGroupWidget.playerInventory(bottom, true));
    }

    @Override
    public ModularPanel invisible() {
        this.invisible = true;
        return (ModularPanel)super.invisible();
    }

    public ModularPanel fullScreenInvisible() {
        return (ModularPanel)this.invisible().full();
    }

    public ModularPanel resizeableOnDrag(boolean resizeable) {
        this.resizeable = resizeable;
        return this;
    }

    public ModularPanel onCloseAction(Runnable onCloseAction) {
        this.onCloseAction = onCloseAction;
        return this;
    }

    public ModularPanel themeOverride(String id) {
        this.themeOverride = id;
        this.theme = null;
        return this;
    }

    @Override
    @Deprecated
    public ModularPanel name(String name) {
        throw new IllegalStateException("Name for ModularPanels are final!");
    }

    @Override
    @NotNull
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setPanelHandler(IPanelHandler panelHandler) {
        this.panelHandler = panelHandler;
    }

    @Generated
    public State getState() {
        return this.state;
    }

    @NotNull
    @Generated
    public ObjectList<LocatedWidget> getHovering() {
        return this.hovering;
    }

    public static enum State {
        IDLE,
        OPEN,
        CLOSED,
        DISPOSED,
        WAIT_DISPOSING;

    }

    private static class Input {
        private final ObjectList<Interactable> acceptedInteractions = ObjectList.create();
        @Nullable
        private LocatedWidget lastPressed;
        private boolean held;
        private long time;
        private int lastButton;
        private boolean doRelease = true;

        private Input() {
            this.reset();
        }

        private void addAcceptedInteractable(Interactable interactable) {
            if (!this.held) {
                this.acceptedInteractions.add(interactable);
            }
        }

        private void reset() {
            this.acceptedInteractions.clear();
            this.held = false;
            this.time = -1L;
            this.lastButton = -1;
            this.doRelease = true;
        }

        private boolean isValid() {
            return this.lastPressed != null && this.time > 0L;
        }

        private int getTimeSinceEvent() {
            return (int)Math.min(Util.m_137550_() - this.time, Integer.MAX_VALUE);
        }

        private boolean tryTap(int button) {
            return this.lastButton == button && this.getTimeSinceEvent() <= 200;
        }

        private boolean isWidget(IWidget widget) {
            return this.lastPressed != null && this.lastPressed.getElement() == widget;
        }

        private boolean isWidget(LocatedWidget widget) {
            return this.isWidget((IWidget)widget.getElement());
        }

        private void pressed(LocatedWidget pressed, int button) {
            if (!this.held) {
                this.lastPressed = pressed;
                if (this.lastPressed != null) {
                    this.time = Util.m_137550_();
                }
                this.lastButton = button;
                this.held = true;
            }
        }
    }
}

