/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.screen;

import brachy.modularui.ModularUI;
import brachy.modularui.ModularUIMenuTypes;
import brachy.modularui.core.mixins.client.AbstractContainerMenuAccessor;
import brachy.modularui.factory.GuiData;
import brachy.modularui.screen.ModularScreen;
import brachy.modularui.screen.UISettings;
import brachy.modularui.utils.NetworkUtils;
import brachy.modularui.value.sync.ModularSyncManager;
import brachy.modularui.widgets.slot.ModularSlot;
import brachy.modularui.widgets.slot.SlotGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public class ModularContainerMenu
extends AbstractContainerMenu {
    private static final int DROP_TO_WORLD = -999;
    private static final int LEFT_MOUSE = 0;
    private static final int RIGHT_MOUSE = 1;
    private Player player;
    private ModularSyncManager syncManager;
    private boolean init = true;
    private final List<ModularSlot> phantomSlots = new ArrayList<ModularSlot>();
    private final List<ModularSlot> shiftClickSlots = new ArrayList<ModularSlot>();
    private GuiData guiData;
    private UISettings settings;
    @OnlyIn(value=Dist.CLIENT)
    private ModularScreen optionalScreen;

    public static ModularContainerMenu getCurrent(Player player) {
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof ModularContainerMenu) {
            ModularContainerMenu container = (ModularContainerMenu)abstractContainerMenu;
            return container;
        }
        return null;
    }

    public ModularContainerMenu(int containerId) {
        super((MenuType)ModularUIMenuTypes.MODULAR_CONTAINER.get(), containerId);
    }

    public <T extends GuiData> ModularContainerMenu(int containerId, Inventory playerInv, @Nullable FriendlyByteBuf data) {
        this(containerId);
        throw new IllegalArgumentException("Do not open the modular container the forge way. Use an UIFactory!");
    }

    @ApiStatus.Internal
    public void construct(Player player, ModularSyncManager msm, UISettings settings, String mainPanelName, GuiData guiData) {
        this.player = player;
        this.syncManager = msm;
        this.syncManager.construct(this, mainPanelName);
        this.settings = settings;
        this.guiData = guiData;
        this.sortShiftClickSlots();
    }

    @OnlyIn(value=Dist.CLIENT)
    void initializeClient(ModularScreen screen) {
        this.optionalScreen = screen;
    }

    @OnlyIn(value=Dist.CLIENT)
    @ApiStatus.Internal
    public void constructClientOnly() {
        this.player = Minecraft.m_91087_().f_91074_;
        this.syncManager = null;
    }

    public boolean isInitialized() {
        return this.player != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ModularScreen getScreen() {
        if (this.optionalScreen == null) {
            throw new NullPointerException("ModularScreen is not yet initialised!");
        }
        return this.optionalScreen;
    }

    public boolean isScreenInitialized() {
        return this.optionalScreen != null;
    }

    public AbstractContainerMenuAccessor acc() {
        return (AbstractContainerMenuAccessor)((Object)this);
    }

    public void opened() {
    }

    public void closed() {
    }

    public void disposed() {
    }

    @MustBeInvokedByOverriders
    public void m_38946_() {
        super.m_38946_();
        if (this.syncManager != null) {
            this.syncManager.detectAndSendChanges(this.init);
        }
        this.init = false;
    }

    @MustBeInvokedByOverriders
    public void onUpdate() {
        if (this.syncManager != null) {
            this.syncManager.onUpdate();
        }
    }

    private void sortShiftClickSlots() {
        this.shiftClickSlots.sort(ModularSlot.SHIFT_CLICK_PRIORITY);
    }

    public void m_182410_(int stateId, List<ItemStack> items, @NotNull ItemStack carried) {
        if (this.f_38839_.size() != items.size()) {
            ModularUI.LOGGER.error("Here are {} slots, but expected {}", (Object)this.f_38839_.size(), (Object)items.size());
        }
        super.m_182410_(stateId, items, carried);
    }

    @ApiStatus.Internal
    public void registerSlot(String panelName, ModularSlot slot) {
        SlotGroup slotGroup;
        if (slot.isPhantom()) {
            if (this.phantomSlots.contains((Object)slot)) {
                throw new IllegalArgumentException("Tried to register slot which already exists!");
            }
            this.phantomSlots.add(slot);
        } else {
            if (this.f_38839_.contains((Object)slot)) {
                throw new IllegalArgumentException("Tried to register slot which already exists!");
            }
            this.m_38897_((Slot)slot);
        }
        if (slot.getSlotGroupName() != null) {
            slotGroup = this.getSyncManager().getSlotGroup(panelName, slot.getSlotGroupName());
            if (slotGroup == null) {
                ModularUI.LOGGER.throwing((Throwable)new IllegalArgumentException("SlotGroup '" + slot.getSlotGroupName() + "' is not registered!"));
                return;
            }
            slot.slotGroup(slotGroup);
        }
        if (slot.getSlotGroup() != null && (slotGroup = slot.getSlotGroup()).isAllowShiftTransfer()) {
            this.shiftClickSlots.add(slot);
            if (!this.init) {
                this.sortShiftClickSlots();
            }
        }
    }

    @Contract(value="_, null, null -> fail")
    @NotNull
    @ApiStatus.Internal
    public SlotGroup validateSlotGroup(String panelName, @Nullable String slotGroupName, @Nullable SlotGroup slotGroup) {
        if (slotGroup != null) {
            if (this.getSyncManager().getSlotGroup(panelName, slotGroup.getName()) == null) {
                throw new IllegalArgumentException("Slot group is not registered in the GUI.");
            }
            return slotGroup;
        }
        if (slotGroupName != null) {
            slotGroup = this.getSyncManager().getSlotGroup(panelName, slotGroupName);
            if (slotGroup == null) {
                throw new IllegalArgumentException("Can't find slot group for name " + slotGroupName);
            }
            return slotGroup;
        }
        throw new IllegalArgumentException("Either the slot group or the name must not be null!");
    }

    public ModularSyncManager getSyncManager() {
        if (this.syncManager == null) {
            throw new IllegalStateException("GuiSyncManager is not available for client only GUI's.");
        }
        return this.syncManager;
    }

    public boolean isClient() {
        return this.syncManager == null || NetworkUtils.isClient(this.player);
    }

    public boolean isClientOnly() {
        return this.syncManager == null;
    }

    public ModularSlot getModularSlot(int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot instanceof ModularSlot) {
            ModularSlot modularSlot = (ModularSlot)slot;
            return modularSlot;
        }
        throw new IllegalStateException("A non-ModularSlot was found, but all slots in a ModularContainer must extend ModularSlot.");
    }

    public @UnmodifiableView List<ModularSlot> getShiftClickSlots() {
        return Collections.unmodifiableList(this.shiftClickSlots);
    }

    public void onSlotChanged(ModularSlot slot, ItemStack stack, boolean onlyAmountChanged) {
    }

    public boolean m_6875_(@NotNull Player playerIn) {
        return this.settings.canPlayerInteractWithUI(playerIn);
    }

    public void m_150399_(int slotId, int mouseButton, @NotNull ClickType clickTypeIn, @NotNull Player player) {
        ItemStack returnable = ItemStack.f_41583_;
        Inventory inventory = player.m_150109_();
        if (clickTypeIn == ClickType.QUICK_CRAFT || this.acc().getQuickcraftType() != -1) {
            this.superClicked(slotId, mouseButton, clickTypeIn, player);
            return;
        }
        if (!(clickTypeIn != ClickType.PICKUP && clickTypeIn != ClickType.QUICK_MOVE || mouseButton != 0 && mouseButton != 1)) {
            if (slotId == -999) {
                this.superClicked(slotId, mouseButton, clickTypeIn, player);
                return;
            }
            if (slotId < 0) {
                return;
            }
            if (clickTypeIn == ClickType.QUICK_MOVE) {
                ItemStack remainder;
                Slot fromSlot = this.m_38853_(slotId);
                if (!fromSlot.m_8010_(player)) {
                    return;
                }
                do {
                    remainder = this.m_7648_(player, slotId);
                    returnable = remainder.m_41777_();
                } while (!remainder.m_41619_() && ItemHandlerHelper.canItemStacksStack((ItemStack)fromSlot.m_7993_(), (ItemStack)remainder));
            } else {
                Slot clickedSlot = this.m_38853_(slotId);
                ItemStack slotStack = clickedSlot.m_7993_();
                ItemStack heldStack = this.m_142621_();
                if (slotStack.m_41619_()) {
                    if (!heldStack.m_41619_() && clickedSlot.m_5857_(heldStack)) {
                        int lim;
                        int stackCount = mouseButton == 0 ? heldStack.m_41613_() : 1;
                        if (stackCount > (lim = clickedSlot.m_5866_(heldStack))) {
                            stackCount = lim;
                        }
                        clickedSlot.m_269060_(heldStack.m_41620_(stackCount));
                    }
                } else if (clickedSlot.m_8010_(player)) {
                    int stackCount;
                    if (heldStack.m_41619_() && !slotStack.m_41619_()) {
                        int s = Math.min(slotStack.m_41613_(), slotStack.m_41741_());
                        int toRemove = mouseButton == 0 ? s : (s + 1) / 2;
                        this.m_142503_(slotStack.m_41620_(toRemove));
                        clickedSlot.m_269060_(slotStack);
                        clickedSlot.m_142406_(player, this.m_142621_());
                    } else if (clickedSlot.m_5857_(heldStack)) {
                        if (ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)heldStack)) {
                            int lim;
                            int stackCount2 = mouseButton == 0 ? heldStack.m_41613_() : 1;
                            if (stackCount2 > (lim = clickedSlot.m_5866_(heldStack)) - slotStack.m_41613_()) {
                                stackCount2 = lim - slotStack.m_41613_();
                            }
                            heldStack.m_41774_(stackCount2);
                            slotStack.m_41769_(stackCount2);
                            clickedSlot.m_269060_(slotStack);
                        } else if (heldStack.m_41613_() <= clickedSlot.m_5866_(heldStack)) {
                            clickedSlot.m_269060_(heldStack);
                            this.m_142503_(slotStack);
                        }
                    } else if (heldStack.m_41741_() > 1 && ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)heldStack) && !slotStack.m_41619_() && (stackCount = slotStack.m_41613_()) + heldStack.m_41613_() <= heldStack.m_41741_()) {
                        heldStack.m_41769_(stackCount);
                        slotStack = clickedSlot.m_6201_(stackCount);
                        if (slotStack.m_41619_()) {
                            clickedSlot.m_269060_(ItemStack.f_41583_);
                        }
                        clickedSlot.m_142406_(player, this.m_142621_());
                    }
                }
                clickedSlot.m_6654_();
            }
            this.m_38946_();
        } else if (clickTypeIn == ClickType.PICKUP_ALL && slotId >= 0) {
            Slot slot = (Slot)this.f_38839_.get(slotId);
            ItemStack carried = this.m_142621_();
            if (!(carried.m_41619_() || slot.m_6657_() && slot.m_8010_(player))) {
                int i = mouseButton == 0 ? 0 : this.f_38839_.size() - 1;
                int j = mouseButton == 0 ? 1 : -1;
                for (int k = 0; k < 2; ++k) {
                    for (int l = i; l >= 0 && l < this.f_38839_.size() && carried.m_41613_() < carried.m_41741_(); l += j) {
                        ModularSlot modularSlot;
                        Slot slot1 = (Slot)this.f_38839_.get(l);
                        if (slot1 instanceof ModularSlot && (modularSlot = (ModularSlot)slot1).isPhantom() || !slot1.m_6657_() || !ModularContainerMenu.m_38899_((Slot)slot1, (ItemStack)carried, (boolean)true) || !slot1.m_8010_(player) || !this.m_5882_(carried, slot1)) continue;
                        ItemStack slotItem = slot1.m_7993_();
                        if (k == 0 && slotItem.m_41613_() == slotItem.m_41741_()) continue;
                        int toRemove = Math.min(carried.m_41741_() - carried.m_41613_(), slotItem.m_41613_());
                        ItemStack removed = slot1.m_6201_(toRemove);
                        carried.m_41769_(toRemove);
                        if (removed.m_41619_()) {
                            slot1.m_269060_(ItemStack.f_41583_);
                        }
                        slot1.m_142406_(player, removed);
                    }
                }
            }
            this.m_38946_();
        } else if (clickTypeIn == ClickType.SWAP && mouseButton >= 0 && mouseButton < 9) {
            ModularSlot phantom = this.getModularSlot(slotId);
            ItemStack hotbarStack = inventory.m_8020_(mouseButton);
            if (phantom.isPhantom()) {
                phantom.m_269060_(hotbarStack.m_41619_() ? ItemStack.f_41583_ : hotbarStack.m_41777_());
                this.m_38946_();
            }
        } else {
            this.superClicked(slotId, mouseButton, clickTypeIn, player);
        }
    }

    protected final void superClicked(int slotId, int mouseButton, @NotNull ClickType clickTypeIn, @NotNull Player player) {
        super.m_150399_(slotId, mouseButton, clickTypeIn, player);
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player playerIn, int index) {
        ItemStack stack;
        ModularSlot slot = this.getModularSlot(index);
        if (!slot.isPhantom() && !(stack = slot.m_7993_()).m_41619_()) {
            ItemStack remainder;
            ItemStack copy = stack.m_41777_();
            stack = stack.m_41777_();
            int base = 0;
            if (stack.m_41613_() > stack.m_41741_()) {
                base = stack.m_41613_() - stack.m_41741_();
                stack.m_41764_(stack.m_41741_());
            }
            if (ItemStack.m_150942_((ItemStack)(remainder = this.transferItem(slot, stack.m_41777_())), (ItemStack)stack)) {
                return ItemStack.f_41583_;
            }
            if (base == 0 && remainder.m_41619_()) {
                stack = ItemStack.f_41583_;
            } else {
                stack.m_41764_(base + remainder.m_41613_());
            }
            slot.m_5852_(stack);
            slot.m_40234_(remainder, copy);
            slot.m_142406_(playerIn, remainder);
            slot.onCraftShiftClick(playerIn, remainder);
            return ItemStack.f_41583_;
        }
        return ItemStack.f_41583_;
    }

    protected ItemStack transferItem(ModularSlot fromSlot, ItemStack fromStack) {
        @Nullable SlotGroup fromSlotGroup = fromSlot.getSlotGroup();
        for (ModularSlot toSlot : this.getShiftClickSlots()) {
            int maxSize;
            SlotGroup slotGroup = Objects.requireNonNull(toSlot.getSlotGroup());
            if (slotGroup == fromSlotGroup || !toSlot.m_6659_() || !toSlot.m_5857_(fromStack)) continue;
            ItemStack toStack = toSlot.m_7993_().m_41777_();
            if (fromSlot.isPhantom() || !ItemHandlerHelper.canItemStacksStack((ItemStack)fromStack, (ItemStack)toStack)) continue;
            int j = toStack.m_41613_() + fromStack.m_41613_();
            if (j <= (maxSize = toSlot.m_5866_(fromStack))) {
                fromStack.m_41764_(0);
                toStack.m_41764_(j);
                toSlot.m_5852_(toStack);
            } else if (toStack.m_41613_() < maxSize) {
                fromStack.m_41774_(maxSize - toStack.m_41613_());
                toStack.m_41764_(maxSize);
                toSlot.m_5852_(toStack);
            }
            if (!fromStack.m_41619_()) continue;
            return fromStack;
        }
        boolean hasNonEmptyPhantom = false;
        for (ModularSlot toSlot : this.getShiftClickSlots()) {
            ItemStack itemstack = toSlot.m_7993_();
            SlotGroup slotGroup = Objects.requireNonNull(toSlot.getSlotGroup());
            if (slotGroup == fromSlotGroup || !toSlot.m_6659_() || !toSlot.m_5857_(fromStack)) continue;
            if (toSlot.isPhantom()) {
                if (!itemstack.m_41619_()) {
                    hasNonEmptyPhantom = true;
                    continue;
                }
                toSlot.m_5852_(fromStack.m_41777_());
                return fromStack;
            }
            if (!itemstack.m_41619_()) continue;
            if (fromStack.m_41613_() > toSlot.m_5866_(fromStack)) {
                toSlot.m_5852_(fromStack.m_41620_(toSlot.m_5866_(fromStack)));
            } else {
                toSlot.m_5852_(fromStack.m_41620_(fromStack.m_41613_()));
            }
            if (fromStack.m_41613_() >= 1) continue;
            break;
        }
        if (!hasNonEmptyPhantom) {
            return fromStack;
        }
        for (ModularSlot toSlot : this.getShiftClickSlots()) {
            SlotGroup slotGroup = Objects.requireNonNull(toSlot.getSlotGroup());
            if (slotGroup == fromSlotGroup || !toSlot.isPhantom() || !toSlot.m_6659_() || !toSlot.m_5857_(fromStack)) continue;
            toSlot.m_5852_(fromStack.m_41777_());
            return fromStack;
        }
        return fromStack;
    }

    @Generated
    public Player getPlayer() {
        return this.player;
    }

    @Generated
    public GuiData getGuiData() {
        return this.guiData;
    }
}

