/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.screen;

import brachy.modularui.api.layout.IViewportStack;
import brachy.modularui.api.widget.IDraggable;
import brachy.modularui.screen.ModularPanel;
import brachy.modularui.screen.viewport.ModularGuiContext;
import brachy.modularui.widget.WidgetTree;
import brachy.modularui.widget.sizer.Area;
import brachy.modularui.widget.sizer.StandardResizer;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;

public class DraggablePanelWrapper
implements IDraggable {
    private final ModularPanel panel;
    private final Area movingArea;
    private int relativeClickX;
    private int relativeClickY;
    private boolean moving;

    public DraggablePanelWrapper(ModularPanel panel) {
        this.panel = panel;
        this.movingArea = panel.getArea().createCopy();
    }

    @Override
    public void drawMovingState(GuiGraphics graphics, ModularGuiContext context, float partialTicks) {
        context.pushMatrix();
        this.transform(context);
        WidgetTree.drawTree(this.panel, context, true, true);
        context.popMatrix();
    }

    @Override
    public boolean onDragStart(int button) {
        if (button == 0) {
            ModularGuiContext context = this.panel.getContext();
            this.movingArea.x = context.transformX(0.0f, 0.0f);
            this.movingArea.y = context.transformY(0.0f, 0.0f);
            this.relativeClickX = context.getAbsMouseX() - this.movingArea.x;
            this.relativeClickY = context.getAbsMouseY() - this.movingArea.y;
            return true;
        }
        return false;
    }

    @Override
    public void onDragEnd(boolean successful) {
        if (successful) {
            float y = this.panel.getContext().getAbsMouseY() - this.relativeClickY;
            float x = this.panel.getContext().getAbsMouseX() - this.relativeClickX;
            this.panel.resizer().resetPosition();
            this.panel.resizer().relativeToScreen();
            ((StandardResizer)this.panel.resizer().topRelAnchor(y /= (float)(this.panel.getScreen().getScreenArea().height - this.panel.getArea().height), y)).leftRelAnchor(x /= (float)(this.panel.getScreen().getScreenArea().width - this.panel.getArea().width), x);
            this.panel.scheduleResize();
        }
    }

    @Override
    public void onDrag(int mouseButton, double timeSinceLastClick) {
        this.movingArea.x = this.panel.getContext().getAbsMouseX() - this.relativeClickX;
        this.movingArea.y = this.panel.getContext().getAbsMouseY() - this.relativeClickY;
    }

    @Override
    public void setMoving(boolean moving) {
        this.moving = moving;
        this.panel.setEnabled(!moving);
    }

    @Override
    public void transform(IViewportStack stack) {
        if (this.isMoving()) {
            Area area = this.panel.getArea();
            stack.translate(-area.x, -area.y);
            stack.translate(this.movingArea.x, this.movingArea.y);
        }
    }

    @Override
    @Generated
    public Area getMovingArea() {
        return this.movingArea;
    }

    @Override
    @Generated
    public boolean isMoving() {
        return this.moving;
    }
}

