/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.schema;

import brachy.modularui.schema.ISchema;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiPredicate;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public abstract class PosListSchema
implements ISchema {
    private final Level level;
    private final Iterable<? extends BlockPos> posList;
    private BiPredicate<BlockPos, BlockState> renderFilter = (pos, state) -> true;

    public PosListSchema(Level level, Iterable<? extends BlockPos> posList, BiPredicate<BlockPos, BlockState> renderFilter) {
        this.level = level;
        this.posList = posList;
        if (renderFilter != null) {
            this.renderFilter = renderFilter;
        }
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<BlockPos, BlockState>> iterator() {
        return new Iterator<Map.Entry<BlockPos, BlockState>>(){
            private final Iterator<? extends BlockPos> posIt;
            private final MutablePair<BlockPos, BlockState> pair;
            {
                this.posIt = PosListSchema.this.posList.iterator();
                this.pair = new MutablePair();
            }

            @Override
            public boolean hasNext() {
                return this.posIt.hasNext();
            }

            @Override
            public Pair<BlockPos, BlockState> next() {
                BlockPos pos = this.posIt.next();
                this.pair.setLeft((Object)pos);
                BlockState state = PosListSchema.this.level.m_8055_(pos);
                if (PosListSchema.this.renderFilter == null || PosListSchema.this.renderFilter.test(pos, state)) {
                    this.pair.setRight((Object)state);
                } else {
                    this.pair.setRight((Object)Blocks.f_50016_.m_49966_());
                }
                return this.pair;
            }
        };
    }

    @Override
    @Generated
    public Level getLevel() {
        return this.level;
    }

    @Override
    @Generated
    public BiPredicate<BlockPos, BlockState> getRenderFilter() {
        return this.renderFilter;
    }

    @Override
    @Generated
    public void setRenderFilter(BiPredicate<BlockPos, BlockState> renderFilter) {
        this.renderFilter = renderFilter;
    }
}

