/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.schema;

import brachy.modularui.ModularUI;
import brachy.modularui.schema.ISchema;
import brachy.modularui.utils.BlockPosUtil;
import brachy.modularui.utils.fakelevel.SchemaLevel;
import com.google.common.collect.AbstractIterator;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.chars.CharArraySet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ArraySchema
implements ISchema {
    private final Level level;
    private final BlockState[][][] blocks;
    private BiPredicate<BlockPos, BlockState> renderFilter = (pos, block) -> true;
    private final Vector3f center;

    public static Builder builder() {
        return new Builder();
    }

    public static ArraySchema of(Entity entity, int radius) {
        return ArraySchema.of(entity.m_9236_(), BlockPos.m_274446_((Position)entity.m_20182_()), radius);
    }

    public static ArraySchema of(Level level, BlockPos center, int radius) {
        int d = 2 * radius + 1;
        BlockState[][][] blocks = new BlockState[d][d][d];
        BlockPos corner = center.m_7918_(-radius, -radius, -radius);
        BlockPos.MutableBlockPos pos = corner.m_122032_();
        for (int x = 0; x < d; ++x) {
            for (int y = 0; y < d; ++y) {
                for (int z = 0; z < d; ++z) {
                    pos.m_122154_((Vec3i)corner, x, y, z);
                    blocks[x][y][z] = level.m_8055_((BlockPos)pos);
                }
            }
        }
        return new ArraySchema(blocks);
    }

    public static ArraySchema of(Level level, Vec3 center, Vec3 p1, Vec3 p2) {
        int x0 = (int)Math.min(p1.f_82479_, p2.f_82479_) - 1;
        int y0 = (int)Math.min(p1.f_82480_, p2.f_82480_) - 1;
        int z0 = (int)Math.min(p1.f_82481_, p2.f_82481_) - 1;
        int x1 = (int)Math.max(p1.f_82479_, p2.f_82479_);
        int y1 = (int)Math.max(p1.f_82480_, p2.f_82480_);
        int z1 = (int)Math.max(p1.f_82481_, p2.f_82481_);
        BlockState[][][] blocks = new BlockState[x1 - x0][y1 - y0][z1 - z0];
        for (BlockPos pos : BlockPos.m_121976_((int)x0, (int)y0, (int)z0, (int)x1, (int)y1, (int)z1)) {
            blocks[pos.m_123341_() - x0][pos.m_123342_() - y0][pos.m_123343_() - z0] = level.m_8055_(pos);
        }
        return new ArraySchema(blocks);
    }

    public ArraySchema(BlockState[][][] blocks) {
        this.blocks = blocks;
        this.level = new SchemaLevel();
        BlockPos.MutableBlockPos current = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos max = BlockPosUtil.MIN.m_122032_();
        for (int x = 0; x < blocks.length; ++x) {
            for (int y = 0; y < blocks[x].length; ++y) {
                for (int z = 0; z < blocks[x][y].length; ++z) {
                    BlockState block2 = blocks[x][y][z];
                    if (block2 == null || block2.m_60795_()) continue;
                    current.m_122178_(x, y, z);
                    BlockPosUtil.setMax(max, (BlockPos)current);
                    this.level.m_46597_((BlockPos)current, block2);
                }
            }
        }
        this.center = BlockPosUtil.getCenterF(BlockPos.f_121853_, (BlockPos)max.m_122184_(1, 1, 1));
    }

    @Override
    public Vector3fc getFocus() {
        return this.center;
    }

    @Override
    public BlockPos getOrigin() {
        return BlockPos.f_121853_;
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<BlockPos, BlockState>> iterator() {
        return new AbstractIterator<Map.Entry<BlockPos, BlockState>>(){
            private final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            private final MutablePair<BlockPos, BlockState> pair = new MutablePair((Object)this.pos, null);
            private int x = 0;
            private int y = 0;
            private int z = -1;

            protected Map.Entry<BlockPos, BlockState> computeNext() {
                BlockState state;
                do {
                    if (++this.z >= ArraySchema.this.blocks[this.x][this.y].length) {
                        this.z = 0;
                        if (++this.y >= ArraySchema.this.blocks[this.x].length) {
                            this.y = 0;
                            if (++this.x >= ArraySchema.this.blocks.length) {
                                return (Map.Entry)this.endOfData();
                            }
                        }
                    }
                    this.pos.m_122178_(this.x, this.y, this.z);
                } while ((state = ArraySchema.this.blocks[this.x][this.y][this.z]) == null || !ArraySchema.this.renderFilter.test((BlockPos)this.pos, state));
                this.pair.setRight((Object)state);
                return this.pair;
            }
        };
    }

    @Override
    @Generated
    public Level getLevel() {
        return this.level;
    }

    @Override
    @Generated
    public BiPredicate<BlockPos, BlockState> getRenderFilter() {
        return this.renderFilter;
    }

    @Override
    @Generated
    public void setRenderFilter(BiPredicate<BlockPos, BlockState> renderFilter) {
        this.renderFilter = renderFilter;
    }

    public static class Builder {
        private final List<String[]> tensor = new ArrayList<String[]>();
        private final Char2ObjectMap<BlockState> blockMap = new Char2ObjectOpenHashMap();

        public Builder() {
            this.blockMap.put(' ', (Object)Blocks.f_50016_.m_49966_());
            this.blockMap.put('#', (Object)Blocks.f_50016_.m_49966_());
        }

        public Builder layer(String ... layer) {
            this.tensor.add(layer);
            return this;
        }

        public Builder whereAir(char c) {
            return this.where(c, Blocks.f_50016_.m_49966_());
        }

        public Builder where(char c, BlockState state) {
            this.blockMap.put(c, (Object)state);
            return this;
        }

        public Builder where(char c, Block block) {
            return this.where(c, block.m_49966_());
        }

        public Builder where(char c, String registryName) {
            return this.where(c, new ResourceLocation(registryName));
        }

        public Builder where(char c, ResourceLocation registryName) {
            return this.where(c, (Block)BuiltInRegistries.f_256975_.m_6612_(registryName).orElseThrow(() -> new IllegalArgumentException(String.valueOf(registryName) + " isn't a valid block")));
        }

        private void validate() {
            if (this.tensor.isEmpty()) {
                throw new IllegalArgumentException("no block matrix defined");
            }
            ArrayList<String> errors = new ArrayList<String>();
            CharArraySet checkedChars = new CharArraySet();
            int layerSize = this.tensor.get(0).length;
            for (int x = 0; x < this.tensor.size(); ++x) {
                String[] xLayer = this.tensor.get(x);
                if (xLayer.length == 0) {
                    errors.add(String.format("Layer %s is empty. This is not right", x + 1));
                } else if (xLayer.length != layerSize) {
                    errors.add(String.format("Invalid x-layer size. Expected %s, but got %s at layer %s", layerSize, xLayer.length, x + 1));
                }
                int rowSize = xLayer[0].length();
                for (int y = 0; y < xLayer.length; ++y) {
                    String yRow = xLayer[y];
                    if (yRow.isEmpty()) {
                        errors.add(String.format("Row %s in layer %s is empty. This is not right", y + 1, x + 1));
                    } else if (yRow.length() != rowSize) {
                        errors.add(String.format("Invalid x-layer size. Expected %s, but got %s at row %s in layer %s", layerSize, xLayer.length, y + 1, x + 1));
                    }
                    for (int z = 0; z < yRow.length(); ++z) {
                        char zChar = yRow.charAt(z);
                        if (checkedChars.contains(zChar)) continue;
                        if (!this.blockMap.containsKey(zChar)) {
                            errors.add(String.format("Found char '%s' at char %s in row %s in layer %s, but character was not found in map!", Character.valueOf(zChar), z + 1, y + 1, x + 1));
                        }
                        checkedChars.add(zChar);
                    }
                }
            }
            if (!errors.isEmpty()) {
                ModularUI.LOGGER.error("Error validating ArrayScheme BlockArray:");
                for (String e : errors) {
                    ModularUI.LOGGER.error("  - {}", (Object)e);
                }
                throw new IllegalArgumentException("The ArraySchema builder was misconfigured. See message above.");
            }
        }

        public ArraySchema build() {
            this.validate();
            BlockState[][][] blocks = new BlockState[this.tensor.size()][this.tensor.get(0).length][this.tensor.get(0)[0].length()];
            for (int x = 0; x < this.tensor.size(); ++x) {
                String[] xLayer = this.tensor.get(x);
                for (int y = 0; y < xLayer.length; ++y) {
                    String yRow = xLayer[y];
                    for (int z = 0; z < yRow.length(); ++z) {
                        char zChar = yRow.charAt(z);
                        BlockState state = (BlockState)this.blockMap.get(zChar);
                        if (state == null || state.m_60795_()) continue;
                        blocks[x][y][z] = state;
                    }
                }
            }
            return new ArraySchema(blocks);
        }
    }
}

