/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.network.packets;

import brachy.modularui.api.UIFactory;
import brachy.modularui.factory.GuiData;
import brachy.modularui.factory.GuiManager;
import brachy.modularui.network.NetworkHandler;
import brachy.modularui.utils.NetworkUtils;
import io.netty.buffer.ByteBuf;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class OpenGuiPacket<T extends GuiData>
implements NetworkHandler.INetPacket {
    private int windowId;
    private int networkId;
    private UIFactory<T> factory;
    private FriendlyByteBuf data;

    public OpenGuiPacket(FriendlyByteBuf buf) {
        this.windowId = buf.m_130242_();
        this.networkId = buf.m_130242_();
        this.factory = GuiManager.getFactory(buf.m_130281_());
        this.data = NetworkUtils.readFriendlyByteBuf(buf);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(this.windowId);
        buf.m_130130_(this.networkId);
        buf.m_130085_(this.factory.getFactoryName());
        NetworkUtils.writeByteBuf(buf, (ByteBuf)this.data);
    }

    @Override
    public void execute(NetworkEvent.Context handler) {
        if (handler.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            GuiManager.openFromClient(this.windowId, this.networkId, this.factory, this.data, Minecraft.m_91087_().f_91074_);
        } else if (handler.getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            T guiData = this.factory.readGuiData((Player)handler.getSender(), this.data);
            GuiManager.open(this.factory, guiData, handler.getSender());
        }
    }

    @Generated
    public OpenGuiPacket() {
    }

    @Generated
    public OpenGuiPacket(int windowId, int networkId, UIFactory<T> factory, FriendlyByteBuf data) {
        this.windowId = windowId;
        this.networkId = networkId;
        this.factory = factory;
        this.data = data;
    }
}

