/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.network;

import brachy.modularui.ModularUI;
import brachy.modularui.network.packets.CloseAllGuiPacket;
import brachy.modularui.network.packets.CloseGuiPacket;
import brachy.modularui.network.packets.OpenGuiPacket;
import brachy.modularui.network.packets.ReopenGuiPacket;
import brachy.modularui.network.packets.SyncHandlerPacket;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkHandler {
    private static final String PROTOCOL_VERSION = "1.0.0";
    private static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)ModularUI.id("network"), () -> "1.0.0", "1.0.0"::equals, "1.0.0"::equals);
    private static int nextPacketId = 0;

    private static void protectedSend(PacketDistributor.PacketTarget target, INetPacket packet) {
        try {
            INSTANCE.send(target, (Object)packet);
        }
        catch (Exception e) {
            ModularUI.LOGGER.warn("Failed to send packet: {}", (Object)e.getLocalizedMessage());
        }
    }

    public static void sendToServer(INetPacket packet) {
        try {
            INSTANCE.sendToServer((Object)packet);
        }
        catch (Exception e) {
            ModularUI.LOGGER.warn("Failed to send packet: {}", (Object)e.getLocalizedMessage());
        }
    }

    public static void sendToPlayersInLevel(ResourceKey<Level> level, INetPacket packet) {
        NetworkHandler.protectedSend(PacketDistributor.DIMENSION.with(() -> level), packet);
    }

    public static void sendToPlayersNearPoint(PacketDistributor.TargetPoint point, INetPacket packet) {
        NetworkHandler.protectedSend(PacketDistributor.NEAR.with(() -> point), packet);
    }

    public static void sendToAllPlayersTrackingEntity(Entity entity, boolean includeSelf, INetPacket packet) {
        NetworkHandler.protectedSend(includeSelf ? PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity) : PacketDistributor.TRACKING_ENTITY.with(() -> entity), packet);
    }

    public static void sendToAllPlayersTrackingChunk(LevelChunk chunk, INetPacket packet) {
        NetworkHandler.protectedSend(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), packet);
    }

    public static void sendToAll(INetPacket packet) {
        NetworkHandler.protectedSend(PacketDistributor.ALL.noArg(), packet);
    }

    public static void sendToPlayer(ServerPlayer player, INetPacket packet) {
        NetworkHandler.protectedSend(PacketDistributor.PLAYER.with(() -> player), packet);
    }

    public static void reply(NetworkEvent.Context context, INetPacket packet) {
        INSTANCE.reply((Object)packet, context);
    }

    public static <T extends INetPacket> void register(Class<T> cls, Function<FriendlyByteBuf, T> decode, NetworkDirection direction) {
        INSTANCE.registerMessage(nextPacketId++, cls, INetPacket::encode, decode, (msg, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> NetworkHandler.lambda$register$7(msg, (Supplier)ctx));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        }, Optional.ofNullable(direction));
    }

    public static void init() {
        NetworkHandler.register(OpenGuiPacket.class, OpenGuiPacket::new, null);
        NetworkHandler.register(SyncHandlerPacket.class, SyncHandlerPacket::new, null);
        NetworkHandler.register(CloseAllGuiPacket.class, CloseAllGuiPacket::new, null);
        NetworkHandler.register(CloseGuiPacket.class, CloseGuiPacket::new, null);
        NetworkHandler.register(ReopenGuiPacket.class, ReopenGuiPacket::new, null);
    }

    private static /* synthetic */ void lambda$register$7(INetPacket msg, Supplier ctx) {
        msg.execute((NetworkEvent.Context)ctx.get());
    }

    public static interface INetPacket {
        public void encode(FriendlyByteBuf var1);

        public void execute(NetworkEvent.Context var1);
    }
}

