/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.integration.rei.recipe;

import brachy.modularui.api.drawable.IRichTextBuilder;
import brachy.modularui.api.widget.ITooltip;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.client.component.FormattedTextContents;
import brachy.modularui.drawable.text.RichText;
import brachy.modularui.integration.recipeviewer.RecipeSlotRole;
import brachy.modularui.integration.recipeviewer.RecipeViewerScreenWrapper;
import brachy.modularui.integration.recipeviewer.handlers.IngredientProvider;
import brachy.modularui.integration.recipeviewer.handlers.fluid.EmptyFluidTank;
import brachy.modularui.integration.recipeviewer.util.RecipeScreenRenderingUtil;
import brachy.modularui.integration.rei.REIStackConverter;
import brachy.modularui.screen.ModularPanel;
import brachy.modularui.screen.ModularScreen;
import brachy.modularui.utils.WidgetUtil;
import brachy.modularui.utils.memoization.MemoizedSupplier;
import brachy.modularui.utils.memoization.Memoizer;
import brachy.modularui.widget.sizer.Area;
import brachy.modularui.widgets.slot.FluidSlot;
import brachy.modularui.widgets.slot.ItemSlot;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import org.jetbrains.annotations.Nullable;

public class ModularUIREIDisplay<T extends Recipe<?>, W extends IWidget>
implements Display {
    protected final T recipe;
    protected final MemoizedSupplier<ModularScreen> screen;
    protected final List<EntryIngredient> inputEntries;
    protected final List<EntryIngredient> outputEntries;
    protected final List<EntryIngredient> catalysts;
    protected final CategoryIdentifier<?> categoryIdentifier;

    public ModularUIREIDisplay(T recipe, Supplier<W> widgetSupplier, CategoryIdentifier<?> category) {
        this.recipe = recipe;
        this.inputEntries = new ArrayList<EntryIngredient>();
        this.outputEntries = new ArrayList<EntryIngredient>();
        this.catalysts = new ArrayList<EntryIngredient>();
        this.categoryIdentifier = category;
        this.screen = Memoizer.memoize(() -> {
            IWidget widget = (IWidget)widgetSupplier.get();
            ModularPanel panel = ModularPanel.defaultPanel(recipe.m_6423_().toString(), widget.getArea().w(), widget.getArea().h());
            panel.child(widget);
            return new ModularScreen(recipe.m_6423_().m_135827_(), panel);
        }, Duration.ofSeconds(10L));
        for (IWidget widget : WidgetUtil.getFlatWidgetCollection((IWidget)widgetSupplier.get())) {
            REIStackConverter.Converter converter;
            IngredientProvider provider;
            RecipeSlotRole role;
            if (!(widget instanceof IngredientProvider) || (role = (provider = (IngredientProvider)widget).recipeRole()) == RecipeSlotRole.RENDER_ONLY || (converter = REIStackConverter.getForNullable(provider.ingredientClass())) == null) continue;
            EntryIngredient ingredient = converter.convertTo(provider);
            switch (role) {
                case INPUT: {
                    this.inputEntries.add(ingredient);
                    break;
                }
                case OUTPUT: {
                    this.outputEntries.add(ingredient);
                    break;
                }
                case CATALYST: {
                    this.catalysts.add(ingredient);
                }
            }
        }
    }

    public Optional<ResourceLocation> getDisplayLocation() {
        return Optional.of(this.recipe.m_6423_());
    }

    public List<Widget> createWidgets(Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add(new UIWrapperWidget());
        for (IWidget widget : WidgetUtil.getFlatWidgetCollection(this.screen.get())) {
            IRichTextBuilder<?> iRichTextBuilder;
            ITooltip tooltip;
            REIStackConverter.Converter converter;
            IngredientProvider provider;
            RecipeSlotRole role;
            if (!(widget instanceof IngredientProvider) || (role = (provider = (IngredientProvider)widget).recipeRole()) == RecipeSlotRole.RENDER_ONLY || (converter = REIStackConverter.getForNullable(provider.ingredientClass())) == null) continue;
            EntryIngredient ingredient = converter.convertTo(provider);
            Area area = widget.getArea();
            EntryWidget entryWidget = new EntryWidget(new Rectangle(area.x(), area.y(), area.w(), area.h()));
            if (provider instanceof ItemSlot) {
                ItemSlot itemSlot = (ItemSlot)provider;
                itemSlot.slot(RecipeScreenRenderingUtil.EMPTY_ITEM_HANDLER, 0).invisible();
            } else if (provider instanceof FluidSlot) {
                FluidSlot fluidSlot = (FluidSlot)provider;
                fluidSlot.syncHandler(EmptyFluidTank.INSTANCE).invisible();
            }
            entryWidget.background(false).entries((Collection)ingredient.castAsList());
            if (role == RecipeSlotRole.INPUT) {
                entryWidget.markIsInput();
            } else if (role == RecipeSlotRole.OUTPUT) {
                entryWidget.markIsOutput();
            } else {
                entryWidget.unmarkInputOrOutput();
            }
            if (widget instanceof ITooltip && (tooltip = (ITooltip)((Object)widget)).hasTooltip() && (iRichTextBuilder = tooltip.tooltip().getRichText()) instanceof RichText) {
                RichText richText = (RichText)iRichTextBuilder;
                List<FormattedText> textList = richText.getAsText();
                entryWidget.tooltipProcessor(text -> {
                    for (FormattedText line : textList) {
                        text = text.add((Component)MutableComponent.m_237204_((ComponentContents)new FormattedTextContents(line)));
                    }
                    return text;
                });
            }
            widgets.add((Widget)entryWidget);
        }
        widgets.add(new UIForegroundRenderWidget());
        return widgets;
    }

    public List<EntryIngredient> getRequiredEntries() {
        ArrayList<EntryIngredient> required = new ArrayList<EntryIngredient>(this.catalysts);
        required.addAll(this.inputEntries);
        return required;
    }

    @Generated
    public T getRecipe() {
        return this.recipe;
    }

    @Generated
    public List<EntryIngredient> getInputEntries() {
        return this.inputEntries;
    }

    @Generated
    public List<EntryIngredient> getOutputEntries() {
        return this.outputEntries;
    }

    @Generated
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return this.categoryIdentifier;
    }

    public class UIWrapperWidget
    extends Widget {
        public UIWrapperWidget() {
            ModularScreen screen = ModularUIREIDisplay.this.screen.get();
            screen.construct(new RecipeViewerScreenWrapper(screen));
        }

        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            ModularScreen screen = ModularUIREIDisplay.this.screen.get();
            RecipeScreenRenderingUtil.drawScreenBackground(guiGraphics, screen, mouseX, mouseY, partialTick);
        }

        @Nullable
        public Tooltip getTooltip(TooltipContext context) {
            return null;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }

        public void m_94757_(double mouseX, double mouseY) {
            ModularUIREIDisplay.this.screen.get().m_94757_(mouseX, mouseY);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            return ModularUIREIDisplay.this.screen.get().m_6375_(mouseX, mouseY, button);
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            return ModularUIREIDisplay.this.screen.get().m_6348_(mouseX, mouseY, button);
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
            return ModularUIREIDisplay.this.screen.get().m_7979_(mouseX, mouseY, button, dragX, dragY);
        }

        public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
            return ModularUIREIDisplay.this.screen.get().m_6050_(mouseX, mouseY, scrollDelta);
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            return ModularUIREIDisplay.this.screen.get().m_7933_(keyCode, scanCode, modifiers);
        }

        public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
            return ModularUIREIDisplay.this.screen.get().m_7920_(keyCode, scanCode, modifiers);
        }

        public boolean m_5534_(char codePoint, int modifiers) {
            return ModularUIREIDisplay.this.screen.get().m_5534_(codePoint, modifiers);
        }
    }

    public class UIForegroundRenderWidget
    extends Widget {
        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            ModularScreen screen = ModularUIREIDisplay.this.screen.get();
            RecipeScreenRenderingUtil.drawScreenForeground(guiGraphics, screen, mouseX, mouseY, partialTick);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }
    }
}

