/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.integration.rei.handler;

import brachy.modularui.api.IMuiScreen;
import brachy.modularui.integration.recipeviewer.handlers.GhostIngredientSlot;
import brachy.modularui.integration.rei.REIStackConverter;
import brachy.modularui.integration.rei.handler.REIScreenHandler;
import java.util.List;
import java.util.stream.Stream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.common.entry.EntryStack;
import net.minecraft.client.gui.screens.Screen;

public class MUIDraggableStackVisitor<T extends Screen>
implements DraggableStackVisitor<T> {
    private final Class<T> clazz;

    public MUIDraggableStackVisitor(Class<T> clazz) {
        this.clazz = clazz;
    }

    public <R extends Screen> boolean isHandingScreen(R screen) {
        return this.clazz.isAssignableFrom(screen.getClass());
    }

    public Stream<DraggableStackVisitor.BoundsProvider> getDraggableAcceptingBounds(DraggingContext<T> context, DraggableStack stack) {
        REIScreenHandler.currentIngredient = stack;
        return ((IMuiScreen)context.getScreen()).screen().getContext().getRecipeViewerSettings().getGhostIngredientSlots().stream().map(target -> DraggableStackVisitor.BoundsProvider.ofRectangle((Rectangle)REIScreenHandler.asREIRect(target.getArea())));
    }

    public DraggedAcceptorResult acceptDraggedStack(DraggingContext<T> context, DraggableStack stack) {
        List<GhostIngredientSlot<?>> ghostSlots = ((IMuiScreen)context.getScreen()).screen().getContext().getRecipeViewerSettings().getGhostIngredientSlots();
        for (GhostIngredientSlot<?> slot : ghostSlots) {
            Object converted;
            if (!slot.isEnabled()) continue;
            EntryStack entryStack = stack.getStack();
            if (slot.ingredientHandlingOverride(entryStack)) {
                REIScreenHandler.currentIngredient = null;
                return DraggedAcceptorResult.ACCEPTED;
            }
            REIStackConverter.Converter<?> converter = REIStackConverter.getForNullable(slot.ingredientClass());
            if (converter == null || (converted = converter.convertFrom(entryStack)) == null) continue;
            slot.setGhostIngredient(converted);
            REIScreenHandler.currentIngredient = null;
            return DraggedAcceptorResult.ACCEPTED;
        }
        REIScreenHandler.currentIngredient = null;
        return DraggedAcceptorResult.PASS;
    }
}

