/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.integration.rei;

import brachy.modularui.integration.recipeviewer.entry.EntryList;
import brachy.modularui.integration.recipeviewer.entry.fluid.FluidStackList;
import brachy.modularui.integration.recipeviewer.entry.fluid.FluidTagList;
import brachy.modularui.integration.recipeviewer.entry.item.ItemStackList;
import brachy.modularui.integration.recipeviewer.entry.item.ItemTagList;
import brachy.modularui.integration.recipeviewer.handlers.IngredientProvider;
import brachy.modularui.utils.MathUtil;
import dev.architectury.fluid.FluidStack;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class REIStackConverter {
    public static final Map<Class<?>, Converter<?>> CONVERTERS = new Reference2ReferenceOpenHashMap();
    public static final Converter<ItemStack> ITEM = REIStackConverter.register(ItemStack.class, new Converter<ItemStack>(){

        @Override
        @Nullable
        public ItemStack convertFrom(EntryStack<?> stack) {
            EntryType type = stack.getType();
            if (type != VanillaEntryTypes.ITEM) {
                return null;
            }
            return (ItemStack)stack.castValue();
        }

        private static EntryIngredient toREIIngredient(Stream<ItemStack> stream) {
            return EntryIngredient.of(stream.map(EntryStacks::of).toList());
        }

        @Override
        public EntryIngredient convertTo(EntryList<ItemStack> stack, float chance, UnaryOperator<ItemStack> mapper) {
            if (stack.isEmpty()) {
                return EntryIngredient.empty();
            }
            if (stack instanceof ItemStackList) {
                ItemStackList stackList = (ItemStackList)stack;
                return 1.toREIIngredient(stackList.stream().map(mapper));
            }
            if (stack instanceof ItemTagList) {
                ItemTagList entryList = (ItemTagList)stack;
                return EntryIngredient.of((Iterable)entryList.getEntries().stream().map(ItemTagList.ItemTagEntry::stacks).flatMap(stream -> 1.toREIIngredient(stream.map(mapper)).stream()).collect(Collectors.toList()));
            }
            return EntryIngredient.empty();
        }
    });
    public static final Converter<net.minecraftforge.fluids.FluidStack> FLUID = REIStackConverter.register(net.minecraftforge.fluids.FluidStack.class, new Converter<net.minecraftforge.fluids.FluidStack>(){

        @Override
        @Nullable
        public net.minecraftforge.fluids.FluidStack convertFrom(EntryStack<?> stack) {
            EntryType type = stack.getType();
            if (type != VanillaEntryTypes.FLUID) {
                return null;
            }
            FluidStack fluidStack = (FluidStack)stack.castValue();
            return new net.minecraftforge.fluids.FluidStack(fluidStack.getFluid(), MathUtil.saturatedCast(fluidStack.getAmount()), fluidStack.getTag());
        }

        private static FluidStack toREIStack(net.minecraftforge.fluids.FluidStack stack) {
            return FluidStack.create((Fluid)stack.getFluid(), (long)stack.getAmount(), (CompoundTag)stack.getTag());
        }

        private static EntryIngredient toREIIngredient(Stream<net.minecraftforge.fluids.FluidStack> stream) {
            return EntryIngredient.of(stream.map(stack -> 2.toREIStack(stack)).map(EntryStacks::of).toList());
        }

        @Override
        public EntryIngredient convertTo(EntryList<net.minecraftforge.fluids.FluidStack> stack, float chance, UnaryOperator<net.minecraftforge.fluids.FluidStack> mapper) {
            if (stack.isEmpty()) {
                return EntryIngredient.empty();
            }
            if (stack instanceof FluidStackList) {
                FluidStackList stackList = (FluidStackList)stack;
                return 2.toREIIngredient(stackList.stream().map(mapper));
            }
            if (stack instanceof FluidTagList) {
                FluidTagList tagList = (FluidTagList)stack;
                return EntryIngredient.of((Iterable)tagList.getEntries().stream().map(FluidTagList.FluidTagEntry::stacks).flatMap(val -> 2.toREIIngredient(val.map(mapper)).stream()).collect(Collectors.toList()));
            }
            return EntryIngredient.empty();
        }
    });

    public static <T> Converter<T> register(Class<T> clazz, Converter<T> converter) {
        CONVERTERS.put(clazz, converter);
        return converter;
    }

    @Nullable
    public static <T> Converter<T> getForNullable(Class<T> clazz) {
        return CONVERTERS.get(clazz);
    }

    public static <T> Optional<Converter<T>> getFor(Class<T> clazz) {
        return Optional.ofNullable(REIStackConverter.getForNullable(clazz));
    }

    public static interface Converter<T> {
        @Nullable
        public T convertFrom(EntryStack<?> var1);

        public EntryIngredient convertTo(EntryList<T> var1, float var2, UnaryOperator<T> var3);

        default public EntryIngredient convertTo(IngredientProvider<T> slot) {
            return this.convertTo(slot.getIngredients(), slot.chance(), slot.renderMappingFunction());
        }
    }
}

