/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.integration.recipeviewer.handlers.fluid;

import brachy.modularui.integration.recipeviewer.entry.fluid.FluidEntryList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CycleFluidEntryHandler
implements IFluidHandler {
    private final List<FluidEntryList> entries;
    private List<List<FluidStack>> unwrapped = null;

    public CycleFluidEntryHandler(List<FluidEntryList> entries) {
        this.entries = new ArrayList<FluidEntryList>(entries);
    }

    public List<List<FluidStack>> getUnwrapped() {
        if (this.unwrapped == null) {
            this.unwrapped = this.entries.stream().map(CycleFluidEntryHandler::getStacksNullable).collect(Collectors.toCollection(ArrayList::new));
        }
        return this.unwrapped;
    }

    @Nullable
    private static List<FluidStack> getStacksNullable(@Nullable FluidEntryList list) {
        if (list == null) {
            return null;
        }
        return list.getStacks();
    }

    public FluidEntryList getEntry(int index) {
        return this.entries.get(index);
    }

    public int getTanks() {
        return this.entries.size();
    }

    public FluidStack getFluidInTank(int tank) {
        List<FluidStack> stackList = this.getUnwrapped().get(tank);
        return stackList == null || stackList.isEmpty() ? FluidStack.EMPTY : stackList.get(Math.abs((int)(System.currentTimeMillis() / 1000L) % stackList.size()));
    }

    public int getTankCapacity(int tank) {
        return this.getFluidInTank(tank).getAmount();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    @Generated
    public List<FluidEntryList> getEntries() {
        return this.entries;
    }
}

