/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.integration.recipeviewer.handlers;

import brachy.modularui.ModularUI;
import brachy.modularui.integration.emi.handler.EmiScreenHandler;
import brachy.modularui.integration.jei.handler.JeiScreenHandler;
import brachy.modularui.integration.recipeviewer.handlers.GhostIngredientSlot;
import brachy.modularui.integration.rei.handler.REIScreenHandler;
import brachy.modularui.screen.ScreenWrapper;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RecipeViewerHandler {
    private static RecipeViewerHandler current = null;
    private static final RecipeViewerHandler DUMMY = new RecipeViewerHandler(){

        @Override
        public void setSearchFocused(boolean focused) {
        }

        @Override
        @Nullable
        public Object getCurrentlyDragged() {
            return null;
        }
    };

    @NotNull
    public static RecipeViewerHandler getCurrent() {
        if (current == null) {
            Supplier<Function> supplier = ModularUI.Mods.EMI.isLoaded() ? () -> EmiScreenHandler::of : (ModularUI.Mods.REI.isLoaded() ? () -> REIScreenHandler::of : (ModularUI.Mods.JEI.isLoaded() ? () -> JeiScreenHandler::of : () -> cls -> DUMMY));
            current = (RecipeViewerHandler)supplier.get().apply(ScreenWrapper.class);
        }
        return current;
    }

    public abstract void setSearchFocused(boolean var1);

    @Nullable
    public abstract Object getCurrentlyDragged();

    public boolean isHoveringOver(GhostIngredientSlot<?> slot) {
        Object currentlyDragged = this.getCurrentlyDragged();
        if (currentlyDragged == null) {
            return false;
        }
        if (currentlyDragged instanceof Iterable) {
            Iterable iterable = (Iterable)currentlyDragged;
            for (Object dragged : iterable) {
                if (slot.castGhostIngredientIfValid(dragged) == null) continue;
                return true;
            }
            return false;
        }
        return slot.castGhostIngredientIfValid(currentlyDragged) != null;
    }
}

