/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.integration.recipeviewer.handlers;

import java.util.List;
import lombok.Generated;
import net.minecraft.network.chat.Component;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class RecipeTransferError {
    public abstract boolean allowsTransfer();

    public int getButtonHighlightColor() {
        return -2130729728;
    }

    public List<Component> getTooltip() {
        return List.of();
    }

    public int getMissingCountHint() {
        return -1;
    }

    public static class Cosmetic
    extends RecipeTransferError {
        @Override
        public boolean allowsTransfer() {
            return true;
        }
    }

    public static class UserFacing
    extends RecipeTransferError {
        @Override
        public boolean allowsTransfer() {
            return false;
        }

        public static class Tooltip
        extends UserFacing {
            private final List<Component> message;

            public Tooltip(Component message) {
                this(List.of(message));
            }

            public Tooltip(List<Component> message) {
                this.message = message;
            }

            @Override
            public List<Component> getTooltip() {
                return this.message;
            }

            @Generated
            public List<Component> getMessage() {
                return this.message;
            }
        }
    }

    public static final class Internal
    extends RecipeTransferError {
        public static final Internal INSTANCE = new Internal();

        private Internal() {
        }

        @Override
        public boolean allowsTransfer() {
            return false;
        }
    }
}

