/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.integration.jei.recipe;

import brachy.modularui.api.widget.IWidget;
import brachy.modularui.integration.jei.ModularUIJeiPlugin;
import brachy.modularui.integration.recipeviewer.RecipeSlotRole;
import brachy.modularui.integration.recipeviewer.handlers.IngredientProvider;
import brachy.modularui.integration.recipeviewer.util.RecipeScreenRenderingUtil;
import brachy.modularui.screen.ModularPanel;
import brachy.modularui.screen.ModularScreen;
import brachy.modularui.utils.WidgetUtil;
import brachy.modularui.widget.sizer.Area;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.inputs.IJeiGuiEventListener;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Recipe;

public abstract class ModularUIRecipeCategory<T extends Recipe<?>, W extends IWidget>
implements IRecipeCategory<T> {
    private final LoadingCache<T, ModularScreen> modularScreenCache;

    protected ModularUIRecipeCategory(final Function<T, W> wrapperFunction, final Function<T, ResourceLocation> recipeIdGetter) {
        this.modularScreenCache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).maximumSize(10L).build(new CacheLoader<T, ModularScreen>(){

            public ModularScreen load(T recipe) {
                IWidget widget = (IWidget)wrapperFunction.apply(recipe);
                ResourceLocation recipeId = (ResourceLocation)recipeIdGetter.apply(recipe);
                ModularPanel panel = ModularPanel.defaultPanel(recipeId.toString(), widget.getArea().width, widget.getArea().height);
                panel.child(widget);
                return new ModularScreen(recipeId.m_135827_(), panel);
            }
        });
    }

    private ModularScreen getModularScreen(T recipe) {
        return (ModularScreen)this.modularScreenCache.getUnchecked(recipe);
    }

    private static <T> void addJEISlot(IRecipeLayoutBuilder builder, IngredientProvider<T> widget, RecipeIngredientRole role, int index) {
        Optional type = ModularUIJeiPlugin.getRuntime().getIngredientManager().getIngredientTypeChecked(widget.ingredientClass());
        if (type.isEmpty()) {
            return;
        }
        final Area widgetArea = widget.getArea();
        IRecipeSlotBuilder slotBuilder = builder.addSlot(role, widgetArea.x, widgetArea.y);
        slotBuilder.addIngredients((IIngredientType)type.get(), widget.getIngredients().getStacks());
        slotBuilder.setCustomRenderer((IIngredientType)type.get(), new IIngredientRenderer<T>(){

            public void render(GuiGraphics guiGraphics, T ingredient) {
            }

            public List<Component> getTooltip(T ingredient, TooltipFlag tooltipFlag) {
                return Collections.emptyList();
            }

            public int getWidth() {
                return widgetArea.width;
            }

            public int getHeight() {
                return widgetArea.height;
            }
        });
        slotBuilder.setSlotName("slot_" + index);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        ModularScreen screen = this.getModularScreen(recipe);
        int i = 0;
        for (IWidget widget : WidgetUtil.getFlatWidgetCollection(screen)) {
            if (!(widget instanceof IngredientProvider)) continue;
            IngredientProvider provider = (IngredientProvider)widget;
            RecipeIngredientRole role = ModularUIRecipeCategory.mapToRole(provider.recipeRole());
            ModularUIRecipeCategory.addJEISlot(builder, provider, role, i);
            ++i;
        }
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, T recipe, IFocusGroup focuses) {
        builder.addGuiEventListener((IJeiGuiEventListener)new ModularUIGuiEventListener(this, recipe));
        builder.addWidget((IRecipeWidget)new UIForegroundRenderWidget(this, recipe));
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        ModularScreen screen = this.getModularScreen(recipe);
        RecipeScreenRenderingUtil.drawScreenBackground(guiGraphics, screen, (int)mouseX, (int)mouseY, Minecraft.m_91087_().getPartialTick());
    }

    public void getTooltip(ITooltipBuilder tooltip, T recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
    }

    public static RecipeIngredientRole mapToRole(RecipeSlotRole slotRole) {
        return switch (slotRole) {
            default -> throw new IncompatibleClassChangeError();
            case RecipeSlotRole.INPUT -> RecipeIngredientRole.INPUT;
            case RecipeSlotRole.OUTPUT -> RecipeIngredientRole.OUTPUT;
            case RecipeSlotRole.CATALYST -> RecipeIngredientRole.CATALYST;
            case RecipeSlotRole.RENDER_ONLY -> RecipeIngredientRole.RENDER_ONLY;
        };
    }

    public static class ModularUIGuiEventListener
    implements IJeiGuiEventListener {
        private final T recipe;
        final /* synthetic */ ModularUIRecipeCategory this$0;

        public ModularUIGuiEventListener(T recipe) {
            this.this$0 = this$0;
            this.recipe = recipe;
        }

        public ScreenRectangle getArea() {
            return this.this$0.getModularScreen(this.recipe).m_264198_();
        }

        public void mouseMoved(double mouseX, double mouseY) {
            this.this$0.getModularScreen(this.recipe).m_94757_(mouseX, mouseY);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            return this.this$0.getModularScreen(this.recipe).m_6375_(mouseX, mouseY, button);
        }

        public boolean mouseReleased(double mouseX, double mouseY, int button) {
            return this.this$0.getModularScreen(this.recipe).m_6348_(mouseX, mouseY, button);
        }

        public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
            return this.this$0.getModularScreen(this.recipe).m_7979_(mouseX, mouseY, button, dragX, dragY);
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double scrollDelta) {
            return this.this$0.getModularScreen(this.recipe).m_6050_(mouseX, mouseY, scrollDelta);
        }

        public boolean keyPressed(double mouseX, double mouseY, int keyCode, int scanCode, int modifiers) {
            return this.this$0.getModularScreen(this.recipe).m_7933_(keyCode, scanCode, modifiers);
        }
    }

    public static class UIForegroundRenderWidget
    implements IRecipeWidget {
        private final T recipe;
        final /* synthetic */ ModularUIRecipeCategory this$0;

        public UIForegroundRenderWidget(T recipe) {
            this.this$0 = this$0;
            this.recipe = recipe;
        }

        public ScreenPosition getPosition() {
            return new ScreenPosition(0, 0);
        }

        public void drawWidget(GuiGraphics guiGraphics, double mouseX, double mouseY) {
            ModularScreen screen = this.this$0.getModularScreen(this.recipe);
            RecipeScreenRenderingUtil.drawScreenForeground(guiGraphics, screen, (int)mouseX, (int)mouseY, Minecraft.m_91087_().getPartialTick());
        }
    }
}

