/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.integration.jei.handler;

import brachy.modularui.integration.recipeviewer.handlers.RecipeTransferError;
import brachy.modularui.integration.recipeviewer.handlers.RecipeTransferHandler;
import brachy.modularui.screen.ModularContainerMenu;
import brachy.modularui.screen.ModularScreen;
import java.util.Objects;
import java.util.Optional;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IUniversalRecipeTransferHandler;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import org.jetbrains.annotations.Nullable;

public class JeiContainerHandler<T extends ModularContainerMenu>
implements IUniversalRecipeTransferHandler<T> {
    private final Class<T> clazz;
    private final IRecipeTransferHandlerHelper handlerHelper;

    public static <T extends ModularContainerMenu> void register(Class<T> clz, IRecipeTransferRegistration registration) {
        new JeiContainerHandler<T>(clz, registration.getTransferHelper()).register(registration);
    }

    private JeiContainerHandler(Class<T> clazz, IRecipeTransferHandlerHelper handlerHelper) {
        this.clazz = clazz;
        this.handlerHelper = handlerHelper;
    }

    private void register(IRecipeTransferRegistration registration) {
        registration.addUniversalRecipeTransferHandler((IUniversalRecipeTransferHandler)this);
    }

    public Class<T> getContainerClass() {
        return this.clazz;
    }

    public Optional<MenuType<T>> getMenuType() {
        return Optional.empty();
    }

    @Nullable
    public IRecipeTransferError transferRecipe(T container, Object recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        ModularScreen screen = ((ModularContainerMenu)((Object)container)).getScreen();
        if (screen instanceof RecipeTransferHandler) {
            RecipeTransferError muiError;
            RecipeTransferHandler transferHandler = (RecipeTransferHandler)((Object)screen);
            if (Objects.equals(recipe.getClass(), transferHandler.getRecipeClass()) && (muiError = transferHandler.transferRecipeSafe(recipe, maxTransfer, !doTransfer)) != null) {
                return new CosmeticJeiTransferError(muiError);
            }
        }
        return null;
    }

    public record CosmeticJeiTransferError(RecipeTransferError muiError) implements IRecipeTransferError
    {
        public IRecipeTransferError.Type getType() {
            if (this.muiError instanceof RecipeTransferError.Internal) {
                return IRecipeTransferError.Type.INTERNAL;
            }
            if (this.muiError instanceof RecipeTransferError.UserFacing) {
                return IRecipeTransferError.Type.USER_FACING;
            }
            if (this.muiError instanceof RecipeTransferError.Cosmetic) {
                return IRecipeTransferError.Type.COSMETIC;
            }
            throw new IllegalStateException("Recipe transfer error %s is not an internal, user facing or cosmetic error".formatted(this.muiError));
        }

        public int getButtonHighlightColor() {
            return this.muiError.getButtonHighlightColor();
        }

        public void getTooltip(ITooltipBuilder tooltip) {
            if (this.muiError instanceof RecipeTransferError.UserFacing) {
                tooltip.add((FormattedText)Component.m_237115_((String)"jei.tooltip.transfer"));
                for (Component component : this.muiError.getTooltip()) {
                    tooltip.add((FormattedText)component.m_6881_().m_130940_(ChatFormatting.RED));
                }
            } else {
                tooltip.addAll(this.muiError.getTooltip());
            }
        }

        public int getMissingCountHint() {
            return this.muiError.getMissingCountHint();
        }
    }
}

