/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.integration.emi.recipe;

import brachy.modularui.api.drawable.IRichTextBuilder;
import brachy.modularui.api.widget.ITooltip;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.drawable.text.RichText;
import brachy.modularui.integration.emi.EmiStackConverter;
import brachy.modularui.integration.recipeviewer.RecipeSlotRole;
import brachy.modularui.integration.recipeviewer.RecipeViewerScreenWrapper;
import brachy.modularui.integration.recipeviewer.handlers.IngredientProvider;
import brachy.modularui.integration.recipeviewer.handlers.fluid.EmptyFluidTank;
import brachy.modularui.integration.recipeviewer.util.RecipeScreenRenderingUtil;
import brachy.modularui.screen.ModularPanel;
import brachy.modularui.screen.ModularScreen;
import brachy.modularui.utils.WidgetUtil;
import brachy.modularui.utils.memoization.MemoizedSupplier;
import brachy.modularui.utils.memoization.Memoizer;
import brachy.modularui.widget.sizer.Area;
import brachy.modularui.widgets.slot.FluidSlot;
import brachy.modularui.widgets.slot.ItemSlot;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.TankWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.crafting.Recipe;
import org.jetbrains.annotations.Nullable;

public abstract class ModularUIEmiRecipe<T extends Recipe<?>, W extends IWidget>
implements EmiRecipe {
    protected final T recipe;
    protected final MemoizedSupplier<ModularScreen> screen;
    public final List<EmiIngredient> inputs;
    public final List<EmiStack> outputs;
    public final List<EmiIngredient> catalysts;
    private final Bounds bounds;
    private final int displayWidth;
    private final int displayHeight;
    public boolean allowRecipeTree = true;

    public ModularUIEmiRecipe(T recipe, Supplier<W> widgetSupplier) {
        this.recipe = recipe;
        this.inputs = new ArrayList<EmiIngredient>();
        this.outputs = new ArrayList<EmiStack>();
        this.catalysts = new ArrayList<EmiIngredient>();
        IWidget recipeWidget = (IWidget)widgetSupplier.get();
        this.displayWidth = recipeWidget.getArea().width;
        this.displayHeight = recipeWidget.getArea().height;
        this.bounds = new Bounds(0, 0, this.displayWidth, this.displayHeight);
        this.screen = Memoizer.memoize(() -> {
            IWidget widget = (IWidget)widgetSupplier.get();
            ModularPanel panel = ModularPanel.defaultPanel(recipe.m_6423_().toString(), widget.getArea().w(), widget.getArea().h());
            panel.child(widget);
            return new ModularScreen(recipe.m_6423_().m_135827_(), panel);
        }, Duration.ofSeconds(10L));
        for (IWidget widget : WidgetUtil.getFlatWidgetCollection(recipeWidget)) {
            EmiStackConverter.Converter converter;
            IngredientProvider provider;
            RecipeSlotRole role;
            if (!(widget instanceof IngredientProvider) || (role = (provider = (IngredientProvider)widget).recipeRole()) == RecipeSlotRole.RENDER_ONLY || (converter = EmiStackConverter.getForNullable(provider.ingredientClass())) == null) continue;
            EmiIngredient ingredient = converter.convertTo(provider);
            switch (role) {
                case INPUT: {
                    this.inputs.add(ingredient);
                    break;
                }
                case OUTPUT: {
                    if (ingredient.getEmiStacks().size() > 1) {
                        this.allowRecipeTree = false;
                    }
                    this.outputs.addAll(ingredient.getEmiStacks());
                    break;
                }
                case CATALYST: {
                    this.catalysts.add(ingredient);
                }
            }
        }
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.add((Widget)new UIWrapperWidget());
        for (IWidget widget : WidgetUtil.getFlatWidgetCollection(this.screen.get())) {
            IRichTextBuilder<?> capacity2;
            ITooltip tooltip;
            EmiStackConverter.Converter converter;
            IngredientProvider provider;
            RecipeSlotRole role;
            if (!(widget instanceof IngredientProvider) || (role = (provider = (IngredientProvider)widget).recipeRole()) == RecipeSlotRole.RENDER_ONLY || (converter = EmiStackConverter.getForNullable(provider.ingredientClass())) == null) continue;
            EmiIngredient ingredient = converter.convertTo(provider);
            Area widgetArea = widget.getArea();
            SlotWidget slotWidget = null;
            if (provider instanceof ItemSlot) {
                ItemSlot itemSlot = (ItemSlot)provider;
                itemSlot.slot(RecipeScreenRenderingUtil.EMPTY_ITEM_HANDLER, 0).invisible();
            } else if (provider instanceof FluidSlot) {
                FluidSlot fluidSlot = (FluidSlot)provider;
                fluidSlot.syncHandler(EmptyFluidTank.INSTANCE).invisible();
                long capacity2 = Math.max(1L, ingredient.getAmount());
                slotWidget = new TankWidget(ingredient, widgetArea.x, widgetArea.y, widgetArea.width, widgetArea.height, capacity2);
            }
            if (slotWidget == null) {
                slotWidget = new SlotWidget(ingredient, widgetArea.x, widgetArea.y);
            }
            slotWidget.customBackground(null, widgetArea.x, widgetArea.y, widgetArea.width, widgetArea.height).drawBack(false);
            if (role == RecipeSlotRole.CATALYST) {
                slotWidget.catalyst(true);
            } else if (role == RecipeSlotRole.OUTPUT) {
                slotWidget.recipeContext((EmiRecipe)this);
            }
            if (widget instanceof ITooltip && (tooltip = (ITooltip)((Object)widget)).hasTooltip() && (capacity2 = tooltip.tooltip().getRichText()) instanceof RichText) {
                RichText richText = (RichText)capacity2;
                List<FormattedText> textList = richText.getAsText();
                for (FormattedText line : textList) {
                    slotWidget.appendTooltip(() -> ClientTooltipComponent.m_169948_((FormattedCharSequence)Language.m_128107_().m_5536_(line)));
                }
            }
            widgets.add((Widget)slotWidget);
        }
        widgets.add((Widget)new UIForegroundRenderWidget());
    }

    @Nullable
    public ResourceLocation getId() {
        return this.recipe.m_6423_();
    }

    public boolean supportsRecipeTree() {
        return this.allowRecipeTree && super.supportsRecipeTree();
    }

    @Generated
    public T getRecipe() {
        return this.recipe;
    }

    @Generated
    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    @Generated
    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    @Generated
    public List<EmiIngredient> getCatalysts() {
        return this.catalysts;
    }

    @Generated
    public Bounds getBounds() {
        return this.bounds;
    }

    @Generated
    public int getDisplayWidth() {
        return this.displayWidth;
    }

    @Generated
    public int getDisplayHeight() {
        return this.displayHeight;
    }

    public class UIWrapperWidget
    extends Widget {
        public UIWrapperWidget() {
            ModularScreen screen = ModularUIEmiRecipe.this.screen.get();
            screen.construct(new RecipeViewerScreenWrapper(screen));
        }

        public Bounds getBounds() {
            return ModularUIEmiRecipe.this.bounds;
        }

        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            ModularScreen screen = ModularUIEmiRecipe.this.screen.get();
            RecipeScreenRenderingUtil.drawScreenBackground(guiGraphics, screen, mouseX, mouseY, partialTick);
        }

        public boolean mouseClicked(int mouseX, int mouseY, int button) {
            return ModularUIEmiRecipe.this.screen.get().onMousePressed(mouseX, mouseY, button);
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            return ModularUIEmiRecipe.this.screen.get().m_7933_(keyCode, scanCode, modifiers);
        }
    }

    public class UIForegroundRenderWidget
    extends Widget {
        public Bounds getBounds() {
            return ModularUIEmiRecipe.this.bounds;
        }

        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            ModularScreen screen = ModularUIEmiRecipe.this.screen.get();
            RecipeScreenRenderingUtil.drawScreenForeground(guiGraphics, screen, mouseX, mouseY, partialTick);
        }
    }
}

