/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.integration.emi.handler;

import brachy.modularui.api.IMuiScreen;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.integration.emi.EmiStackConverter;
import brachy.modularui.integration.recipeviewer.handlers.GhostIngredientSlot;
import brachy.modularui.integration.recipeviewer.handlers.IngredientProvider;
import brachy.modularui.integration.recipeviewer.handlers.RecipeViewerHandler;
import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.EmiExclusionArea;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.EmiStackProvider;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.EmiStackInteraction;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.screen.EmiScreenManager;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class EmiScreenHandler<T extends Screen>
extends RecipeViewerHandler
implements EmiExclusionArea<T>,
EmiDragDropHandler<T>,
EmiStackProvider<T> {
    private static final Map<Class<?>, EmiScreenHandler<?>> CACHE = new Reference2ReferenceOpenHashMap();
    protected final Class<T> clazz;
    static EmiIngredient currentIngredient = null;

    public static <T extends Screen> EmiScreenHandler<T> of(Class<T> cls) {
        return CACHE.computeIfAbsent(cls, c -> new EmiScreenHandler(c));
    }

    private EmiScreenHandler(Class<T> clazz) {
        this.clazz = clazz;
    }

    public void register(EmiRegistry registry) {
        registry.addExclusionArea(this.clazz, (EmiExclusionArea)this);
    }

    public static <T extends Screen> void register(Class<T> clazz, EmiRegistry registry) {
        EmiScreenHandler.of(clazz).register(registry);
    }

    public boolean dropStack(T screen, EmiIngredient stack, int x, int y) {
        List<GhostIngredientSlot<?>> ghostSlots = ((IMuiScreen)screen).screen().getContext().getRecipeViewerSettings().getGhostIngredientSlots();
        List stacks = stack.getEmiStacks();
        if (stacks.isEmpty()) {
            return false;
        }
        for (EmiStack emiStack : stacks) {
            for (GhostIngredientSlot<?> slot : ghostSlots) {
                Object converted;
                if (!slot.isEnabled() || !slot.getArea().contains(x, y)) continue;
                if (slot.ingredientHandlingOverride(emiStack)) {
                    return true;
                }
                EmiStackConverter.Converter<?> converter = EmiStackConverter.getForNullable(slot.ingredientClass());
                if (converter == null || (converted = converter.convertFrom(emiStack)) == null) continue;
                slot.setGhostIngredient(converted);
                return true;
            }
        }
        return false;
    }

    public void addExclusionArea(T screen, Consumer<Bounds> consumer) {
        ((IMuiScreen)screen).screen().getContext().getRecipeViewerSettings().getAllExclusionAreas().stream().map(rect -> new Bounds(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight())).forEach(consumer);
    }

    public EmiStackInteraction getStackAt(T screen, int x, int y) {
        IWidget hovered = ((IMuiScreen)screen).screen().getContext().getTopHovered();
        if (hovered instanceof IngredientProvider) {
            IngredientProvider provider = (IngredientProvider)hovered;
            Object override = provider.ingredientOverride();
            if (override != null) {
                currentIngredient = (EmiIngredient)override;
                return new EmiStackInteraction(currentIngredient);
            }
            EmiStackConverter.Converter converter = EmiStackConverter.getForNullable(provider.ingredientClass());
            if (converter == null) {
                return EmiStackInteraction.EMPTY;
            }
            EmiIngredient converted = converter.convertTo(provider);
            return new EmiStackInteraction(converted, null, false);
        }
        return EmiStackInteraction.EMPTY;
    }

    @Override
    public void setSearchFocused(boolean focused) {
        EmiScreenManager.search.m_93692_(focused);
    }

    @Override
    @Nullable
    public Object getCurrentlyDragged() {
        if (currentIngredient == null || currentIngredient.isEmpty()) {
            return null;
        }
        ArrayList<Object> dragged = new ArrayList<Object>();
        for (EmiStack stack : currentIngredient.getEmiStacks()) {
            if (stack.isEmpty()) continue;
            if (stack.getKeyOfType(Item.class) != null) {
                dragged.add(EmiStackConverter.ITEM.convertFrom(stack));
            }
            if (stack.getKeyOfType(Fluid.class) == null) continue;
            dragged.add(EmiStackConverter.FLUID.convertFrom(stack));
        }
        return dragged;
    }
}

