/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.integration.emi;

import brachy.modularui.integration.recipeviewer.entry.EntryList;
import brachy.modularui.integration.recipeviewer.entry.fluid.FluidStackList;
import brachy.modularui.integration.recipeviewer.entry.fluid.FluidTagList;
import brachy.modularui.integration.recipeviewer.entry.item.ItemStackList;
import brachy.modularui.integration.recipeviewer.entry.item.ItemTagList;
import brachy.modularui.integration.recipeviewer.handlers.IngredientProvider;
import brachy.modularui.utils.MathUtil;
import dev.emi.emi.api.forge.ForgeEmiStack;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class EmiStackConverter {
    public static final Map<Class<?>, Converter<?>> CONVERTERS = new Reference2ReferenceOpenHashMap();
    public static final Converter<ItemStack> ITEM = EmiStackConverter.register(ItemStack.class, new Converter<ItemStack>(){

        @Override
        @Nullable
        public ItemStack convertFrom(EmiStack stack) {
            Item key = (Item)stack.getKeyOfType(Item.class);
            if (key == null || key == Items.f_41852_) {
                return null;
            }
            ItemStack itemStack = new ItemStack((ItemLike)key, MathUtil.saturatedCast(stack.getAmount()));
            itemStack.m_41751_(stack.getNbt());
            return itemStack;
        }

        private static EmiIngredient toEMIIngredient(Stream<ItemStack> stream) {
            return EmiIngredient.of(stream.map(EmiStack::of).toList());
        }

        @Override
        public EmiIngredient convertTo(EntryList<ItemStack> stack, float chance, UnaryOperator<ItemStack> mapper) {
            if (stack.isEmpty()) {
                return EmiStack.EMPTY;
            }
            if (stack instanceof ItemStackList) {
                ItemStackList stackList = (ItemStackList)stack;
                return 1.toEMIIngredient(stackList.stream()).setChance(chance);
            }
            if (stack instanceof ItemTagList) {
                ItemTagList tagList = (ItemTagList)stack;
                return EmiIngredient.of(tagList.getEntries().stream().map(ItemTagList.ItemTagEntry::stacks).map(stream -> 1.toEMIIngredient(stream)).collect(Collectors.toList()), (long)tagList.getEntries().get(0).amount()).setChance(chance);
            }
            return EmiStack.EMPTY;
        }
    });
    public static final Converter<FluidStack> FLUID = EmiStackConverter.register(FluidStack.class, new Converter<FluidStack>(){

        @Override
        @Nullable
        public FluidStack convertFrom(EmiStack stack) {
            Fluid key = (Fluid)stack.getKeyOfType(Fluid.class);
            if (key == null || key == Fluids.f_76191_) {
                return null;
            }
            return new FluidStack(key, MathUtil.saturatedCast(stack.getAmount()), stack.getNbt());
        }

        private static EmiIngredient toEMIIngredient(Stream<FluidStack> stream) {
            return EmiIngredient.of(stream.map(ForgeEmiStack::of).toList());
        }

        @Override
        public EmiIngredient convertTo(EntryList<FluidStack> stack, float chance, UnaryOperator<FluidStack> mapper) {
            if (stack.isEmpty()) {
                return EmiStack.EMPTY;
            }
            if (stack instanceof FluidStackList) {
                FluidStackList stackList = (FluidStackList)stack;
                return 2.toEMIIngredient(stackList.stream().map(mapper)).setChance(chance);
            }
            if (stack instanceof FluidTagList) {
                FluidTagList tagList = (FluidTagList)stack;
                return EmiIngredient.of(tagList.getEntries().stream().map(FluidTagList.FluidTagEntry::stacks).map(stream -> 2.toEMIIngredient(stream)).collect(Collectors.toList()), (long)tagList.getEntries().get(0).amount()).setChance(chance);
            }
            return EmiStack.EMPTY;
        }
    });

    public static <T> Converter<T> register(Class<T> clazz, Converter<T> converter) {
        CONVERTERS.put(clazz, converter);
        return converter;
    }

    @Nullable
    public static <T> Converter<T> getForNullable(Class<T> clazz) {
        return CONVERTERS.get(clazz);
    }

    public static <T> Optional<Converter<T>> getFor(Class<T> clazz) {
        return Optional.ofNullable(EmiStackConverter.getForNullable(clazz));
    }

    public static interface Converter<T> {
        @Nullable
        public T convertFrom(EmiStack var1);

        public EmiIngredient convertTo(EntryList<T> var1, float var2, UnaryOperator<T> var3);

        default public EmiIngredient convertTo(IngredientProvider<T> slot) {
            return this.convertTo(slot.getIngredients(), slot.chance(), slot.renderMappingFunction());
        }
    }
}

