/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.factory.inventory;

import brachy.modularui.ModularUI;
import brachy.modularui.factory.inventory.InventoryType;
import brachy.modularui.factory.inventory.InventoryVisitor;
import brachy.modularui.utils.NetworkUtils;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CuriosHandler
extends InventoryType<String> {
    public static final CuriosHandler INSTANCE = new CuriosHandler();

    private CuriosHandler() {
        super("curios");
    }

    public static ICuriosItemHandler getCuriosHandler(Player player) {
        return (ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)player).orElseThrow(() -> new IllegalStateException("Curios handler for player not found"));
    }

    @Override
    public boolean isActive() {
        return ModularUI.Mods.CURIOS.isLoaded();
    }

    @Override
    public ItemStack getStackInSlot(Player player, String context, int index) {
        return CuriosHandler.getCuriosHandler(player).getStacksHandler(context).map(stacksHandler -> stacksHandler.getStacks().getStackInSlot(index)).orElse(ItemStack.f_41583_);
    }

    @Override
    public void setStackInSlot(Player player, String context, int index, ItemStack stack) {
        CuriosHandler.getCuriosHandler(player).getStacksHandler(context).ifPresent(stacksHandler -> stacksHandler.getStacks().setStackInSlot(index, stack));
    }

    @Override
    public boolean visitAll(Player player, InventoryVisitor<String> visitor) {
        Map handlers = CuriosHandler.getCuriosHandler(player).getCurios();
        for (ICurioStacksHandler handler : handlers.values()) {
            IDynamicStackHandler itemHandler = handler.getStacks();
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                if (!visitor.visit(this, handler.getIdentifier(), i, itemHandler.getStackInSlot(i))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void writeContext(FriendlyByteBuf byteBuf, String context) {
        NetworkUtils.writeStringSafe(byteBuf, context);
    }

    @Override
    public String readContext(FriendlyByteBuf byteBuf) {
        return NetworkUtils.readStringSafe(byteBuf);
    }
}

