/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.factory;

import brachy.modularui.api.IUIHolder;
import brachy.modularui.factory.BlockEntityUIFactory;
import brachy.modularui.factory.EntityUIFactory;
import brachy.modularui.factory.GuiData;
import brachy.modularui.factory.GuiManager;
import brachy.modularui.factory.PlayerInventoryUIFactory;
import brachy.modularui.factory.SidedBlockEntityUIFactory;
import brachy.modularui.factory.SimpleUIFactory;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

public class UIFactories {
    public static BlockEntityUIFactory blockEntity() {
        return BlockEntityUIFactory.INSTANCE;
    }

    public static SidedBlockEntityUIFactory sidedBlockEntity() {
        return SidedBlockEntityUIFactory.INSTANCE;
    }

    public static EntityUIFactory entity() {
        return EntityUIFactory.INSTANCE;
    }

    public static PlayerInventoryUIFactory playerInventory() {
        return PlayerInventoryUIFactory.INSTANCE;
    }

    public static SimpleUIFactory createSimple(ResourceLocation name, IUIHolder<GuiData> holder) {
        return new SimpleUIFactory(name, holder);
    }

    public static SimpleUIFactory createSimple(ResourceLocation name, Supplier<IUIHolder<GuiData>> holder) {
        return new SimpleUIFactory(name, holder);
    }

    @ApiStatus.Internal
    public static void init() {
        GuiManager.registerFactory(UIFactories.blockEntity());
        GuiManager.registerFactory(UIFactories.sidedBlockEntity());
        GuiManager.registerFactory(UIFactories.entity());
        GuiManager.registerFactory(UIFactories.playerInventory());
    }

    private UIFactories() {
    }
}

