/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.factory;

import brachy.modularui.ModularUI;
import brachy.modularui.api.IUIHolder;
import brachy.modularui.api.MCHelper;
import brachy.modularui.factory.AbstractUIFactory;
import brachy.modularui.factory.BlockEntityUIFactory;
import brachy.modularui.factory.GuiManager;
import brachy.modularui.factory.SidedPosGuiData;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class SidedBlockEntityUIFactory
extends AbstractUIFactory<SidedPosGuiData> {
    public static final SidedBlockEntityUIFactory INSTANCE = new SidedBlockEntityUIFactory();

    public <T extends BlockEntity> void open(Player player, T blockEntity, Direction facing) {
        Objects.requireNonNull(player);
        Objects.requireNonNull(facing);
        BlockEntityUIFactory.verifyBlockEntity(MCHelper.getPlayer(), blockEntity);
        BlockPos pos = blockEntity.m_58899_();
        SidedPosGuiData data = new SidedPosGuiData(player, pos, facing);
        GuiManager.open(this, data, (ServerPlayer)player);
    }

    public void open(Player player, BlockPos pos, Direction facing) {
        Objects.requireNonNull(player);
        Objects.requireNonNull(pos);
        Objects.requireNonNull(facing);
        SidedPosGuiData data = new SidedPosGuiData(player, pos, facing);
        GuiManager.open(this, data, (ServerPlayer)player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public <T extends BlockEntity> void openClient(T blockEntity, Direction facing) {
        Objects.requireNonNull(facing);
        BlockEntityUIFactory.verifyBlockEntity(MCHelper.getPlayer(), blockEntity);
        BlockPos pos = blockEntity.m_58899_();
        SidedPosGuiData data = new SidedPosGuiData(MCHelper.getPlayer(), pos, facing);
        GuiManager.openFromClient(this, data);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openClient(BlockPos pos, Direction facing) {
        Objects.requireNonNull(pos);
        Objects.requireNonNull(facing);
        SidedPosGuiData data = new SidedPosGuiData(MCHelper.getPlayer(), pos, facing);
        GuiManager.openFromClient(this, data);
    }

    private SidedBlockEntityUIFactory() {
        super(ModularUI.id("sided_block_entity"));
    }

    @Override
    @NotNull
    public IUIHolder<SidedPosGuiData> getGuiHolder(SidedPosGuiData data) {
        return Objects.requireNonNull(this.castUIHolder(data.getBlockEntity()), "Found BlockEntity is not a gui holder!");
    }

    @Override
    public boolean canInteractWith(Player player, SidedPosGuiData guiData) {
        return player == guiData.getPlayer() && guiData.getBlockEntity() != null && guiData.getSquaredDistance((Entity)player) <= 64.0;
    }

    @Override
    public void writeGuiData(SidedPosGuiData guiData, FriendlyByteBuf buffer) {
        buffer.m_130064_(guiData.getBlockPos());
        buffer.writeByte(guiData.getSide().m_122411_());
    }

    @Override
    @NotNull
    public SidedPosGuiData readGuiData(Player player, FriendlyByteBuf buffer) {
        return new SidedPosGuiData(player, buffer.m_130135_(), Direction.m_122376_((int)buffer.readByte()));
    }
}

