/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.factory;

import brachy.modularui.api.IMuiScreen;
import brachy.modularui.api.MCHelper;
import brachy.modularui.api.RecipeViewerSettings;
import brachy.modularui.api.UIFactory;
import brachy.modularui.factory.GuiData;
import brachy.modularui.network.ModularNetwork;
import brachy.modularui.network.NetworkHandler;
import brachy.modularui.network.packets.OpenGuiPacket;
import brachy.modularui.screen.ContainerScreenWrapper;
import brachy.modularui.screen.ModularContainerMenu;
import brachy.modularui.screen.ModularPanel;
import brachy.modularui.screen.ModularScreen;
import brachy.modularui.screen.ScreenWrapper;
import brachy.modularui.screen.UISettings;
import brachy.modularui.value.sync.ModularSyncManager;
import brachy.modularui.value.sync.PanelSyncManager;
import brachy.modularui.widget.WidgetTree;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="modularui", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GuiManager {
    private static final Object2ObjectMap<ResourceLocation, UIFactory<?>> FACTORIES = new Object2ObjectOpenHashMap(16);
    private static final List<Player> openedContainers = new ArrayList<Player>(4);

    public static void registerFactory(UIFactory<?> factory) {
        Objects.requireNonNull(factory);
        ResourceLocation name = Objects.requireNonNull(factory.getFactoryName());
        if (FACTORIES.containsKey((Object)name)) {
            throw new IllegalArgumentException("Factory with name '" + String.valueOf(name) + "' is already registered!");
        }
        FACTORIES.put((Object)name, factory);
    }

    @NotNull
    public static UIFactory<?> getFactory(ResourceLocation name) {
        UIFactory factory = (UIFactory)FACTORIES.get((Object)name);
        if (factory == null) {
            throw new NoSuchElementException("No UI factory for name '" + String.valueOf(name) + "' found!");
        }
        return factory;
    }

    public static boolean hasFactory(ResourceLocation name) {
        return FACTORIES.containsKey((Object)name);
    }

    public static <T extends GuiData> void open(@NotNull UIFactory<T> factory, @NotNull T guiData, ServerPlayer player) {
        if (player instanceof FakePlayer || openedContainers.contains(player)) {
            return;
        }
        openedContainers.add((Player)player);
        UISettings settings = new UISettings(RecipeViewerSettings.DUMMY);
        settings.defaultCanInteractWith(factory, guiData);
        ModularSyncManager msm = new ModularSyncManager(false);
        PanelSyncManager syncManager = new PanelSyncManager(msm, true);
        ModularPanel panel = factory.createPanel(guiData, syncManager, settings);
        WidgetTree.collectSyncValues(syncManager, panel);
        player.m_9217_();
        if (player.f_36096_ != player.f_36095_) {
            player.m_6915_();
        }
        int windowId = player.f_8940_;
        ModularContainerMenu menu = settings.hasCustomContainer() ? settings.createContainer(windowId) : factory.createContainer(windowId);
        menu.construct((Player)player, msm, settings, panel.getName(), guiData);
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        factory.writeGuiData(guiData, buffer);
        int nid = ModularNetwork.SERVER.activate(msm);
        NetworkHandler.sendToPlayer(player, new OpenGuiPacket<T>(windowId, nid, factory, buffer));
        player.m_143399_((AbstractContainerMenu)menu);
        player.f_36096_ = menu;
        msm.onOpen();
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((Player)player, (AbstractContainerMenu)menu));
    }

    @OnlyIn(value=Dist.CLIENT)
    @ApiStatus.Internal
    public static <T extends GuiData> void openFromClient(int windowId, int networkId, @NotNull UIFactory<T> factory, @NotNull FriendlyByteBuf data, @NotNull LocalPlayer player) {
        T guiData = factory.readGuiData((Player)player, data);
        UISettings settings = new UISettings();
        settings.defaultCanInteractWith(factory, guiData);
        ModularSyncManager msm = new ModularSyncManager(true);
        PanelSyncManager syncManager = new PanelSyncManager(msm, true);
        ModularPanel panel = factory.createPanel(guiData, syncManager, settings);
        WidgetTree.collectSyncValues(syncManager, panel);
        ModularScreen screen = factory.createScreen(guiData, panel);
        screen.getContext().setSettings(settings);
        ModularContainerMenu container = settings.hasCustomContainer() ? settings.createContainer(windowId) : factory.createContainer(windowId);
        container.construct((Player)player, msm, settings, panel.getName(), (GuiData)guiData);
        IMuiScreen wrapper = settings.hasCustomGui() ? settings.createGui(container, screen) : factory.createScreenWrapper(container, screen);
        Screen screen2 = wrapper.wrappedScreen();
        if (!(screen2 instanceof AbstractContainerScreen)) {
            throw new IllegalStateException("The wrapping screen must be a GuiContainer for synced GUIs!");
        }
        AbstractContainerScreen guiContainer = (AbstractContainerScreen)screen2;
        if (guiContainer.m_6262_() != container) {
            throw new IllegalStateException("Custom Containers are not yet allowed!");
        }
        ModularNetwork.CLIENT.activate(networkId, msm);
        MCHelper.setScreen(wrapper.wrappedScreen());
        player.f_36096_ = guiContainer.m_6262_();
        msm.onOpen();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <T extends GuiData> void openFromClient(@NotNull UIFactory<T> factory, @NotNull T guiData) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        factory.writeGuiData(guiData, buffer);
        NetworkHandler.sendToServer(new OpenGuiPacket<T>(0, 0, factory, buffer));
    }

    @OnlyIn(value=Dist.CLIENT)
    static void openScreen(ModularScreen screen, UISettings settings) {
        IMuiScreen guiScreen;
        if (screen.getScreenWrapper() != null && MCHelper.getCurrentScreen() == screen.getScreenWrapper().wrappedScreen()) {
            return;
        }
        screen.getContext().setSettings(settings);
        if (settings.hasCustomContainer()) {
            ModularContainerMenu container = settings.createContainer(0);
            container.constructClientOnly();
            guiScreen = new ContainerScreenWrapper(container, screen);
        } else {
            guiScreen = new ScreenWrapper(screen);
        }
        MCHelper.setScreen(guiScreen);
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            openedContainers.clear();
        }
    }
}

