/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.factory;

import brachy.modularui.ModularUI;
import brachy.modularui.api.IUIHolder;
import brachy.modularui.factory.AbstractUIFactory;
import brachy.modularui.factory.EntityGuiData;
import brachy.modularui.factory.GuiManager;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class EntityUIFactory
extends AbstractUIFactory<EntityGuiData> {
    public static final EntityUIFactory INSTANCE = new EntityUIFactory();

    protected EntityUIFactory() {
        super(ModularUI.id("entity"));
    }

    public <E extends Entity> void open(Player player, E entity) {
        Objects.requireNonNull(player);
        EntityUIFactory.verifyEntity(player, entity);
        GuiManager.open(this, new EntityGuiData(player, entity), (ServerPlayer)player);
    }

    private static <E extends Entity> void verifyEntity(Player player, E entity) {
        Objects.requireNonNull(entity);
        if (!entity.m_6084_()) {
            throw new IllegalArgumentException("Can't open dead Entity GUI!");
        }
        if (player.m_9236_() != entity.m_9236_()) {
            throw new IllegalArgumentException("Entity must be in same dimension as the player!");
        }
    }

    @Override
    @NotNull
    public IUIHolder<EntityGuiData> getGuiHolder(EntityGuiData guiData) {
        return Objects.requireNonNull(this.castUIHolder(guiData.getGuiHolder()), "Found Entity is not a gui holder!");
    }

    @Override
    public void writeGuiData(EntityGuiData guiData, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(guiData.getGuiHolder().m_19879_());
    }

    @Override
    @NotNull
    public EntityGuiData readGuiData(Player entityPlayer, FriendlyByteBuf packetBuffer) {
        return new EntityGuiData(entityPlayer, entityPlayer.m_9236_().m_6815_(packetBuffer.readInt()));
    }

    @Override
    public boolean canInteractWith(Player player, EntityGuiData guiData) {
        Entity guiHolder = guiData.getGuiHolder();
        return super.canInteractWith(player, guiData) && guiHolder != null && player.m_20275_(guiHolder.m_20185_(), guiHolder.m_20186_(), guiHolder.m_20189_()) <= 64.0 && player.m_9236_() == guiHolder.m_9236_() && guiHolder.m_6084_();
    }
}

