/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.factory;

import brachy.modularui.api.MCHelper;
import brachy.modularui.factory.GuiManager;
import brachy.modularui.screen.ModularContainerMenu;
import brachy.modularui.screen.ModularScreen;
import brachy.modularui.screen.RecipeViewerSettingsImpl;
import brachy.modularui.screen.UISettings;
import java.util.function.IntFunction;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ClientGUI {
    private ClientGUI() {
    }

    public static void open(@NotNull ModularScreen screen) {
        ClientGUI.open(screen, new UISettings());
    }

    public static void open(@NotNull ModularScreen screen, @NotNull RecipeViewerSettingsImpl jeiSettings) {
        GuiManager.openScreen(screen, new UISettings(jeiSettings));
    }

    public static void open(@NotNull ModularScreen screen, @Nullable IntFunction<ModularContainerMenu> container) {
        UISettings settings = new UISettings();
        settings.customContainer(container);
        GuiManager.openScreen(screen, settings);
    }

    public static void open(@NotNull ModularScreen screen, @NotNull RecipeViewerSettingsImpl jeiSettings, @Nullable IntFunction<ModularContainerMenu> container) {
        UISettings settings = new UISettings(jeiSettings);
        settings.customContainer(container);
        GuiManager.openScreen(screen, settings);
    }

    public static void open(@NotNull ModularScreen screen, @NotNull UISettings settings) {
        GuiManager.openScreen(screen, settings);
    }

    public static void open(Screen screen) {
        MCHelper.setScreen(screen);
    }

    public static void close() {
        MCHelper.setScreen(null);
    }
}

