/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.drawable.text;

import brachy.modularui.api.drawable.ITextLine;
import brachy.modularui.screen.viewport.GuiContext;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;

public class TextLine
implements ITextLine {
    private final Component text;
    private final int width;
    private float lastX;
    private float lastY;

    public TextLine(Component text, int width) {
        this.text = text;
        this.width = width;
    }

    @Override
    public int getHeight(Font font) {
        Objects.requireNonNull(font);
        return 9 + 1;
    }

    @Override
    public void draw(GuiContext context, Font font, float x, float y, int color, boolean shadow, int availableWidth, int availableHeight) {
        context.getGraphics().drawString(font, this.text.m_7532_(), x, y, color, shadow);
        this.lastX = x;
        this.lastY = y;
    }

    @Override
    public Object getHoveringElement(Font font, int x, int y) {
        if ((float)y < this.lastY || (float)y > this.lastY + (float)this.getHeight(font)) {
            return null;
        }
        if ((float)x < this.lastX || (float)x > this.lastX + (float)this.getWidth()) {
            return Boolean.FALSE;
        }
        return this.text;
    }

    @Override
    @Generated
    public int getWidth() {
        return this.width;
    }
}

