/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.drawable.text;

import brachy.modularui.api.drawable.IKey;
import brachy.modularui.drawable.text.AnimatedText;
import brachy.modularui.drawable.text.BaseKey;
import brachy.modularui.screen.viewport.GuiContext;
import brachy.modularui.theme.WidgetTheme;
import brachy.modularui.utils.Alignment;
import brachy.modularui.widgets.TextWidget;
import java.util.function.IntSupplier;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StyledText
extends BaseKey {
    private final IKey key;
    private Alignment alignment = Alignment.Center;
    private IntSupplier color = null;
    @Nullable
    private Boolean shadow = null;
    private float scale = 1.0f;

    public StyledText(IKey key) {
        this.key = key;
    }

    @Override
    public MutableComponent get() {
        return this.key.get();
    }

    @Override
    public MutableComponent getFormatted() {
        return this.key.getFormatted();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(GuiContext context, int x, int y, int width, int height, WidgetTheme widgetTheme) {
        renderer.setAlignment(this.alignment, width, height);
        renderer.setColor(this.color != null ? this.color.getAsInt() : widgetTheme.getTextColor());
        renderer.setScale(this.scale);
        renderer.setPos(x, y);
        renderer.setShadow(this.shadow != null ? this.shadow.booleanValue() : widgetTheme.isTextShadow());
        renderer.draw(context.getGraphics(), (Component)this.getFormatted());
    }

    @Nullable
    public Boolean isShadow() {
        return this.shadow;
    }

    @Override
    @NotNull
    public BaseKey style(ChatFormatting formatting) {
        this.key.style(formatting);
        return this;
    }

    @Override
    public TextWidget<?> asWidget() {
        return ((TextWidget)((TextWidget)((TextWidget)new TextWidget(this.key).alignment(this.alignment)).color(this.color)).scale(this.scale)).shadow(this.shadow);
    }

    @Override
    public AnimatedText withAnimation() {
        return new AnimatedText(this.key).alignment(this.alignment).color(this.color).scale(this.scale).shadow(this.shadow);
    }

    @Generated
    public Alignment alignment() {
        return this.alignment;
    }

    @Override
    @NotNull
    @Generated
    public StyledText alignment(Alignment alignment) {
        this.alignment = alignment;
        return this;
    }

    @Generated
    public IntSupplier color() {
        return this.color;
    }

    @Override
    @NotNull
    @Generated
    public StyledText color(IntSupplier color) {
        this.color = color;
        return this;
    }

    @Override
    @NotNull
    @Generated
    public StyledText shadow(@Nullable Boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    @Generated
    public float scale() {
        return this.scale;
    }

    @Override
    @NotNull
    @Generated
    public StyledText scale(float scale) {
        this.scale = scale;
        return this;
    }
}

