/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.drawable.text;

import brachy.modularui.api.MCHelper;
import brachy.modularui.api.drawable.IIcon;
import brachy.modularui.api.drawable.IKey;
import brachy.modularui.screen.viewport.GuiContext;
import brachy.modularui.theme.WidgetTheme;
import brachy.modularui.widget.sizer.Box;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.FormattedText;

public class KeyIcon
implements IIcon {
    private final IKey key;
    private Font overrideFont;
    private final Box margin = new Box();
    private boolean expandWidth;
    private boolean expandHeight;

    public KeyIcon(IKey key) {
        this.key = key;
    }

    public Font getFont() {
        return this.overrideFont != null ? this.overrideFont : MCHelper.getFont();
    }

    @Override
    public int getWidth() {
        return this.expandWidth ? 0 : this.getActualWidth();
    }

    @Override
    public int getHeight() {
        return this.expandHeight ? 0 : this.getActualHeight();
    }

    @Override
    public int getDefaultWidth() {
        return this.key.getDefaultWidth();
    }

    @Override
    public int getDefaultHeight() {
        return this.key.getDefaultHeight();
    }

    public int getActualWidth() {
        return this.getFont().m_92852_((FormattedText)this.key.get()) + this.margin.horizontal();
    }

    public int getActualHeight() {
        Objects.requireNonNull(this.getFont());
        return 9 + this.margin.vertical();
    }

    @Override
    public Box getMargin() {
        return null;
    }

    @Override
    public IKey getWrappedDrawable() {
        return this.key;
    }

    @Override
    public void draw(GuiContext context, int x, int y, int width, int height, WidgetTheme widgetTheme) {
        int w = this.getActualWidth();
        int h = this.getActualHeight();
        this.key.draw(context, x += (int)((float)width / 2.0f - (float)w / 2.0f), y += (int)((float)height / 2.0f - (float)h / 2.0f), width, height, widgetTheme);
    }

    public KeyIcon expandWidth() {
        this.expandWidth = true;
        return this;
    }

    public KeyIcon expandHeight() {
        this.expandHeight = true;
        return this;
    }

    public KeyIcon margin(int left, int right, int top, int bottom) {
        this.margin.all(left, right, top, bottom);
        return this;
    }

    public KeyIcon margin(int horizontal, int vertical) {
        this.margin.all(horizontal, vertical);
        return this;
    }

    public KeyIcon margin(int all) {
        this.margin.all(all);
        return this;
    }

    public KeyIcon marginLeft(int val) {
        this.margin.left(val);
        return this;
    }

    public KeyIcon marginRight(int val) {
        this.margin.right(val);
        return this;
    }

    public KeyIcon marginTop(int val) {
        this.margin.top(val);
        return this;
    }

    public KeyIcon marginBottom(int val) {
        this.margin.bottom(val);
        return this;
    }

    public KeyIcon font(Font fr) {
        this.overrideFont = fr;
        return this;
    }

    public String toString() {
        return "KeyIcon(" + String.valueOf(this.key.get()) + ")";
    }

    @Generated
    public IKey getKey() {
        return this.key;
    }
}

