/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.drawable.text;

import brachy.modularui.drawable.text.FontRenderHelper;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.Unit;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.Nullable;

public class FormattingState {
    @Nullable
    private Unit reset;
    @Nullable
    private TextColor color;
    @Nullable
    private Boolean underline;
    @Nullable
    private Boolean italic;
    @Nullable
    private Boolean bold;
    @Nullable
    private Boolean strikethrough;
    @Nullable
    private Boolean obfuscated;
    private boolean forceDefaultColor;

    public void reset() {
        this.reset = null;
        this.color = null;
        this.underline = null;
        this.italic = null;
        this.bold = null;
        this.strikethrough = null;
        this.obfuscated = null;
        this.forceDefaultColor = false;
    }

    public void add(ChatFormatting formatting, boolean removeAllOnReset) {
        if (formatting == ChatFormatting.RESET) {
            if (removeAllOnReset) {
                this.reset();
            }
            this.reset = Unit.INSTANCE;
            return;
        }
        if (formatting.m_126661_()) {
            switch (formatting) {
                case UNDERLINE: {
                    this.underline = true;
                    break;
                }
                case ITALIC: {
                    this.italic = true;
                    break;
                }
                case BOLD: {
                    this.bold = true;
                    break;
                }
                case STRIKETHROUGH: {
                    this.strikethrough = true;
                    break;
                }
                case OBFUSCATED: {
                    this.obfuscated = true;
                }
            }
            return;
        }
        this.color = TextColor.m_131270_((ChatFormatting)formatting);
    }

    public void forceDefaultColor() {
        this.forceDefaultColor = true;
        this.color = null;
    }

    public Style getFormatting(Style style) {
        if (this.reset != null) {
            style = Style.f_131099_;
        }
        if (this.color != null) {
            style.m_131148_(this.color);
        }
        if (this.underline != null) {
            style.m_131162_(this.underline);
        }
        if (this.italic != null) {
            style.m_131155_(this.italic);
        }
        if (this.bold != null) {
            style.m_131136_(this.bold);
        }
        if (this.strikethrough != null) {
            style.m_178522_(this.strikethrough);
        }
        if (this.obfuscated != null) {
            style.m_178524_(this.obfuscated);
        }
        return style;
    }

    public MutableComponent prependText(MutableComponent builder) {
        return this.prependText(builder, null);
    }

    public MutableComponent prependText(MutableComponent builder, @Nullable FormattingState fallback) {
        FormattingState.prependText(this, fallback, fs -> fs.reset != null ? ChatFormatting.RESET : null, builder);
        if (!this.forceDefaultColor) {
            if (this.color != null) {
                builder.m_130938_(style -> style.m_131148_(this.color));
            } else if (fallback != null && !fallback.forceDefaultColor && fallback.color != null) {
                builder.m_130938_(style -> style.m_131148_(fallback.color));
            }
        }
        this.prependText(fallback, ChatFormatting.UNDERLINE, fs -> fs.underline, builder);
        this.prependText(fallback, ChatFormatting.ITALIC, fs -> fs.italic, builder);
        this.prependText(fallback, ChatFormatting.BOLD, fs -> fs.bold, builder);
        this.prependText(fallback, ChatFormatting.STRIKETHROUGH, fs -> fs.strikethrough, builder);
        this.prependText(fallback, ChatFormatting.OBFUSCATED, fs -> fs.obfuscated, builder);
        return builder;
    }

    public MutableComponent prependText(ChatFormatting style, @Nullable FormattingState fallback) {
        return this.prependText(Component.m_237119_().m_130940_(style), fallback);
    }

    public void setFrom(FormattingState state) {
        this.reset = state.reset;
        this.color = state.color;
        this.underline = state.underline;
        this.italic = state.italic;
        this.bold = state.bold;
        this.strikethrough = state.strikethrough;
        this.obfuscated = state.obfuscated;
        this.forceDefaultColor = state.forceDefaultColor;
    }

    public void parseFrom(String text) {
        int i = -2;
        while ((i = text.indexOf(167, i + 2)) >= 0 && i < text.length() - 1) {
            ChatFormatting formatting = FontRenderHelper.getForCharacter(text.charAt(i + 1));
            if (formatting == null) continue;
            this.add(formatting, true);
        }
    }

    public FormattingState copy() {
        FormattingState state = new FormattingState();
        state.setFrom(this);
        return state;
    }

    public FormattingState merge(FormattingState state) {
        if (state.hasReset()) {
            this.setFrom(state);
            return this;
        }
        if (state.color != null) {
            this.color = state.color;
        }
        if (state.underline != null) {
            this.underline = state.underline;
        }
        if (state.italic != null) {
            this.italic = state.italic;
        }
        if (state.bold != null) {
            this.bold = state.bold;
        }
        if (state.strikethrough != null) {
            this.strikethrough = state.strikethrough;
        }
        if (state.obfuscated != null) {
            this.obfuscated = state.obfuscated;
        }
        if (state.forceDefaultColor) {
            this.forceDefaultColor();
        }
        return this;
    }

    public boolean hasReset() {
        return this.reset != null;
    }

    private void prependText(@Nullable FormattingState fallback, ChatFormatting format, Function<FormattingState, @Nullable Boolean> getter, MutableComponent builder) {
        if (getter.apply(this) == Boolean.TRUE) {
            builder.m_130940_(format);
        } else if (fallback != null && getter.apply(fallback) == Boolean.TRUE) {
            builder.m_130940_(format);
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("reset", (Object)this.reset).append("color", (Object)this.color).append("underline", (Object)this.underline).append("italic", (Object)this.italic).append("bold", (Object)this.bold).append("strikethrough", (Object)this.strikethrough).append("obfuscated", (Object)this.obfuscated).append("forceDefaultColor", this.forceDefaultColor).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormattingState that = (FormattingState)o;
        return this.forceDefaultColor == that.forceDefaultColor && this.reset == that.reset && this.color == that.color && this.underline == that.underline && this.italic == that.italic && this.bold == that.bold && this.strikethrough == that.strikethrough && this.obfuscated == that.obfuscated;
    }

    public int hashCode() {
        return Objects.hash(this.reset, this.color, this.underline, this.italic, this.bold, this.strikethrough, this.obfuscated, this.forceDefaultColor);
    }

    private static void prependText(FormattingState state, @Nullable FormattingState fallback, Function<FormattingState, ChatFormatting> getter, MutableComponent builder) {
        if (getter.apply(state) != null) {
            builder.m_130940_(getter.apply(state));
        } else if (fallback != null && getter.apply(fallback) != null) {
            builder.m_130940_(getter.apply(fallback));
        }
    }

    public static FormattingState merge(@Nullable FormattingState state1, @Nullable FormattingState state2) {
        return FormattingState.merge(state1, state2, null);
    }

    public static FormattingState merge(@Nullable FormattingState state1, @Nullable FormattingState state2, @Nullable FormattingState result) {
        if (state1 == null) {
            if (state2 == null) {
                if (result == null) {
                    result = new FormattingState();
                }
                result.reset();
                return result;
            }
            return state2;
        }
        if (state2 == null) {
            return state1;
        }
        if (result == null) {
            result = new FormattingState();
        }
        if (result != state1) {
            result.setFrom(state1);
        }
        return result.merge(state2);
    }

    public static MutableComponent appendFormat(MutableComponent builder, @Nullable FormattingState state) {
        return FormattingState.appendFormat(builder, state, null);
    }

    public static MutableComponent appendFormat(MutableComponent builder, @Nullable FormattingState state, @Nullable FormattingState fallback) {
        if (state == null) {
            return builder;
        }
        return state.prependText(builder, fallback);
    }
}

