/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.drawable.text;

import brachy.modularui.api.IThemeApi;
import brachy.modularui.api.drawable.IHoverable;
import brachy.modularui.api.drawable.IIcon;
import brachy.modularui.api.drawable.ITextLine;
import brachy.modularui.screen.viewport.GuiContext;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.client.gui.Font;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class ComposedLine
implements ITextLine {
    private final List<Object> elements;
    private final int width;
    private final int height;
    private float lastX;
    private float lastY;

    public ComposedLine(List<Object> elements, int width, int height) {
        this.elements = elements;
        this.width = width;
        this.height = height;
    }

    @Override
    public int getHeight(Font font) {
        Objects.requireNonNull(font);
        return this.height == 9 ? this.height : this.height + 1;
    }

    @Override
    public void draw(GuiContext context, Font font, float x, float y, int color, boolean shadow, int availableWidth, int availableHeight) {
        this.lastX = x;
        this.lastY = y;
        for (Object o : this.elements) {
            float drawY;
            if (o instanceof String) {
                String s = (String)o;
                float f = (float)this.getHeight(font) / 2.0f;
                Objects.requireNonNull(font);
                drawY = f - 9.0f / 2.0f;
                context.getGraphics().drawString(font, s, x, y + drawY, color, shadow);
                x += (float)font.m_92895_(s);
                continue;
            }
            if (o instanceof FormattedText) {
                FormattedCharSequence formattedCharSequence;
                FormattedText text = (FormattedText)o;
                float f = (float)this.getHeight(font) / 2.0f;
                Objects.requireNonNull(font);
                drawY = f - 9.0f / 2.0f;
                if (text instanceof Component) {
                    Component component = (Component)text;
                    formattedCharSequence = component.m_7532_();
                } else {
                    formattedCharSequence = Language.m_128107_().m_5536_(text);
                }
                FormattedCharSequence charSequence = formattedCharSequence;
                context.getGraphics().drawString(font, charSequence, x, y + drawY, color, shadow);
                x += (float)font.m_92852_(text);
                continue;
            }
            if (o instanceof FormattedCharSequence) {
                FormattedCharSequence s = (FormattedCharSequence)o;
                float f = (float)this.getHeight(font) / 2.0f;
                Objects.requireNonNull(font);
                drawY = f - 9.0f / 2.0f;
                context.getGraphics().drawString(font, s, x, y + drawY, color, shadow);
                x += (float)font.m_92724_(s);
                continue;
            }
            if (!(o instanceof IIcon)) continue;
            IIcon icon = (IIcon)o;
            drawY = (float)this.getHeight(font) / 2.0f - (float)icon.getHeight() / 2.0f;
            int w = icon.getWidth() > 0 ? icon.getWidth() : availableWidth;
            icon.draw(context, (int)x, (int)(y + drawY), w, icon.getHeight(), IThemeApi.get().getDefaultTheme().getFallback().theme());
            if (icon instanceof IHoverable) {
                IHoverable hoverable = (IHoverable)icon;
                hoverable.setRenderedAt((int)x, (int)(y + drawY));
            }
            x += (float)w;
        }
    }

    @Override
    public Object getHoveringElement(Font font, int x, int y) {
        int h0 = this.getHeight(font);
        if ((float)y < this.lastY || (float)y > this.lastY + (float)h0) {
            return null;
        }
        if ((float)x < this.lastX || (float)x > this.lastX + (float)this.getWidth()) {
            return Boolean.FALSE;
        }
        float x0 = (float)x - this.lastX;
        float x1 = 0.0f;
        float y0 = (float)y - this.lastY;
        for (Object o : this.elements) {
            float h;
            float w;
            if (o instanceof String) {
                String s = (String)o;
                w = font.m_92895_(s);
                Objects.requireNonNull(font);
                h = 9.0f;
            } else if (o instanceof Component) {
                Component c = (Component)o;
                w = font.m_92852_((FormattedText)c);
                Objects.requireNonNull(font);
                h = 9.0f;
            } else if (o instanceof FormattedCharSequence) {
                FormattedCharSequence s = (FormattedCharSequence)o;
                w = font.m_92724_(s);
                Objects.requireNonNull(font);
                h = 9.0f;
            } else {
                if (!(o instanceof IIcon)) continue;
                IIcon icon = (IIcon)o;
                w = icon.getWidth();
                h = icon.getWidth();
            }
            if (x0 > x1 && x0 < x1 + w) {
                if (h < (float)h0) {
                    int lower = (int)((float)h0 / 2.0f - h / 2.0f);
                    int upper = (int)((float)h0 / 2.0f + h / 2.0f - 1.0f);
                    if (y0 < (float)lower || y0 > (float)upper) {
                        return Boolean.FALSE;
                    }
                }
                return o;
            }
            x1 += w;
        }
        return null;
    }

    @Override
    @Generated
    public int getWidth() {
        return this.width;
    }
}

