/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.drawable;

import brachy.modularui.drawable.ColorType;
import brachy.modularui.drawable.GuiDraw;
import brachy.modularui.drawable.UITexture;
import brachy.modularui.screen.viewport.GuiContext;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;

public class TiledUITexture
extends UITexture {
    private final int imageWidth;
    private final int imageHeight;

    TiledUITexture(ResourceLocation location, float u0, float v0, float u1, float v1, int imageWidth, int imageHeight, ColorType colorType, boolean nonOpaque) {
        super(location, u0, v0, u1, v1, colorType, nonOpaque);
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
    }

    @Override
    public void draw(GuiContext context, float x, float y, float width, float height) {
        if (width == (float)this.imageWidth && height == (float)this.imageHeight) {
            super.draw(context, x, y, width, height);
            return;
        }
        RenderSystem.setShader(GameRenderer::m_172817_);
        GuiDraw.drawTiledTexture(context.getLastGraphicsPose(), this.location, x, y, width, height, this.u0, this.v0, this.u1, this.v1, this.imageWidth, this.imageHeight, 0.0f);
    }

    @Override
    public boolean saveToJson(JsonObject json) {
        super.saveToJson(json);
        if (json.entrySet().size() > 1) {
            json.addProperty("tiled", Boolean.valueOf(true));
        }
        return true;
    }

    @Override
    protected TiledUITexture copy() {
        return new TiledUITexture(this.location, this.u0, this.v0, this.u1, this.v1, this.imageWidth, this.imageHeight, this.colorType, this.nonOpaque);
    }

    @Override
    public TiledUITexture withColorOverride(int color) {
        return (TiledUITexture)super.withColorOverride(color);
    }
}

