/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.drawable;

import brachy.modularui.client.schemarenderer.BaseSchemaRenderer;
import brachy.modularui.client.schemarenderer.BlockHighlight;
import brachy.modularui.client.schemarenderer.Camera;
import brachy.modularui.schema.ISchema;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class SchemaRenderer
extends BaseSchemaRenderer {
    protected DoubleSupplier scale;
    protected BooleanSupplier disableBER;
    protected Consumer<SchemaRenderer> afterRender;
    protected BiConsumer<Camera, ISchema> cameraFunc;
    protected Supplier<BlockHighlight> highlight;
    protected boolean isometric = false;
    private boolean rayTracing = false;

    public SchemaRenderer(ISchema schema) {
        super(schema);
    }

    public SchemaRenderer scale(double scale) {
        this.scale = () -> scale;
        return this;
    }

    public SchemaRenderer disableBER(boolean disableBER) {
        this.disableBER = () -> disableBER;
        return this;
    }

    public SchemaRenderer highlightRenderer(BlockHighlight highlight) {
        this.highlight = () -> highlight;
        this.rayTracing = true;
        return this;
    }

    @Override
    protected void onSetupCamera() {
        if (this.scale != null) {
            this.camera().scaleDistanceKeepLookAt((float)this.scale.getAsDouble());
        }
        if (this.cameraFunc != null) {
            this.cameraFunc.accept(this.camera(), this.schema());
        }
    }

    @Override
    protected void onRendered() {
        if (this.afterRender != null) {
            this.afterRender.accept(this);
        }
    }

    @Override
    protected void onSuccessfulRayTrace(PoseStack poseStack, @NotNull BlockHitResult result) {
        if (this.highlight != null) {
            this.highlight.get().renderHighlight(poseStack, result, this.camera().pos());
        }
    }

    @Override
    public boolean doRayTrace() {
        return this.rayTracing;
    }

    @Override
    public boolean isBEREnabled() {
        return this.disableBER == null || !this.disableBER.getAsBoolean();
    }

    @Override
    public boolean isIsometric() {
        return this.isometric;
    }

    @NotNull
    @Generated
    public SchemaRenderer scale(DoubleSupplier scale) {
        this.scale = scale;
        return this;
    }

    @NotNull
    @Generated
    public SchemaRenderer disableBER(BooleanSupplier disableBER) {
        this.disableBER = disableBER;
        return this;
    }

    @NotNull
    @Generated
    public SchemaRenderer afterRender(Consumer<SchemaRenderer> afterRender) {
        this.afterRender = afterRender;
        return this;
    }

    @NotNull
    @Generated
    public SchemaRenderer cameraFunc(BiConsumer<Camera, ISchema> cameraFunc) {
        this.cameraFunc = cameraFunc;
        return this;
    }

    @NotNull
    @Generated
    public SchemaRenderer highlight(Supplier<BlockHighlight> highlight) {
        this.highlight = highlight;
        return this;
    }

    @NotNull
    @Generated
    public SchemaRenderer isometric(boolean isometric) {
        this.isometric = isometric;
        return this;
    }

    @NotNull
    @Generated
    public SchemaRenderer rayTracing(boolean rayTracing) {
        this.rayTracing = rayTracing;
        return this;
    }
}

