/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.drawable;

import brachy.modularui.api.drawable.IIcon;
import brachy.modularui.api.widget.IGuiAction;
import brachy.modularui.api.widget.Interactable;
import brachy.modularui.drawable.DelegateIcon;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class InteractableIcon
extends DelegateIcon
implements Interactable {
    private IGuiAction.MousePressed onMousePressed;
    private IGuiAction.MouseReleased onMouseReleased;
    private IGuiAction.MousePressed onMouseTapped;
    private IGuiAction.MouseScroll onMouseScrolled;
    private IGuiAction.KeyPressed onKeyPressed;
    private IGuiAction.KeyReleased onKeyReleased;
    private IGuiAction.KeyPressed onKeyTapped;
    public boolean playClickSound = true;

    public InteractableIcon(IIcon icon) {
        super(icon);
    }

    public void playClickSound() {
        if (this.playClickSound) {
            Interactable.playButtonClickSound();
        }
    }

    @Override
    @NotNull
    public Interactable.Result onMousePressed(double mouseX, double mouseY, int button) {
        if (this.onMousePressed != null && this.onMousePressed.press(mouseX, mouseY, button)) {
            this.playClickSound();
            return Interactable.Result.SUCCESS;
        }
        return Interactable.Result.ACCEPT;
    }

    @Override
    public boolean onMouseReleased(double mouseX, double mouseY, int button) {
        return this.onMouseReleased != null && this.onMouseReleased.release(mouseX, mouseY, button);
    }

    @Override
    @NotNull
    public Interactable.Result onMouseTapped(double mouseX, double mouseY, int button) {
        if (this.onMouseTapped != null && this.onMouseTapped.press(mouseX, mouseY, button)) {
            this.playClickSound();
            return Interactable.Result.SUCCESS;
        }
        return Interactable.Result.IGNORE;
    }

    @Override
    @NotNull
    public Interactable.Result onKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.onKeyPressed != null && this.onKeyPressed.press(keyCode, scanCode, modifiers)) {
            return Interactable.Result.SUCCESS;
        }
        return Interactable.Result.ACCEPT;
    }

    @Override
    public boolean onKeyReleased(int keyCode, int scanCode, int modifiers) {
        return this.onKeyReleased != null && this.onKeyReleased.release(keyCode, scanCode, modifiers);
    }

    @Override
    @NotNull
    public Interactable.Result onKeyTapped(int keyCode, int scanCode, int modifiers) {
        if (this.onKeyTapped != null && this.onKeyTapped.press(keyCode, scanCode, modifiers)) {
            return Interactable.Result.SUCCESS;
        }
        return Interactable.Result.IGNORE;
    }

    @Override
    public boolean onMouseScrolled(double mouseX, double mouseY, double delta) {
        return this.onMouseScrolled != null && this.onMouseScrolled.scroll(mouseX, mouseY, delta);
    }

    @NotNull
    @Generated
    public InteractableIcon onMousePressed(IGuiAction.MousePressed onMousePressed) {
        this.onMousePressed = onMousePressed;
        return this;
    }

    @NotNull
    @Generated
    public InteractableIcon onMouseReleased(IGuiAction.MouseReleased onMouseReleased) {
        this.onMouseReleased = onMouseReleased;
        return this;
    }

    @NotNull
    @Generated
    public InteractableIcon onMouseTapped(IGuiAction.MousePressed onMouseTapped) {
        this.onMouseTapped = onMouseTapped;
        return this;
    }

    @NotNull
    @Generated
    public InteractableIcon onMouseScrolled(IGuiAction.MouseScroll onMouseScrolled) {
        this.onMouseScrolled = onMouseScrolled;
        return this;
    }

    @NotNull
    @Generated
    public InteractableIcon onKeyPressed(IGuiAction.KeyPressed onKeyPressed) {
        this.onKeyPressed = onKeyPressed;
        return this;
    }

    @NotNull
    @Generated
    public InteractableIcon onKeyReleased(IGuiAction.KeyReleased onKeyReleased) {
        this.onKeyReleased = onKeyReleased;
        return this;
    }

    @NotNull
    @Generated
    public InteractableIcon onKeyTapped(IGuiAction.KeyPressed onKeyTapped) {
        this.onKeyTapped = onKeyTapped;
        return this;
    }

    @NotNull
    @Generated
    public InteractableIcon playClickSound(boolean playClickSound) {
        this.playClickSound = playClickSound;
        return this;
    }
}

