/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.drawable;

import brachy.modularui.api.GuiAxis;
import brachy.modularui.api.drawable.IDrawable;
import brachy.modularui.drawable.GuiDraw;
import brachy.modularui.screen.viewport.GuiContext;
import brachy.modularui.theme.WidgetTheme;
import brachy.modularui.utils.Color;

public class HueBar
implements IDrawable {
    private static final int[] COLORS = new int[]{Color.ofHSV(60.0f, 1.0f, 1.0f, 1.0f), Color.ofHSV(120.0f, 1.0f, 1.0f, 1.0f), Color.ofHSV(180.0f, 1.0f, 1.0f, 1.0f), Color.ofHSV(240.0f, 1.0f, 1.0f, 1.0f), Color.ofHSV(300.0f, 1.0f, 1.0f, 1.0f), Color.ofHSV(0.0f, 1.0f, 1.0f, 1.0f)};
    private final GuiAxis axis;

    public HueBar(GuiAxis axis) {
        this.axis = axis;
    }

    @Override
    public void draw(GuiContext context, int x, int y, int width, int height, WidgetTheme widgetTheme) {
        this.applyColor(widgetTheme.getColor());
        int size = this.axis.isHorizontal() ? width : height;
        float step = (float)size / 6.0f;
        int previous = COLORS[5];
        for (int i = 0; i < 6; ++i) {
            int current = COLORS[i];
            if (this.axis.isHorizontal()) {
                GuiDraw.drawHorizontalGradientRect(context.getGraphics(), (float)x + step * (float)i, y, step, height, previous, current);
            } else {
                GuiDraw.drawVerticalGradientRect(context.getGraphics(), x, (float)y + step * (float)i, width, step, previous, current);
            }
            previous = current;
        }
    }
}

