/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.client.schemarenderer;

import lombok.Generated;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Camera {
    private final Vector3f pos = new Vector3f();
    private final Vector3f lookAt = new Vector3f();
    private final Vector3f temp = new Vector3f();
    private float yaw;
    private float pitch;
    private float dist;

    public Camera setPosAndLookAt(Vector3f pos, Vector3f lookAt) {
        return this.setPosAndLookAt(pos.x, pos.y, pos.z, lookAt.x, lookAt.y, lookAt.z);
    }

    public Camera setPosAndLookAt(float xPos, float yPos, float zPos, Vector3f lookAt) {
        return this.setPosAndLookAt(xPos, yPos, zPos, lookAt.x, lookAt.y, lookAt.z);
    }

    public Camera setPosAndLookAt(Vector3f pos, float xLook, float yLook, float zLook) {
        return this.setPosAndLookAt(pos.x, pos.y, pos.z, xLook, yLook, zLook);
    }

    public Camera setPosAndLookAt(float xPos, float yPos, float zPos, float xLook, float yLook, float zLook) {
        this.pos.set(xPos, yPos, zPos);
        this.lookAt.set(xLook, yLook, zLook);
        Vector3f v = this.temp.set((Vector3fc)this.lookAt).sub((Vector3fc)this.pos).normalize();
        this.yaw = (float)Math.atan2(-v.x, v.z);
        this.pitch = (float)Math.asin(-v.y);
        this.dist = this.pos.distance((Vector3fc)this.lookAt);
        return this;
    }

    public Camera setLookAtKeepPos(float x, float y, float z) {
        this.setPosAndLookAt(this.pos, x, y, z);
        return this;
    }

    public Camera setLookAtKeepAngle(float x, float y, float z) {
        this.temp.set(x, y, z);
        this.temp.sub((Vector3fc)this.lookAt, this.temp);
        this.pos.add((Vector3fc)this.temp);
        this.lookAt.set((Vector3fc)this.temp);
        return this;
    }

    public Camera setPosKeepLookAt(float x, float y, float z) {
        return this.setPosAndLookAt(x, y, z, this.lookAt);
    }

    public Camera setPosKeepAngle(float x, float y, float z) {
        this.temp.set(x, y, z);
        this.temp.sub((Vector3fc)this.pos, this.temp);
        this.lookAt.add((Vector3fc)this.temp);
        this.pos.set((Vector3fc)this.temp);
        return this;
    }

    public Camera setAngleKeepLookAt(float radius, float yaw, float pitch) {
        return this.setLookAtAndAngle(this.lookAt, radius, yaw, pitch);
    }

    public Camera setLookAtAndAngle(Vector3f lookAt, float radius, float yaw, float pitch) {
        return this.setLookAtAndAngle(lookAt.x, lookAt.y, lookAt.z, radius, yaw, pitch);
    }

    public Camera setLookAtAndAngle(Vec3i lookAt, float radius, float yaw, float pitch) {
        return this.setLookAtAndAngle(lookAt.m_123341_(), lookAt.m_123342_(), lookAt.m_123343_(), radius, yaw, pitch);
    }

    public Camera setLookAtAndAngle(float lookAtX, float lookAtY, float lookAtZ, float dist, float yaw, float pitch) {
        this.lookAt.set(lookAtX, lookAtY, lookAtZ);
        this.yaw = yaw;
        this.pitch = pitch;
        this.dist = dist;
        Vector3f v = this.temp;
        v.set(Mth.m_14089_((float)yaw), 0.0f, Mth.m_14031_((float)yaw));
        v.y = (float)Math.tan(pitch) * v.length();
        v.normalize().mul(dist);
        this.pos.set((Vector3fc)v.add(lookAtX, lookAtY, lookAtZ));
        return this;
    }

    public Camera setPosAndAngle(float posX, float posY, float posZ, float dist, float yaw, float pitch) {
        this.pos.set(posX, posY, posZ);
        this.yaw = yaw;
        this.pitch = pitch;
        this.dist = dist;
        Vector3f v = this.temp;
        v.set(Mth.m_14089_((float)(1.5707964f - yaw)), 0.0f, Mth.m_14031_((float)(1.5707964f - yaw)));
        v.y = (float)Math.tan(1.5707964f - pitch) * v.length();
        v.normalize().mul(dist);
        this.lookAt.set((Vector3fc)v).add((Vector3fc)this.pos);
        return this;
    }

    public void setDistanceKeepLookAt(float dist) {
        if (dist == this.dist) {
            return;
        }
        this.dist = dist;
        this.pos.sub((Vector3fc)this.lookAt, this.temp);
        this.temp.normalize().mul(dist);
        this.lookAt.sub((Vector3fc)this.temp, this.pos);
    }

    public void scaleDistanceKeepLookAt(float dist) {
        if (dist == 1.0f) {
            return;
        }
        this.dist *= dist;
        this.pos.sub((Vector3fc)this.lookAt, this.temp);
        this.temp.mul(dist);
        this.lookAt.add((Vector3fc)this.temp, this.pos);
    }

    public Vector3f getLookVec() {
        return this.getLookVec(null);
    }

    public Vector3f getLookVec(@Nullable Vector3f dest) {
        if (dest == null) {
            dest = new Vector3f();
        }
        return this.lookAt.sub((Vector3fc)this.pos, dest);
    }

    @Generated
    public Vector3f pos() {
        return this.pos;
    }

    @Generated
    public Vector3f lookAt() {
        return this.lookAt;
    }

    @Generated
    public float yaw() {
        return this.yaw;
    }

    @Generated
    public float pitch() {
        return this.pitch;
    }

    @Generated
    public float dist() {
        return this.dist;
    }
}

