/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.client.schemarenderer;

import brachy.modularui.utils.Color;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import lombok.Generated;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class BlockHighlight {
    protected static final float[][] vertices = new float[6][12];
    private int color;
    private boolean allSides;
    private float thickness;

    public BlockHighlight(int color) {
        this(color, true);
    }

    public BlockHighlight(int color, float frameThickness) {
        this(color, true, frameThickness);
    }

    public BlockHighlight(int color, boolean allSides) {
        this(color, allSides, 0.0f);
    }

    public BlockHighlight(int color, boolean allSides, float frameThickness) {
        this.color = color;
        this.allSides = allSides;
        this.thickness = frameThickness;
    }

    public final void renderHighlight(PoseStack pose, @Nullable BlockHitResult result, Vector3f camera) {
        if (result != null && result.m_6662_() == HitResult.Type.BLOCK) {
            this.renderHighlight(pose, result.m_82425_(), result.m_82434_(), camera);
        }
    }

    public void renderHighlight(PoseStack poseStack, BlockPos pos, Direction direction, Vector3f camera) {
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172808_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Color.setGlColor(this.color);
        poseStack.m_85836_();
        poseStack.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
        float distance = camera.distance((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 0.5f, (float)pos.m_123343_() + 0.5f);
        this.doRender(poseStack, direction, distance);
        poseStack.m_85849_();
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
    }

    protected void doRender(PoseStack poseStack, @Nullable Direction direction, float distance) {
        if (this.allSides) {
            direction = null;
        }
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        if (this.thickness >= 0.0f) {
            float offset = (float)((double)this.thickness * (1.0 + Math.max(0.0, Math.sqrt(distance) - 3.0) / 5.0));
            BlockHighlight.renderFrame(pose, direction, offset);
        } else {
            BlockHighlight.renderSolid(pose, direction);
        }
    }

    public static void renderSolid(Matrix4f pose, @Nullable Direction direction) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        if (direction == null) {
            for (Direction dir : Direction.values()) {
                BlockHighlight.buildFace(pose, builder, dir);
            }
        } else {
            BlockHighlight.buildFace(pose, builder, direction);
        }
    }

    protected static void renderFrame(Matrix4f pose, @Nullable Direction side, float offset) {
        if (side == null) {
            for (Direction dir : Direction.values()) {
                BlockHighlight.buildFrameFace(pose, dir, offset);
            }
        } else {
            BlockHighlight.buildFrameFace(pose, side, offset);
        }
    }

    protected static void buildFrameFace(Matrix4f pose, @NotNull Direction side, float offset) {
        float[] vert = vertices[side.m_122411_()];
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85814_);
        BlockHighlight.buildVertex(pose, builder, vert, 9);
        BlockHighlight.buildInnerVertex(pose, builder, vert, 9, side, offset);
        BlockHighlight.buildVertex(pose, builder, vert, 6);
        BlockHighlight.buildInnerVertex(pose, builder, vert, 6, side, offset);
        BlockHighlight.buildVertex(pose, builder, vert, 3);
        BlockHighlight.buildInnerVertex(pose, builder, vert, 3, side, offset);
        BlockHighlight.buildVertex(pose, builder, vert, 0);
        BlockHighlight.buildInnerVertex(pose, builder, vert, 0, side, offset);
        BlockHighlight.buildVertex(pose, builder, vert, 9);
        BlockHighlight.buildInnerVertex(pose, builder, vert, 9, side, offset);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
    }

    protected static void buildVertex(Matrix4f pose, BufferBuilder builder, float[] vertices, int vertexIndex) {
        float x = vertices[vertexIndex];
        float y = vertices[vertexIndex + 1];
        float z = vertices[vertexIndex + 2];
        builder.m_252986_(pose, x, y, z).m_5752_();
    }

    private static void buildInnerVertex(Matrix4f pose, BufferBuilder builder, float[] vertices, int vertexIndex, @NotNull Direction side, float offset) {
        float x = vertices[vertexIndex];
        float y = vertices[vertexIndex + 1];
        float z = vertices[vertexIndex + 2];
        if (side.m_122434_() != Direction.Axis.X) {
            x = x >= 1.0f ? (x -= offset) : (x += offset);
        }
        if (side.m_122434_() != Direction.Axis.Y) {
            y = y >= 1.0f ? (y -= offset) : (y += offset);
        }
        if (side.m_122434_() != Direction.Axis.Z) {
            z = z >= 1.0f ? (z -= offset) : (z += offset);
        }
        builder.m_252986_(pose, x, y, z).m_5752_();
    }

    protected static void buildFace(Matrix4f pose, BufferBuilder builder, @NotNull Direction side) {
        float[] vert = vertices[side.ordinal()];
        BlockHighlight.buildVertex(pose, builder, vert, 0);
        BlockHighlight.buildVertex(pose, builder, vert, 3);
        BlockHighlight.buildVertex(pose, builder, vert, 6);
        BlockHighlight.buildVertex(pose, builder, vert, 9);
    }

    @Generated
    public int color() {
        return this.color;
    }

    @NotNull
    @Generated
    public BlockHighlight color(int color) {
        this.color = color;
        return this;
    }

    @Generated
    public boolean allSides() {
        return this.allSides;
    }

    @NotNull
    @Generated
    public BlockHighlight allSides(boolean allSides) {
        this.allSides = allSides;
        return this;
    }

    @Generated
    public float thickness() {
        return this.thickness;
    }

    @NotNull
    @Generated
    public BlockHighlight thickness(float thickness) {
        this.thickness = thickness;
        return this;
    }

    static {
        int[][] intVertices = new int[][]{{1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0}, {0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0}, {0, 1, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0}, {0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1}, {0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 1, 0}, {1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 0, 0}};
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 12; ++j) {
                int v = intVertices[i][j];
                BlockHighlight.vertices[i][j] = v == 1 ? 1.005f : -0.005f;
            }
        }
    }
}

