/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.client.schemarenderer;

import brachy.modularui.ModularUI;
import brachy.modularui.api.drawable.IDrawable;
import brachy.modularui.client.schemarenderer.Camera;
import brachy.modularui.client.schemarenderer.DummyLightTexture;
import brachy.modularui.client.schemarenderer.LiquidVertexConsumer;
import brachy.modularui.client.schemarenderer.RenderLevel;
import brachy.modularui.drawable.Icon;
import brachy.modularui.integration.embeddium.SodiumCompat;
import brachy.modularui.schema.ISchema;
import brachy.modularui.screen.viewport.GuiContext;
import brachy.modularui.theme.WidgetTheme;
import brachy.modularui.utils.Color;
import brachy.modularui.utils.FluidTextureType;
import brachy.modularui.utils.GTMatrixUtils;
import brachy.modularui.widget.sizer.Area;
import brachy.modularui.widgets.SchemaWidget;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.CrashReport;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ChunkBufferBuilderPack;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BaseSchemaRenderer
implements IDrawable {
    private static final DummyLightTexture lightTexture = new DummyLightTexture();
    private final ISchema schema;
    private final RenderLevel renderLevel;
    @Nullable
    private RenderCompileTask lastRenderCompileTask = null;
    private final Camera camera = new Camera();
    private final int[] viewport = new int[]{0, 0, 0, 0};
    @Nullable
    private BlockHitResult lastRayTrace = null;
    private final ChunkBufferBuilderPack chunkBufferBuilders;
    private final AtomicReference<RenderCompileResults> compileResults = new AtomicReference();
    private final AtomicReference<CompileStatus> compileStatus = new AtomicReference<CompileStatus>(CompileStatus.CANCELED);
    @Nullable
    private Map<RenderType, VertexBuffer> chunkBuffers = this.getOrCreateChunkBuffers();

    public BaseSchemaRenderer(ISchema schema) {
        this.schema = schema;
        this.renderLevel = new RenderLevel(schema);
        this.chunkBufferBuilders = new ChunkBufferBuilderPack();
    }

    @NotNull
    protected Map<RenderType, VertexBuffer> getOrCreateChunkBuffers() {
        if (this.chunkBuffers == null || this.chunkBuffers.isEmpty()) {
            List chunkRenderTypes = RenderType.m_110506_();
            this.chunkBuffers = new Reference2ObjectLinkedOpenHashMap();
            for (RenderType type : chunkRenderTypes) {
                this.chunkBuffers.put(type, new VertexBuffer(VertexBuffer.Usage.STATIC));
            }
        }
        return this.chunkBuffers;
    }

    public void clearChunkBuffers() {
        if (this.lastRenderCompileTask != null) {
            this.lastRenderCompileTask.cancel();
            this.lastRenderCompileTask = null;
        }
        if (this.chunkBuffers != null && !this.chunkBuffers.isEmpty()) {
            this.chunkBuffers.values().forEach(VertexBuffer::close);
            this.chunkBuffers.clear();
        }
    }

    public void recompile() {
        this.clearChunkBuffers();
        this.compileStatus.set(CompileStatus.COMPILING);
        this.lastRenderCompileTask = new RenderCompileTask();
        ((CompletableFuture)CompletableFuture.supplyAsync(Util.m_183946_((String)"scm_chk_rebuild", this.lastRenderCompileTask::compileBlockBuffers), Util.m_183991_()).thenCompose(Function.identity())).whenComplete((result, error) -> {
            if (error != null) {
                Minecraft.m_91087_().m_231412_(CrashReport.m_127521_((Throwable)error, (String)"Batching chunks"));
            } else {
                if (result != CompileStatus.CANCELED && result != CompileStatus.DISABLED) {
                    this.chunkBufferBuilders.m_108838_();
                } else {
                    this.chunkBufferBuilders.m_108841_();
                }
                this.compileStatus.set((CompileStatus)((Object)result));
            }
        });
    }

    public void dispose() {
        this.clearChunkBuffers();
        this.chunkBufferBuilders.m_108841_();
        this.compileStatus.set(CompileStatus.DISABLED);
    }

    public SchemaWidget asWidget() {
        return new SchemaWidget(this);
    }

    @Override
    public Icon asIcon() {
        return IDrawable.super.asIcon().size(50);
    }

    @Override
    public void draw(GuiContext context, int x, int y, int width, int height, WidgetTheme widgetTheme) {
        int mouseX = context.getMouseX();
        int mouseY = context.getMouseY();
        context.getGraphics().m_280262_();
        context.graphicsPose().m_85836_();
        Window window = Minecraft.m_91087_().m_91268_();
        double guiScale = window.m_85449_();
        this.viewport[0] = Mth.m_14165_((double)((double)context.transformX(x, y) * guiScale));
        this.viewport[1] = window.m_85442_() - Mth.m_14165_((double)((double)(context.transformY(x, y) + height) * guiScale));
        this.viewport[2] = Mth.m_14165_((double)((double)width * guiScale));
        this.viewport[3] = Mth.m_14165_((double)((double)height * guiScale));
        RenderSystem.viewport((int)this.viewport[0], (int)this.viewport[1], (int)this.viewport[2], (int)this.viewport[3]);
        this.onSetupCamera();
        this.setupCamera(width, height);
        this.renderWorld(context.getGraphics().m_280091_(), context.getPartialTicks());
        if (this.doRayTrace()) {
            BlockHitResult result = null;
            if (Area.isInside(x, y, width, height, mouseX, mouseY)) {
                result = this.rayTrace(mouseX, mouseY, width, height);
            }
            if (result == null || result.m_6662_() != HitResult.Type.BLOCK) {
                if (this.lastRayTrace != null) {
                    this.onRayTraceFailed();
                }
            } else {
                this.onSuccessfulRayTrace(context.graphicsPose(), result);
            }
            this.lastRayTrace = result;
        }
        this.resetCamera();
        context.graphicsPose().m_85849_();
    }

    public void renderWorld(MultiBufferSource.BufferSource bufferSource, float partialTick) {
        CompileStatus status = this.compileStatus.get();
        if (status == CompileStatus.DISABLED || status == CompileStatus.COMPILING) {
            return;
        }
        if (status == CompileStatus.CANCELED) {
            this.recompile();
            return;
        }
        RenderSystem.setShaderFogColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f);
        RenderSystem.setShaderFogStart((float)0.0f);
        RenderSystem.setShaderFogEnd((float)1000.0f);
        RenderSystem.setShaderFogShape((FogShape)FogShape.SPHERE);
        lightTexture.update(this.renderLevel);
        LevelLightEngine lightEngine = this.renderLevel.m_5518_();
        while (lightEngine.m_75808_()) {
            lightEngine.m_9323_();
        }
        Lighting.m_252756_((Matrix4f)RenderSystem.getModelViewMatrix());
        RenderSystem.disableDepthTest();
        RenderSystem.clear((int)256, (boolean)Minecraft.f_91002_);
        RenderSystem.runAsFancy(() -> {
            this.renderBlocks(RenderType.m_110451_());
            Minecraft.m_91087_().m_91304_().m_119428_(TextureAtlas.f_118259_).setBlurMipmap(false, (Integer)Minecraft.m_91087_().f_91066_.m_232119_().m_231551_() > 0);
            this.renderBlocks(RenderType.m_110457_());
            Minecraft.m_91087_().m_91304_().m_119428_(TextureAtlas.f_118259_).restoreLastBlurMipmap();
            this.renderBlocks(RenderType.m_110463_());
            bufferSource.m_109912_(RenderType.m_110446_((ResourceLocation)TextureAtlas.f_118259_));
            bufferSource.m_109912_(RenderType.m_110452_((ResourceLocation)TextureAtlas.f_118259_));
            bufferSource.m_109912_(RenderType.m_110458_((ResourceLocation)TextureAtlas.f_118259_));
            bufferSource.m_109912_(RenderType.m_110476_((ResourceLocation)TextureAtlas.f_118259_));
            if (this.isBEREnabled()) {
                this.renderBlockEntities((MultiBufferSource)bufferSource, partialTick);
            }
            bufferSource.m_109912_(RenderType.m_110451_());
            bufferSource.m_109912_(RenderType.m_173239_());
            bufferSource.m_109912_(RenderType.m_173242_());
            bufferSource.m_109912_(Sheets.m_110789_());
            bufferSource.m_109912_(Sheets.m_110790_());
            bufferSource.m_109912_(Sheets.m_110785_());
            bufferSource.m_109912_(Sheets.m_110786_());
            bufferSource.m_109912_(Sheets.m_110787_());
            bufferSource.m_109912_(Sheets.m_246640_());
            bufferSource.m_109912_(Sheets.m_110788_());
            bufferSource.m_173043_();
            this.renderBlocks(RenderType.m_110466_());
            this.renderBlocks(RenderType.m_110503_());
        });
        RenderSystem.enableDepthTest();
    }

    protected void renderBlocks(RenderType renderType) {
        renderType.m_110185_();
        ModelBlockRenderer.m_111000_();
        ShaderInstance shader = RenderSystem.getShader();
        assert (shader != null);
        for (int i = 0; i < 12; ++i) {
            int textureId = RenderSystem.getShaderTexture((int)i);
            shader.m_173350_("Sampler" + i, (Object)textureId);
        }
        if (shader.f_173308_ != null) {
            shader.f_173308_.m_5679_(RenderSystem.getModelViewMatrix());
        }
        if (shader.f_173309_ != null) {
            shader.f_173309_.m_5679_(RenderSystem.getProjectionMatrix());
        }
        if (shader.f_200956_ != null) {
            shader.f_200956_.m_200759_(RenderSystem.getInverseViewRotationMatrix());
        }
        if (shader.f_173312_ != null) {
            shader.f_173312_.m_5941_(RenderSystem.getShaderColor());
        }
        if (shader.f_267422_ != null) {
            shader.f_267422_.m_5985_(RenderSystem.getShaderGlintAlpha());
        }
        if (shader.f_173315_ != null) {
            shader.f_173315_.m_5985_(RenderSystem.getShaderFogStart());
        }
        if (shader.f_173316_ != null) {
            shader.f_173316_.m_5985_(RenderSystem.getShaderFogEnd());
        }
        if (shader.f_173317_ != null) {
            shader.f_173317_.m_5941_(RenderSystem.getShaderFogColor());
        }
        if (shader.f_202432_ != null) {
            shader.f_202432_.m_142617_(RenderSystem.getShaderFogShape().m_202324_());
        }
        if (shader.f_173310_ != null) {
            shader.f_173310_.m_5679_(RenderSystem.getTextureMatrix());
        }
        if (shader.f_173319_ != null) {
            shader.f_173319_.m_5985_(RenderSystem.getShaderGameTime());
        }
        if (shader.f_173311_ != null) {
            Window window = Minecraft.m_91087_().m_91268_();
            shader.f_173311_.m_7971_((float)window.m_85441_(), (float)window.m_85442_());
        }
        if (shader.f_173320_ != null) {
            shader.f_173320_.m_5889_(-this.camera.pos().x, -this.camera.pos().y, -this.camera.pos().z);
        }
        RenderSystem.setupShaderLights((ShaderInstance)shader);
        shader.m_173363_();
        RenderCompileResults compileResults = this.compileResults.get();
        if (compileResults != null && !compileResults.isEmpty(renderType)) {
            VertexBuffer vertexBuffer;
            if (ModularUI.Mods.isSodiumLikeLoaded()) {
                SodiumCompat.markSpritesAsActive(compileResults.activeFluidSprites);
            }
            if ((vertexBuffer = this.getOrCreateChunkBuffers().get(renderType)).m_231230_() || vertexBuffer.m_166892_() == null) {
                return;
            }
            vertexBuffer.m_85921_();
            vertexBuffer.m_166882_();
        }
        shader.m_173362_();
        VertexBuffer.m_85931_();
        renderType.m_110188_();
    }

    protected void renderBlockEntities(MultiBufferSource bufferSource, float partialTick) {
        PoseStack poseStack = new PoseStack();
        RenderCompileResults compileResults = this.compileResults.get();
        if (compileResults == null) {
            return;
        }
        for (BlockEntity blockEntity : compileResults.blockEntities) {
            if (blockEntity == null) continue;
            this.handleBlockEntity(poseStack, bufferSource, partialTick, blockEntity);
        }
    }

    protected <E extends BlockEntity> void handleBlockEntity(PoseStack poseStack, MultiBufferSource bufferSource, float partialTick, E blockEntity) {
        BlockEntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_167982_();
        BlockEntityRenderer renderer = dispatcher.m_112265_(blockEntity);
        if (renderer == null) {
            return;
        }
        BlockPos pos = blockEntity.m_58899_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)pos.m_123341_() - this.camera.pos().x, (float)pos.m_123342_() - this.camera.pos().y, (float)pos.m_123343_() - this.camera.pos().z);
        int packedLight = LevelRenderer.m_109541_((BlockAndTintGetter)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_());
        renderer.m_6922_(blockEntity, partialTick, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
        poseStack.m_85849_();
    }

    protected void setupCamera(int width, int height) {
        int clearColor = this.getClearColor();
        RenderSystem.clearColor((float)Color.getRedF(clearColor), (float)Color.getGreenF(clearColor), (float)Color.getBlueF(clearColor), (float)Color.getAlphaF(clearColor));
        RenderSystem.backupProjectionMatrix();
        float near = 0.05f;
        float far = 10000.0f;
        float fovY = 1.0471976f;
        float aspect = (float)width / (float)height;
        float top = -near * (float)Math.tan((double)fovY * 0.5);
        float bottom = -top;
        float left = aspect * bottom;
        float right = aspect * top;
        Matrix4f projection = new Matrix4f();
        if (this.isIsometric()) {
            projection.setOrtho(left, right, bottom, top, near, far);
            RenderSystem.setProjectionMatrix((Matrix4f)projection, (VertexSorting)VertexSorting.f_276633_);
        } else {
            projection.setPerspective(fovY, aspect, near, far);
            RenderSystem.setProjectionMatrix((Matrix4f)projection, (VertexSorting)VertexSorting.m_276997_((Vector3f)this.camera.pos()));
        }
        PoseStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.m_85836_();
        modelViewStack.m_166856_();
        if (this.isIsometric()) {
            modelViewStack.m_252880_(0.0f, 0.0f, -2000.0f);
        }
        GTMatrixUtils.lookAt(modelViewStack, (Vector3fc)this.camera.pos(), (Vector3fc)this.camera.lookAt());
        RenderSystem.applyModelViewMatrix();
    }

    protected void resetCamera() {
        Window window = Minecraft.m_91087_().m_91268_();
        RenderSystem.viewport((int)0, (int)0, (int)window.m_85441_(), (int)window.m_85442_());
        RenderSystem.restoreProjectionMatrix();
        RenderSystem.getModelViewStack().m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    protected BlockHitResult rayTrace(int mouseX, int mouseY, int width, int height) {
        Vector3f worldPos = this.screenToWorldPos((float)mouseX / (float)width, (float)mouseY / (float)height);
        Vector3f target = this.camera.getLookVec().mul(20.0f).add((Vector3fc)worldPos);
        ClipContext context = new ClipContext(new Vec3(worldPos), new Vec3(target), ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, null);
        return this.renderLevel.m_45547_(context);
    }

    protected Vector3f screenToWorldPos(float x, float y) {
        int wx = (int)(x * (float)this.viewport[2]);
        int wy = (int)(y * (float)this.viewport[3]);
        return GTMatrixUtils.projectScreenToWorld(wx, wy, this.viewport, true);
    }

    @ApiStatus.OverrideOnly
    protected void onSetupCamera() {
    }

    @ApiStatus.OverrideOnly
    protected void onRendered() {
    }

    @ApiStatus.OverrideOnly
    protected void onSuccessfulRayTrace(PoseStack poseStack, @NotNull BlockHitResult result) {
    }

    @ApiStatus.OverrideOnly
    protected void onRayTraceFailed() {
    }

    public boolean doRayTrace() {
        return false;
    }

    public int getClearColor() {
        return Color.withAlpha(Color.WHITE.main, 0.5f);
    }

    public boolean isIsometric() {
        return false;
    }

    public boolean isBEREnabled() {
        return true;
    }

    @Generated
    public ISchema schema() {
        return this.schema;
    }

    @Generated
    public Camera camera() {
        return this.camera;
    }

    @Nullable
    @Generated
    public BlockHitResult lastRayTrace() {
        return this.lastRayTrace;
    }

    protected class RenderCompileTask {
        private final AtomicBoolean isCanceled = new AtomicBoolean(false);

        protected RenderCompileTask() {
        }

        public void cancel() {
            this.isCanceled.set(true);
        }

        protected CompletableFuture<CompileStatus> compileBlockBuffers() {
            BufferBuilder bufferBuilder;
            if (this.isCanceled.get()) {
                return CompletableFuture.completedFuture(CompileStatus.CANCELED);
            }
            BlockRenderDispatcher blockRenderDispatcher = Minecraft.m_91087_().m_91289_();
            ChunkBufferBuilderPack chunkBufferBuilders = BaseSchemaRenderer.this.chunkBufferBuilders;
            RenderCompileResults compileResults = new RenderCompileResults();
            RandomSource randomSource = RandomSource.m_216327_();
            PoseStack poseStack = new PoseStack();
            ReferenceArraySet startedBuffers = new ReferenceArraySet(RenderType.m_110506_().size());
            ModelBlockRenderer.m_111000_();
            for (Map.Entry blockEntry : BaseSchemaRenderer.this.schema) {
                BlockEntity blockEntity;
                BlockPos pos = (BlockPos)blockEntry.getKey();
                BlockState blockState = (BlockState)blockEntry.getValue();
                FluidState fluidState = blockState.m_60819_();
                if (blockState.m_155947_() && (blockEntity = BaseSchemaRenderer.this.renderLevel.m_7702_(pos)) != null) {
                    compileResults.blockEntities.add(blockEntity);
                }
                if (!fluidState.m_76178_()) {
                    RenderType renderType2 = ItemBlockRenderTypes.m_109287_((FluidState)fluidState);
                    BufferBuilder builder = chunkBufferBuilders.m_108839_(renderType2);
                    if (startedBuffers.add(renderType2)) {
                        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
                    }
                    SectionPos sectionPos = SectionPos.m_123199_((BlockPos)pos);
                    LiquidVertexConsumer vertexConsumer = new LiquidVertexConsumer((VertexConsumer)builder, sectionPos);
                    blockRenderDispatcher.m_234363_(pos, (BlockAndTintGetter)BaseSchemaRenderer.this.renderLevel, (VertexConsumer)vertexConsumer, blockState, fluidState);
                    RenderCompileTask.markFluidSpritesActive(compileResults, fluidState);
                }
                if (blockState.m_60799_() == RenderShape.INVISIBLE) continue;
                BakedModel model = blockRenderDispatcher.m_110910_(blockState);
                BlockEntity blockEntity2 = BaseSchemaRenderer.this.renderLevel.m_7702_(pos);
                ModelData modelData = ModelData.EMPTY;
                if (blockEntity2 != null) {
                    modelData = blockEntity2.getModelData();
                }
                modelData = model.getModelData((BlockAndTintGetter)BaseSchemaRenderer.this.renderLevel, pos, blockState, modelData);
                randomSource.m_188584_(blockState.m_60726_(pos));
                for (RenderType renderType3 : model.getRenderTypes(blockState, randomSource, modelData)) {
                    BufferBuilder builder = chunkBufferBuilders.m_108839_(renderType3);
                    if (startedBuffers.add(renderType3)) {
                        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
                    }
                    poseStack.m_85836_();
                    poseStack.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
                    blockRenderDispatcher.renderBatched(blockState, pos, (BlockAndTintGetter)BaseSchemaRenderer.this.renderLevel, poseStack, (VertexConsumer)builder, true, randomSource, modelData, renderType3);
                    poseStack.m_85849_();
                }
            }
            if (startedBuffers.contains(RenderType.m_110466_()) && !(bufferBuilder = chunkBufferBuilders.m_108839_(RenderType.m_110466_())).m_231164_()) {
                bufferBuilder.m_277127_(VertexSorting.m_276997_((Vector3f)BaseSchemaRenderer.this.camera.pos()));
            }
            for (RenderType rendertype : startedBuffers) {
                BufferBuilder.RenderedBuffer renderedBuffer = chunkBufferBuilders.m_108839_(rendertype).m_231168_();
                if (renderedBuffer == null) continue;
                compileResults.renderedLayers.put(rendertype, renderedBuffer);
            }
            ModelBlockRenderer.m_111077_();
            if (this.isCanceled.get()) {
                compileResults.renderedLayers.values().forEach(BufferBuilder.RenderedBuffer::m_231200_);
                return CompletableFuture.completedFuture(CompileStatus.CANCELED);
            }
            ArrayList uploads = Lists.newArrayList();
            compileResults.renderedLayers.forEach((renderType, buffer) -> {
                uploads.add(this.uploadChunkLayer((BufferBuilder.RenderedBuffer)buffer, (RenderType)renderType));
                compileResults.hasBlocks.add((RenderType)renderType);
            });
            return Util.m_143840_((List)uploads).handle((result, error) -> {
                if (error != null && !(error instanceof CancellationException) && !(error instanceof InterruptedException)) {
                    Minecraft.m_91087_().m_231412_(CrashReport.m_127521_((Throwable)error, (String)"Rendering chunk"));
                }
                if (this.isCanceled.get()) {
                    return CompileStatus.CANCELED;
                }
                BaseSchemaRenderer.this.compileResults.set(compileResults);
                return CompileStatus.SUCCESS;
            });
        }

        protected CompletableFuture<Void> uploadChunkLayer(BufferBuilder.RenderedBuffer builder, RenderType renderType) {
            return CompletableFuture.runAsync(() -> {
                VertexBuffer buffer = BaseSchemaRenderer.this.getOrCreateChunkBuffers().get(renderType);
                if (!buffer.m_231230_()) {
                    buffer.m_85921_();
                    buffer.m_231221_(builder);
                    VertexBuffer.m_85931_();
                }
            }, runnable -> RenderSystem.recordRenderCall(runnable::run));
        }

        protected static void markFluidSpritesActive(RenderCompileResults compileResults, FluidState fluidState) {
            IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((FluidState)fluidState);
            compileResults.activeFluidSprites.add(FluidTextureType.STILL.map(props));
            compileResults.activeFluidSprites.add(FluidTextureType.FLOWING.map(props));
        }
    }

    protected static enum CompileStatus {
        DISABLED,
        COMPILING,
        SUCCESS,
        CANCELED;

    }

    protected static class RenderCompileResults {
        protected final List<BlockEntity> blockEntities = new ArrayList<BlockEntity>();
        protected final Map<RenderType, BufferBuilder.RenderedBuffer> renderedLayers = new Reference2ObjectArrayMap();
        protected final Set<TextureAtlasSprite> activeFluidSprites = new HashSet<TextureAtlasSprite>();
        protected final Set<RenderType> hasBlocks = new ObjectArraySet(RenderType.m_110506_().size());

        protected RenderCompileResults() {
        }

        public boolean isEmpty(RenderType renderType) {
            return !this.hasBlocks.contains(renderType);
        }
    }
}

