/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.client;

import brachy.modularui.ModularUI;
import brachy.modularui.api.widget.ResizeDragArea;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWImage;

public class CursorHandler {
    public static long CURSOR_NORMAL;
    public static long CURSOR_TEXT_INPUT;
    public static long CURSOR_CROSSHAIR;
    public static long CURSOR_POINT_HOVERED;
    public static long CURSOR_NOT_ALLOWED;
    public static long CURSOR_RESIZE_HORIZONTAL;
    public static long CURSOR_RESIZE_VERTICAL;
    public static long CURSOR_RESIZE_TR_BL;
    public static long CURSOR_RESIZE_TL_BR;
    public static long CURSOR_RESIZE_ALL;
    private static long windowHandle;

    public static void setCursorResizeIcon(@Nullable ResizeDragArea dragArea) {
        if (dragArea == null) {
            CursorHandler.resetCursorIcon();
            return;
        }
        long cursor = switch (dragArea) {
            default -> throw new IncompatibleClassChangeError();
            case ResizeDragArea.TOP_LEFT, ResizeDragArea.BOTTOM_RIGHT -> CURSOR_RESIZE_TL_BR;
            case ResizeDragArea.TOP_RIGHT, ResizeDragArea.BOTTOM_LEFT -> CURSOR_RESIZE_TR_BL;
            case ResizeDragArea.TOP, ResizeDragArea.BOTTOM -> CURSOR_RESIZE_VERTICAL;
            case ResizeDragArea.RIGHT, ResizeDragArea.LEFT -> CURSOR_RESIZE_HORIZONTAL;
        };
        GLFW.glfwSetCursor((long)windowHandle, (long)cursor);
    }

    public static void resetCursorIcon() {
        GLFW.glfwSetCursor((long)windowHandle, (long)CURSOR_NORMAL);
    }

    public static long createSafeCursor(int shape) {
        try (GLFWErrorCallback ignored = GLFW.glfwSetErrorCallback(null);){
            long cursor = GLFW.glfwCreateStandardCursor((int)shape);
            if (cursor == 0L) {
                ModularUI.LOGGER.warn("GLFW: Failed to create standard cursor shape {}. Falling back to default pointer.", (Object)shape);
                long l = 0L;
                return l;
            }
            long l = cursor;
            return l;
        }
    }

    public static void init() {
        windowHandle = Minecraft.m_91087_().m_91268_().m_85439_();
        CURSOR_NORMAL = CursorHandler.createSafeCursor(221185);
        CURSOR_TEXT_INPUT = CursorHandler.createSafeCursor(221186);
        CURSOR_CROSSHAIR = CursorHandler.createSafeCursor(221187);
        CURSOR_POINT_HOVERED = CursorHandler.createSafeCursor(221188);
        CURSOR_NOT_ALLOWED = CursorHandler.createSafeCursor(221194);
        CURSOR_RESIZE_HORIZONTAL = CursorHandler.createSafeCursor(221189);
        CURSOR_RESIZE_VERTICAL = CursorHandler.createSafeCursor(221190);
        CURSOR_RESIZE_TR_BL = CursorHandler.createSafeCursor(221192);
        CURSOR_RESIZE_TL_BR = CursorHandler.createSafeCursor(221191);
        CURSOR_RESIZE_ALL = CursorHandler.createSafeCursor(221193);
    }

    public static GLFWImage readGLImage(BufferedImage img, boolean inverse, boolean transpose) {
        int y;
        int size = img.getHeight();
        ByteBuffer buffer = ByteBuffer.allocate(4 * size * size);
        int n = y = inverse ? 0 : size - 1;
        while (inverse ? y < size : y >= 0) {
            for (int x = 0; x < size; ++x) {
                int y0;
                int x0;
                if (transpose) {
                    x0 = y;
                    y0 = x;
                } else {
                    x0 = x;
                    y0 = y;
                }
                int argb = img.getRGB(x0, y0);
                buffer.putInt(argb);
            }
            if (inverse) {
                ++y;
                continue;
            }
            --y;
        }
        buffer.flip();
        GLFWImage image = GLFWImage.malloc();
        image.width(size).height(size).pixels(buffer);
        return image;
    }
}

