/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.api.widget;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public interface Interactable {
    @NotNull
    default public Result onMousePressed(double mouseX, double mouseY, int button) {
        return Result.ACCEPT;
    }

    default public boolean onMouseReleased(double mouseX, double mouseY, int button) {
        return false;
    }

    @NotNull
    default public Result onMouseTapped(double mouseX, double mouseY, int button) {
        return Result.IGNORE;
    }

    @NotNull
    default public Result onKeyPressed(int keyCode, int scanCode, int modifiers) {
        return Result.IGNORE;
    }

    default public boolean onKeyReleased(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    @NotNull
    default public Result onKeyTapped(int keyCode, int scanCode, int modifiers) {
        return Result.IGNORE;
    }

    @NotNull
    default public Result onCharTyped(char codePoint, int modifiers) {
        return Result.IGNORE;
    }

    default public boolean onMouseScrolled(double mouseX, double mouseY, double delta) {
        return false;
    }

    default public void onMouseDrag(double mouseX, double mouseY, int button, double dragX, double dragY) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean hasControlDown() {
        return Screen.m_96637_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean hasShiftDown() {
        return Screen.m_96638_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean hasAltDown() {
        return Screen.m_96639_();
    }

    public static boolean isModifierActive(int mod, int key) {
        return (mod & key) != 0;
    }

    public static boolean isControl(int mod) {
        return Interactable.isModifierActive(mod, 2);
    }

    public static boolean isShift(int mod) {
        return Interactable.isModifierActive(mod, 1);
    }

    public static boolean isAlt(int mod) {
        return Interactable.isModifierActive(mod, 4);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isKeyPressed(int key) {
        return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)key);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playButtonClickSound() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }

    public static enum Result {
        IGNORE(false, false),
        ACCEPT(true, false),
        STOP(false, true),
        SUCCESS(true, true);

        public final boolean accepts;
        public final boolean stops;

        private Result(boolean accepts, boolean stops) {
            this.accepts = accepts;
            this.stops = stops;
        }
    }
}

